// The contents of this file are subject to the GNU General Public License v.2
// (C) Dmitry V. Kolvakh aka Keu


#ifndef __PARAMS_H__
#define __PARAMS_H__

#include <string>
#include <vector>
#include <stdio.h>
#include "coord.h"


class Params
{
private:
    std::vector<Coord> coords;
    bool add_river;
    char *filename;
    const char *prog_version;
    int map_number;
    int file_version;

    FILE *handle;
    void test_file();
    void usage_exit();
public:
    void parse(int argc, char *argv[]);
    void work();
    Params(const char *v) { handle = 0; map_number = 0; prog_version = v; }
    ~Params() { if(handle) fclose(handle); }
};


#endif 
