// The contents of this file are subject to the GNU General Public License v.2
// (C) Dmitry V. Kolvakh aka Keu

#include <stdio.h>
#include <string>
#include "params.h"
#include "coord.h"
#include "errors.h"


using namespace std;
//===================================================================

void Params::usage_exit()
{
    if (prog_version) printf("%s\n", prog_version);
    printf(
    "To make use of this program you MUST run it with command-line parameters.\n"
    "Usage:\n"
    "CivRiver SCENARIO_FILE +r|-r [-mN] X Y [X Y...]\n\n"

    "where\n"
    "\tSCENARIO_FILE is the filename of scenario or savegame\n"
    "\t+r or -r is a command to add or remove a river\n"
    "\t-mN is an optional parameter specifies map number, -m0 is default\n"
    "\tX and Y is coordinates of the map tile which you want to affect\n\n"
    "See README.TXT for details.\n\n"
    );
    throw Error();
}

//===================================================================

void Params::parse(int argc, char *argv[])
{
    if(argc <= 4) usage_exit();
    handle = fopen(argv[1], "r+b");
    if(!handle)
        throw Error(string("Can't open \"") + argv[1] + "\": " + strerror(errno));
    filename = argv[1];
    test_file();
    
    //--- command
    if(string("+r") == argv[2])
        add_river = true;
    else if(string("-r") == argv[2])
        add_river = false;
    else
        throw Error(string("Unknown command \"") + argv[2] + "\"");
    //--- map
    int i = 3;
    map_number = 0;
    if(argv[3][0] == '-' && argv[3][1] == 'm') {
        char *map_str;
        if(argv[3][2] != '\0') { map_str = & argv[3][2]; i++; }
        else {map_str = argv[4]; i+=2;}
        char *tail;
        int val = strtol (map_str, &tail, 0);
        if(tail[0] != 0 || val > 3 || val < 0) throw Error(string("Incorrect map number"));
        if(val > Coord::map_quantity()) throw Error(string("There isn't a map number ")
             + map_str + " in file " + filename);
        map_number = val;
    }
    //--- number of params
    if((argc - i) % 2 != 0) throw Error(string("Wrong quantity of parameters"));
    
    for(; i < argc; i+=2) coords.push_back(Coord(argv[i], argv[i+1], map_number));
}
//===================================================================

void Params::test_file()
{
    char sign[10];
    fread(sign, 1, 9, handle);
    if(string("CIVILIZE") != sign) 
        throw Error(string("Not a scenario/sav file: \"") + filename + "\"");
    // -- version
    fseek(handle, 10, SEEK_SET);
    short ver;
    fread(&ver, 2, 1, handle);
    if(0x31 == ver)
        throw Error(string("No support for ToT v1.0 files"));
    if(0x28 > ver)
        throw Error(string("No support for Civ2 versions earlier than FW"));
    file_version = ver;
    Coord::parse_map_data(handle, ver);
}
//===================================================================

void Params::work()
{
    for(int i = 0; i < coords.size(); i++) (coords[i]).change_river(add_river);
}
//===================================================================
