// The contents of this file are subject to the GNU General Public License v.2
// (C) Dmitry V. Kolvakh aka Keu


#include <cstdlib>
#include <stdio.h>
#include "params.h"
#include "errors.h"

using namespace std;

//===================================================================

const char *version = "\nCivRiver v 1.5 (c) keu\n"
                      "Modify rivers in Civ2 scenario or savegame.\n";

//===================================================================

int main(int argc, char *argv[])
{
    Params params(version);
    try {
        params.parse(argc, argv);
        params.work();
    }
    catch (Error &e){
        e.print();
        printf ("press ENTER to exit...\n");
        getc(stdin);
        return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
}
