// The contents of this file are subject to the GNU General Public License v.2
// (C) Dmitry V. Kolvakh aka Keu


#include "coord.h"
#include "errors.h"

using namespace std;

int Coord::map_width, Coord::map_height, Coord::map_tiles;
unsigned Coord::map_visible_offset, Coord::map_data_offset;
bool Coord::flat;
int Coord::maps;
int Coord::file_version;
FILE* Coord::handle;

//===========================================

void Coord::parse_map_data(FILE *h, int ver)
{
    handle = h;
    file_version = ver;
    short buf[8];
    unsigned flat_offset = 13;
    // --- ToT 1.1
    if(ver == 0x32) {
        // --- transporters
        fseek(handle, 29896, SEEK_SET);
        short trans;
        fread(&trans, 2, 1, handle);
        // --- map header
        fseek(handle, 29896+4+14*trans, SEEK_SET);
        fread(buf, 2, 8, handle);
        map_width = buf[0];
        map_height = buf[1];
        map_tiles = buf[2];
        flat = buf[3]; // see byte 653 from start of file, not this!!!  <===============================
        maps = buf[7];
        map_visible_offset = 29896 + 4 + 14*trans + 16;
        flat_offset = 653;
    // --- MGE & FW
    } else {
        fseek(handle, 13702, SEEK_SET);
        fread(buf, 2, 7, handle);
        map_width = buf[0];
        map_height = buf[1];
        map_tiles = buf[2];
        flat = buf[3]; // see byte 13 from start of file, not this!!!  <===============================
        maps = 0;
        map_visible_offset = 13716;
    }
    map_data_offset = map_visible_offset + 7*map_tiles;

//    printf("%d %d %d %d\n", map_width, map_height, map_tiles, flat);
//    printf("map_data: %x\n", map_data_offset);
}

//===================================================================
int Coord::parse_int(char *str)
{
    char *tail;
    int val = strtol (str, &tail, 0);
    if(tail[0] != 0) throw Error(string("Not a number: \"" ) + str + "\"");
    return val;
}
//===========================================

Coord::Coord(char *cx, char *cy, int m)
{
    map = m;
    x = parse_int(cx);
    y = parse_int(cy);
    if(x % 2 != y % 2  || x < 0 || y < 0 || x >= map_width || y >= map_height)
        throw Error(string("incorrect coordinates pair: ") + cx + "," + cy);
    data_offset = map_data_offset + (x/2 + y*(map_width/2)) * 6 +
                  map * (13*map_tiles +2);
    
}

//===================================================================
void Coord::change_river(bool add)
{
    fseek(handle, data_offset, SEEK_SET);
    unsigned char data;
    fread(&data, 1, 1, handle);
    if ((data & 0x0f) == 0x0a){
        printf("Ocean ignored: %d, %d\n", x, y);
        return;
    }
    if(add) data |= 0x80;
    else data &= 0x7f;
    fseek(handle, data_offset, SEEK_SET);
    fwrite(&data, 1, 1, handle);
}
//===========================================
