## Sid Meier's Civilization 4
#
# CvClipboard.py
# This file contains some nicely packaged functionality to manupulate the
# Windows clipboard from within the game.
#
# This file is part of ClipboardDemographicsMod by Vovan
# The code is based largely on clipboard.py located at:
# http://margaretmorgan.com/wesley/python/clipboard.py
#

# Import the fancy dll stuff:
import calldll
import windll

# Make dll globals:
CF_TEXT = 1
GHND = 66

user32 = windll.module('User32')
kernel32 = windll.module('Kernel32')

class CvClipboard:
	"""
		Allows the use of the Windows clipboard.
		
		Sample usage:
			import CvClipboard
			clipboard = CvClipboard.CvClipboard()
			clipboard.setText("Hello, World!")
			print "Clipboard contents: ",clipboard.getText()
	"""
	
	def getText(self):
		""" Gets the contents of the clipboard in the form of text. """
		
		if user32.OpenClipboard(0):
			hClipMemory = user32.GetClipboardData(CF_TEXT)
			lpClipMemory = kernel32.GlobalLock(hClipMemory)
			text = calldll.read_string(lpClipMemory)
			kernel32.GlobalUnlock(hClipMemory)
			user32.CloseClipboard()
			return text
		else:
			return ''
	
	def setText(self, text):
		""" Places the text passed in into the clipboard. """
		
		ctext = windll.cstring(text)
		hGlobalMemory = kernel32.GlobalAlloc(GHND, len(ctext) + 1)
		lpGlobalMemory = kernel32.GlobalLock(hGlobalMemory)
		lpGlobalMemory = kernel32.lstrcpy(lpGlobalMemory, ctext)
		kernel32.GlobalUnlock(hGlobalMemory)
		if user32.OpenClipboard(0):
			user32.EmptyClipboard()
			user32.SetClipboardData(CF_TEXT, hGlobalMemory)
			user32.CloseClipboard()
