## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## TechConquest by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup

# globals
gc = CyGlobalContext()

class TechConquest:
	def onCityAcquired(self, argsList):
		owner, playerType, city, bConquest, bTrade = argsList
		if (bConquest):
			dice = gc.getGame().getMapRand()
			pOldTeam = gc.getTeam(owner)
			pNewTeam = gc.getTeam(city.getOwner())
			pPlayer = gc.getPlayer(city.getOwner())
			lTechDiff = []
			for iLoopTech in range(gc.getNumTechInfos()):
				if ((pOldTeam.isHasTech(iLoopTech)) and (not pNewTeam.isHasTech(iLoopTech)) and (pPlayer.canResearch(iLoopTech, False))):
					lTechDiff.append(iLoopTech)
			if (len(lTechDiff) > 0):
				iRandTech = dice.get(len(lTechDiff), "TechConquest")
				iTechCost = pNewTeam.getResearchCost(lTechDiff[iRandTech])
				CyInterface().addImmediateMessage("%d" %iTechCost, "")
				
				iPercent = city.getPopulation() * 5
				iBaseTechPoints = int(iTechCost / 4)
				iExtraTechPoints = dice.get(iPercent, "TechConquest")
				iExtraTechPoints = int(iTechCost / 100 * iPercent)
				iTotalTechPoints = iBaseTechPoints + iExtraTechPoints
				iCurrentTechPoints = pNewTeam.getResearchProgress(lTechDiff[iRandTech])
				if (iTotalTechPoints > (iTechCost - iCurrentTechPoints)):
					iTotalTechPoints = iTechCost
				else:
					iTotalTechPoints = iCurrentTechPoints + iTotalTechPoints
				pNewTeam.changeResearchProgress(lTechDiff[iRandTech], iTotalTechPoints, city.getOwner())
	
				if (pPlayer.isHuman()):
					popup = PyPopup.PyPopup()
					popup.setBodyString("From the inhabitants of %s, you learn some of the secrets of %s" 
						%(city.getName(), gc.getTechInfo(lTechDiff[iRandTech]).getDescription()))
					popup.launch()



