## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## CulturalDecay by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import Popup as PyPopup
import DataStorage

# globals
gc = CyGlobalContext()
data = DataStorage.DataStorage()

class CulturalDecay:
	def __init__(self):
		self.Distance = [[0] * 11 for i in range(11)]
		for iX in range(11):
			for iY in range(11):
				if iX in [0, 1] and iY in [0, 1]:
					self.Distance[iX][iY] = 1
				else:
					self.Distance[iX][iY] = int((iX**2 + iY**2)**0.5 + (0.5**2 + 0.5**2)**0.5)
					
	def doCultureShock(self, pCity, iRadius):
		iCityX = pCity.getX()
		iCityY = pCity.getY()
		iRange = (2 * iRadius) + 1
		for iRangeX in range(iRange):
			for iRangeY in range(iRange):
				iX = iRangeX - iRadius + iCityX
				iY = iRangeY - iRadius + iCityY
				iDistanceX = abs(iRangeX - iRadius)
				iDistanceY = abs(iRangeY - iRadius)
				if (gc.getMap().isPlot(iX, iY)):
					if (iRadius >= self.Distance[iDistanceX][iDistanceY]):
						iCurrentCulture = data.getSingleVal('CulturalDecay', pCity.getID(), gc.getMap().plot(iX, iY))
						if (iCurrentCulture > -1):
							iRandNum = gc.getGame().getMapRand().get(26, "CulturalDecay")
							fRandNum = float(iRandNum) / 100 + 0.5
							iCultureChange = int(iCurrentCulture * fRandNum)
						else:
							iCultureChange = 0
						gc.getMap().plot(iX, iY).changeCulture(pCity.getOwner(), -iCultureChange, False)
						data.setSingleVal('CulturalDecay', pCity.getID(), 0, gc.getMap().plot(iX, iY))
	
	def doCultureAdd(self, pCity, iRadius):
		iCulture = pCity.getCommerceRate(gc.getInfoTypeForString('COMMERCE_CULTURE'))
		iCityX = pCity.getX()
		iCityY = pCity.getY()
		iRange = (2 * iRadius) + 1
		for iRangeX in range(iRange):
			for iRangeY in range(iRange):
				iX = iRangeX - iRadius + iCityX
				iY = iRangeY - iRadius + iCityY
				iDistanceX = abs(iRangeX - iRadius)
				iDistanceY = abs(iRangeY - iRadius)
				if (gc.getMap().isPlot(iX, iY)):
					if (iRadius >= self.Distance[iDistanceX][iDistanceY]):
						iCultureChange = ((iRadius - self.Distance[iDistanceX][iDistanceY]) * 20 + iCulture + 1)
						iCurrentCulture = data.getSingleVal('CulturalDecay', pCity.getID(), gc.getMap().plot(iX, iY))
						if (iCurrentCulture > -1):
							iCultureChange += iCurrentCulture
						data.setSingleVal('CulturalDecay', pCity.getID(), iCultureChange, gc.getMap().plot(iX, iY))
	
	def getRadius(self, pCity):
		iRadius = 0
		for iCultureLevelInfo in range(gc.getNumCultureLevelInfos()):
			pCultureLevelInfo = gc.getCultureLevelInfo(iCultureLevelInfo)
			if (pCity.getCulture(pCity.getOwner()) < pCultureLevelInfo.getSpeedThreshold(gc.getGame().getGameSpeedType())):
				iRadius = iCultureLevelInfo - 1
				break
		if (iRadius == 0):
			iRadius = iCultureLevelInfo
		return iRadius
		
	def onCityBuilt(self, argsList):
		pCity = argsList[0]
		self.doCultureAdd(pCity, self.getRadius(pCity))
	
	def onCityLost(self, argsList):
		pCity = argsList[0]
		self.doCultureShock(pCity, self.getRadius(pCity))
		
	def onCityDoTurn(self, argsList):
		pCity = argsList[0]
		self.doCultureAdd(pCity, self.getRadius(pCity))		
		
	def onEndGameTurn(self, argsList):
		pMap = CyMap()
		for iX in range(pMap.getGridWidth()):
			for iY in range(pMap.getGridHeight()):
				pPlot = pMap.plot(iX, iY)
				if (pPlot.countTotalCulture() > 0):
					for iLoop in range(gc.getMAX_PLAYERS()):
						pPlayer = gc.getPlayer(iLoop)
						if (pPlayer.isAlive()) or (pPlayer.isBarbarian()):
							iCulture = pPlot.getCulture(iLoop)
							iNumCultureCities = pPlot.getNumCultureRangeCities(iLoop)
							if (iCulture > 0) and (iNumCultureCities == 0):
								iCultureDecay = (int)(iCulture * 0.05)
								if (iCultureDecay < 1):
									iCultureDecay = 1
								pPlot.changeCulture(iLoop, -iCultureDecay, False)
