## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005

from CvPythonExtensions import *
import CvUtil
import CvEventManager
import sys
import CulturalDecay

	
gc = CyGlobalContext()

culturalDecay = CulturalDecay.CulturalDecay()

# globals
###################################################
class CvCustomEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)

	def onCityBuilt(self, argsList):
		self.parent.onCityBuilt(self, argsList)
		culturalDecay.onCityBuilt(argsList)

	def onCityLost(self, argsList):
		self.parent.onCityLost(self, argsList)
		culturalDecay.onCityLost(argsList)
		
	def onCityDoTurn(self, argsList):
		self.parent.onCityDoTurn(self, argsList)
		culturalDecay.onCityDoTurn(argsList)

	def onEndGameTurn(self, argsList):
		self.parent.onEndGameTurn(self, argsList)
		culturalDecay.onEndGameTurn(argsList)
