## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## sdEventManager by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version UnitXP 1.00


############## EVENT MANAGER GLOBALS ################
from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup
import sys

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

import CvEventManager

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho        = sdToolKit.sdEcho

################# STONE-D GLOBALS ###################
import sdUnitXP

################ 3RD PARTY GLOBALS ##################

############## EVENTMANAGER SUBCLASS ################
class sdEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)

		self.sdUnitXP         = sdUnitXP.sdUnitXP()

################ EVENT DEFINITIONS ##################
	def onCombatResult(self, argsList):
		# <sdUnitXP>
		self.sdUnitXP.sdUnitXPCombatResult(argsList)
		# </sdUnitXP>
		self.parent.onCombatResult(self, argsList)

	def onEndGameTurn(self, argsList):
		# <sdUnitXP>
		self.sdUnitXP.sdUnitXPDoVersionCheck()
		# </sdUnitXP>
		self.parent.onEndGameTurn(self, argsList)

	def onUnitCreated(self, argsList):
		# <sdUnitXP>
		self.sdUnitXP.sdUnitXPInitUnit(argsList[0])
		# </sdUnitXP>
		self.parent.onUnitCreated(self, argsList)

	def onUnitKilled(self, argsList):
		# <sdUnitXP>
		self.sdUnitXP.sdUnitXPWipeUnit(argsList[0])
		# </sdUnitXP>
		self.parent.onUnitKilled(self, argsList)

	def onUnitLost(self, argsList):
		# <sdUnitXP>
		sdEcho('Unit Lost')
		self.sdUnitXP.sdUnitXPWipeUnit(argsList[0])
		# </sdUnitXP>
		self.parent.onUnitLost(self, argsList)
	
############## 3RD PARTY DEFINITIONS ################

################ TRIGGERED EVENTS ###################
