## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## sdUnitXP by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version 1.00


from CvPythonExtensions import *
import PyHelpers
import sys
import time

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho         = sdToolKit.sdEcho
sdModLoad      = sdToolKit.sdModLoad
sdEntityInit   = sdToolKit.sdEntityInit
sdEntityWipe   = sdToolKit.sdEntityWipe
sdGetVal       = sdToolKit.sdGetVal
sdSetVal       = sdToolKit.sdSetVal
sdGetGlobal    = sdToolKit.sdGetGlobal
sdSetGlobal    = sdToolKit.sdSetGlobal
sdDelGlobal    = sdToolKit.sdDelGlobal

############### SD-CULTURE-CONQUEST #################

szModID        = 'sdUnitXP'
szVersion      = '1.00'

bUpgradeXP     = True
bShareXP       = True

class sdUnitXP:

	def sdUnitXPGetUnitID(self, unit):
		szUnitID = 'Unit_%s' %(str(unit.getID()).rjust(10, '0'))
		return szUnitID

	# Version Check and Fix
	def sdUnitXPDoVersionCheck(self):
		if ( sdGetGlobal(szModID, 'Version') == szVersion ):
			return 0
		self.sdUnitXPFixUnits()
		self.sdUnitXPUpgradeProtect()
		sdSetGlobal(szModID, 'Version', szVersion)
		sdEcho('StackXP : Upgraded to version %s' %(szVersion))
		return 1

	def sdUnitXPFixUnits(self):
		for i in range(gc.getMAX_PLAYERS()):
			iPlayer = PyPlayer(i)
			if ((iPlayer.isAlive()) or (iPlayer.isBarbarian())):
				unitList = iPlayer.getUnitList()
				mTable = sdModLoad(szModID)
				for c in range(len(unitList)):
					unit  = unitList[c]
					uType = unit.getUnitCombatType()
					if ( (uType > 0) and (uType != 4) and (not mTable.has_key(self.sdUnitXPGetUnitID(unit))) ):
						self.sdUnitXPInitUnit(unit)

	def sdUnitXPInitUnit(self, unit):
		szUnitID = self.sdUnitXPGetUnitID(unit)
		oldXP  = unit.getExperience()
		vTable = {
			'Experience' : oldXP,
			'createTurn' : gc.getGame().getGameTurn()
		}
		sdEntityInit(szModID, szUnitID, vTable)
		sdEcho('Initialized %s (%s)' %(unit.getName(), szUnitID))
		sdSetGlobal(szModID, 'LastInitUnitID', unit.getID())
		sdSetGlobal(szModID, 'LastInitUnitTM', unit.getTeam())
		sdSetGlobal(szModID, 'LastInitUnitMV', unit.getMoves())
		sdSetGlobal(szModID, 'LastInitUnitCT', gc.getGame().getGameTurn())
		sdEcho('Meh lCT=%s  GT=%s' %(sdGetGlobal(szModID, 'LastInitUnitCT'), gc.getGame().getGameTurn()))
		return oldXP

	def sdUnitXPUpgradeCheck(self, oldunit):
		u       = oldunit
		uID     = u.getID()
		uTM     = u.getTeam()
		uXP     = u.getExperience()
		try:
			lID = sdGetGlobal(szModID, 'LastInitUnitID')
			lTM = sdGetGlobal(szModID, 'LastInitUnitTM')
			lMV = sdGetGlobal(szModID, 'LastInitUnitMV')
			lCT = sdGetGlobal(szModID, 'LastInitUnitCT')
		except:
			return 0
		if ( (bUpgradeXP) and (lTM == uTM) and (lMV == 0) and (lCT == gc.getGame().getGameTurn()) ):
			gc.getActivePlayer().getUnit(lID).setExperience(uXP, -1)
		self.sdUnitXPUpgradeProtect()

	def sdUnitXPUpgradeProtect(self):
		sdDelGlobal(szModID, 'LastInitUnitID')
		sdDelGlobal(szModID, 'LastInitUnitTM')
		sdDelGlobal(szModID, 'LastInitUnitMV')
		sdDelGlobal(szModID, 'LastInitUnitCT')

	def sdUnitXPWipeUnit(self, unit):
		self.sdUnitXPUpgradeCheck(unit)
		szUnitID = self.sdUnitXPGetUnitID(unit)
		sdEntityWipe(szModID, szUnitID)
		sdEcho('Purging %s (%s)' %(szUnitID, unit.getName()))
		return 0

	def sdUnitXPCombatResult(self, argsList):
		u       = argsList[0]
		uPlot   = u.plot()
		uType   = u.getUnitCombatType()

		self.sdUnitXPUpgradeProtect()

		typesTable = {
			'-1' : 'Unknown',
			'0'  : 'None',
			'1'  : 'Archer',
			'2'  : 'Mounted',
			'3'  : 'Melee',
			'4'  : 'Siege',
			'5'  : 'Gun',
			'6'  : 'Armor',
			'7'  : 'Helicopter',
			'8'  : 'Naval'
		}

		if (uPlot.getNumUnits() < 2): # He's on his lonesome!
			return 0

		if ( (uType < 1) or (uType == 4) ): # People don't learn from siege weapons.
			sdEcho('StackXP : %s unit is invalid for stack distribution.' %(typesTable[str(uType)]))
			return 0

		try:
			oXP = sdGetVal(szModID, self.sdUnitXPGetUnitID(u), 'Experience')
		except:
			oXP = self.sdUnitXPInitUnit(u)-1
	
		dXP     = u.getExperience()-oXP
		if ( (not bShareXP) or (dXP < 1) ):
			sdSetVal(szModID, self.sdUnitXPGetUnitID(u), 'Experience', u.getExperience())
			return 0
		sdEcho('StackXP : %s %s (%s) : Distributing %s (%s-%s) Experience Points.' %(typesTable[str(uType)], u.getName(), self.sdUnitXPGetUnitID(u), dXP, u.getExperience(), oXP))
		u.setExperience(oXP, -1)

		# Look for the crappiest unit in the stack with the same combat type as the winner.
		w       = u
		while (dXP > 0):
			for i in range(uPlot.getNumUnits()):
				pUnit = CyInterface().getInterfacePlotUnit(uPlot, i)
				if (pUnit):
					if ( (pUnit.getID() != w.getID()) and (pUnit.getTeam() == u.getTeam()) and (pUnit.getUnitCombatType() == u.getUnitCombatType()) and (pUnit.getExperience() < w.getExperience()) ):
						w       = pUnit
			# sdEcho('StackXP : Plus 1 XP to %s %s (%s)' %(w.getName(), self.sdUnitXPGetUnitID(w), w.getExperience()))
			w.setExperience((w.getExperience()+1), -1)
			sdSetVal(szModID, self.sdUnitXPGetUnitID(u), 'Experience', w.getExperience())
			sdEcho('StackXP : Gave 1 XP to %s %s (%s)' %(w.getName(), self.sdUnitXPGetUnitID(w), w.getExperience()))
			dXP -= 1
		sdSetVal(szModID, self.sdUnitXPGetUnitID(u), 'Experience', u.getExperience())
		return 0
