## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## sdStackXP by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version 1.20


from CvPythonExtensions import *
import PyHelpers
import sys

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho         = sdToolKit.sdEcho
sdGetTimeInt   = sdToolKit.sdGetTimeInt
sdGameYearsInt = sdToolKit.sdGameYearsInt
sdModLoad      = sdToolKit.sdModLoad
sdModSave      = sdToolKit.sdModSave
sdEntityInit   = sdToolKit.sdEntityInit
sdEntityWipe   = sdToolKit.sdEntityWipe
sdGetVal       = sdToolKit.sdGetVal
sdSetVal       = sdToolKit.sdSetVal
sdDelVal       = sdToolKit.sdDelVal
sdGetGlobal    = sdToolKit.sdGetGlobal
sdSetGlobal    = sdToolKit.sdSetGlobal
sdDelGlobal    = sdToolKit.sdDelGlobal

############### SD-CULTURE-CONQUEST #################

szModID        = 'sdStackXP'
szVersion      = '1.00'

class sdStackXP:

	def sdStackXPGetUnitID(self, unit):
		szUnitID = 'Unit_%s' %(str(unit.getID()).rjust(10, '0'))
		return szUnitID

	# Version Check and Fix
	def sdStackXPDoVersionCheck(self):
		if ( sdGetGlobal(szModID, 'Version') == szVersion ):
			return 0
		self.sdStackXPFixUnits()
		sdSetGlobal(szModID, 'Version', szVersion)
		sdEcho('StackXP : Upgraded to version %s' %(szVersion))
		return 1

	def sdStackXPFixUnits(self):
		for i in range(gc.getMAX_PLAYERS()):
			iPlayer = PyPlayer(i)
			if ((iPlayer.isAlive()) or (iPlayer.isBarbarian())):
				unitList = iPlayer.getUnitList()
				mTable = sdModLoad(szModID)
				for c in range(len(unitList)):
					unit  = unitList[c]
					uType = unit.getUnitCombatType()
					if ( (uType > 0) and (uType != 4) and (not mTable.has_key(self.sdStackXPGetUnitID(unit))) ):
						self.sdStackXPInitUnit(unit)

	def sdStackXPInitUnit(self, unit):
		szUnitID = self.sdStackXPGetUnitID(unit)
		oldXP  = unit.getExperience()
		vTable = {
			'Experience' : oldXP
		}
		sdEntityInit(szModID, szUnitID, vTable)
		sdEcho('Initialized %s (%s)' %(unit.getName(), szUnitID))
		return oldXP

	def sdStackXPWipeUnit(self, unit):
		if ( (unit.getUnitCombatType() > 0) and (unit.getUnitCombatType() != 4) ):
			szUnitID = self.sdStackXPGetUnitID(unit)
			sdEntityWipe(szModID, szUnitID)
			# sdEcho('Purging %s (%s)' %(szUnitID, unit.getName()))
		return 0

	def sdStackXPCombatResult(self, argsList):
		u       = argsList[0]
		uPlot   = u.plot()
		uType   = u.getUnitCombatType()

		typesTable = {
			'-1' : 'Unknown',
			'0'  : 'None',
			'1'  : 'Archer',
			'2'  : 'Mounted',
			'3'  : 'Melee',
			'4'  : 'Siege',
			'5'  : 'Gun',
			'6'  : 'Armor',
			'7'  : 'Helicopter',
			'8'  : 'Naval'
		}

		if (uPlot.getNumUnits() < 2): # He's on his lonesome!
			return 0

		if ( (uType < 1) or (uType == 4) ): # People don't learn from siege weapons.
			sdEcho('StackXP : %s unit is invalid for stack distribution.' %(typesTable[str(uType)]))
			return 0

		try:
			oXP = sdGetVal(szModID, self.sdStackXPGetUnitID(u), 'Experience')
		except:
			oXP = self.sdStackXPInitUnit(u)-1
	
		dXP     = u.getExperience()-oXP
		if (dXP < 1):
			return 0
		sdEcho('StackXP : %s %s (%s) : Distributing %s (%s-%s) Experience Points.' %(typesTable[str(uType)], u.getName(), self.sdStackXPGetUnitID(u), dXP, u.getExperience(), oXP))
		u.setExperience((oXP), -1)

		# Look for the crappiest unit in the stack with the same combat type as the winner.
		w       = u
		while (dXP > 0):
			for i in range(uPlot.getNumUnits()):
				pUnit = CyInterface().getInterfacePlotUnit(uPlot, i)
				if (pUnit):
					if ( (pUnit.getID() != w.getID()) and (pUnit.getTeam() == u.getTeam()) and (pUnit.getUnitCombatType() == u.getUnitCombatType()) and (pUnit.getExperience() < w.getExperience()) ):
						w       = pUnit
			# sdEcho('StackXP : Plus 1 XP to %s %s (%s)' %(w.getName(), self.sdStackXPGetUnitID(w), w.getExperience()))
			w.setExperience((w.getExperience()+1), -1)
			sdSetVal(szModID, self.sdStackXPGetUnitID(u), 'Experience', w.getExperience())
			sdEcho('StackXP : Gave 1 XP to %s %s (%s)' %(w.getName(), self.sdStackXPGetUnitID(w), w.getExperience()))
			dXP -= 1
		sdSetVal(szModID, self.sdStackXPGetUnitID(u), 'Experience', u.getExperience())
		return 0
