## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## sdEventManager by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version CultureConquest 1.30


############## EVENT MANAGER GLOBALS ################
from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup
import sys

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

import CvEventManager

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho        = sdToolKit.sdEcho

################# STONE-D GLOBALS ###################
#import sdReligion
import sdCultureConquest
#import sdStackXP

################ 3RD PARTY GLOBALS ##################
# <Inquisition>
#import Inquisition
# </Inquisition>

# <cultureDecay>
#import CulturalDecay
# </cultureDecay>

# <TechConquest>
#import TechConquest
# </TechConquest>

# <SettlerReligion>
#import SettlerReligion
# </SettlerReligion>

# <snaitfDemolition>
#import snaitfDemolition
# </snaitfDemolition>

############## EVENTMANAGER SUBCLASS ################
class sdEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)

#		self.sdReligion        = sdReligion.sdReligion()
		self.sdCultureConquest = sdCultureConquest.sdCultureConquest()
#		self.sdStackXP         = sdStackXP.sdStackXP()
#		self.Inquisition       = Inquisition.Inquisition()
#		self.CulturalDecay     = CulturalDecay.CulturalDecay()
#		self.TechConquest      = TechConquest.TechConquest()
#		self.SettlerReligion   = SettlerReligion.SettlerReligion()
#		self.snaitfDemolition  = snaitfDemolition.snaitfDemolition()

		# </snaitfDemolition>
#		DEMOLISH_BUILDING_EVENT = 7500
#		DEMOLISH_CITY_EVENT     = 7501
#		self.Events[DEMOLISH_BUILDING_EVENT] = ('DestroyBuildingPopup', self.snaitfDemolition.__eventDestroyBuildingApply, self.snaitfDemolition.__eventDestroyBuildingBegin)
#		self.Events[DEMOLISH_CITY_EVENT] = ('DestroyCityPopup', self.snaitfDemolition.__eventDestroyCityApply, self.snaitfDemolition.__eventDestroyCityBegin)
		# </snaitfDemolition>

	def checkDbgKeyPress(self, argsList, bCtrl, bShift):
		eventType,key,mx,my,px,py = argsList
		game = CyGame()
		if ( eventType == self.EventKeyDown ):
			theKey=int(key)
			# Ctrl - Shift - D
			if (theKey == int(InputTypes.KB_D) and self.bCtrl and self.bShift ):
				return 1
		return 0

################ EVENT DEFINITIONS ##################
	def onBuildingBuilt(self, argsList):
		# <Inquisition>
#		self.Inquisition.BuildInquisition(argsList)
		# </Inquisition>
		self.parent.onBuildingBuilt(self, argsList)

	def onCityAcquired(self, argsList):
		# <sdCultureConquest>
		self.sdCultureConquest.sdCultureConquestCityAcquired(argsList)
		# </sdCultureConquest>
		# <TechConquest>
#		self.TechConquest.TechConquest(argsList)
		# </TechConquest>
		self.parent.onCityAcquired(self, argsList)

	def onCityBuilt(self, argsList):
		# <sdCultureConquest>
		self.sdCultureConquest.sdCultureConquestCityBuilt(argsList)
		# </sdCultureConquest>
		# <SettlerReligion>
#		self.SettlerReligion.onCityBuilt(argsList)
		# </SettlerReligion>
		self.parent.onCityBuilt(self, argsList)

	def onCityRazed(self, argsList):
		# <sdCultureConquest>
		self.sdCultureConquest.sdCultureConquestCityRazed(argsList)
		# </sdCultureConquest>
		self.parent.onCityRazed(self, argsList)

	def onCombatResult(self, argsList):
		# <sdStackXP>
#		self.sdStackXP.sdStackXPCombatResult(argsList)
		# </sdStackXP>
		self.parent.onCombatResult(self, argsList)

	def onEndGameTurn(self, argsList):
		# <sdCultureConquest>
		self.sdCultureConquest.sdCultureConquestEndGameTurn()
		# </sdCultureConquest>
		# <sdStackXP>
#		self.sdStackXP.sdStackXPDoVersionCheck()
		# </sdStackXP>
		# <cultureDecay>
#		self.CulturalDecay.onEndGameTurn(argsList)
		# </cultureDecay>
		self.parent.onEndGameTurn(self, argsList)

	def onKbdEvent(self, argsList):
		# <snaitfDemolition>
#		snaitfDemolitionRet = self.snaitfDemolition.onKbdEvent(argsList, self.bCtrl)
#		if (snaitfDemolitionRet == 1):
#			self.beginEvent(7500)
#			return 1
#		elif (snaitfDemolitionRet == 2):
#			self.beginEvent(7501)
#			return 1
		# </snaitfDemolition>
		# <sdToolKit>
#		self.checkDbgKeyPress(argsList, self.bCtrl, self.bShift)
		# </sdToolKit>
		self.parent.onKbdEvent(self, argsList)

	def onReligionFounded(self, argsList):
		# <sdReligion>
#		self.sdReligion.sdReligionDistributeTechs(argsList)
		# </sdReligion>
		self.parent.onReligionFounded(self, argsList)

	def onReligionSpread(self, argsList):
		# <sdReligion>
#		self.sdReligion.sdReligionHolyCityCheck(argsList)
		# </sdReligion>
		self.parent.onReligionSpread(self, argsList)

	def onUnitBuilt(self, argsList):
		# <sdStackXP>
#		self.sdStackXP.sdStackXPInitUnit(argsList[1])
		# </sdStackXP>
		# <SettlerReligion>
#		self.SettlerReligion.onUnitBuilt(argsList)
		# </SettlerReligion>
		self.parent.onUnitBuilt(self, argsList)

	def onUnitLost(self, argsList):
		# <sdStackXP>
#		self.sdStackXP.sdStackXPWipeUnit(argsList[0])
		# </sdStackXP>
		# <SettlerReligion>
#		self.SettlerReligion.onUnitLost(argsList)
		# </SettlerReligion>
		self.parent.onUnitLost(self, argsList)

############## 3RD PARTY DEFINITIONS ################

################ TRIGGERED EVENTS ###################
