## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## TechConquest by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import Popup as PyPopup

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho        = sdToolKit.sdEcho

# globals
gc = CyGlobalContext()

class TechConquest:
	def TechConquest(self, argsList):
		'City Acquired - Tech Capture'
		owner,playerType,city,bConquest,bTrade = argsList
		if bConquest:
			dice = gc.getGame().getMapRand()
			loserTeam = gc.getTeam(owner)
			conqTeam = gc.getTeam(city.getOwner())
			listTechDiff = []
			tradeData = TradeData()
			tradeData.ItemType = TradeableItems.TRADE_TECHNOLOGIES
			for iLoopTech in range(gc.getNumTechInfos()):
				tradeData.iData = iLoopTech
				if (loserTeam.isHasTech(iLoopTech) == True) and (conqTeam.isHasTech(iLoopTech) == False):
					listTechDiff.append(iLoopTech)
			if len(listTechDiff) > 0:
				randTech = dice.get(len(listTechDiff), "Tech Chooser - TechConquest PYTHON")
				techData = gc.getTechInfo(listTechDiff[randTech])
				techCost = techData.getResearchCost()
				baseMultiplier = city.getPopulation() / 4
				baseTechPointsAdded = (techCost / 20) * baseMultiplier
				extraTechPointsAdded = dice.get((techCost / 10) * baseMultiplier, "Tech Chooser - TechConquest PYTHON")
				totalTechPointsAdded = baseTechPointsAdded + extraTechPointsAdded
				currentTechPoints = conqTeam.getResearchProgress(listTechDiff[randTech])
				if (totalTechPointsAdded > (techCost - currentTechPoints)):
					totalTechPoints = techCost
				else:
					totalTechPoints = currentTechPoints + totalTechPointsAdded
				conqTeam.changeResearchProgress(listTechDiff[randTech], totalTechPoints, city.getOwner())
				sdEcho('%s captured by %s. %d tech points awarded towards %s.'
					%(city.getName(), gc.getPlayer(city.getOwner()).getCivilizationDescription(0), totalTechPointsAdded, techData.getDescription()))
# This was causing a python exception, haven't tracked it.
#				if city.getOwner().isHuman():
#					popup = PyPopup.PyPopup()
#					popup.setBodyString("From the inhabitants of %s, you learn some of the secrets of %s"
#						%(city.getName(), techData.getDescription()))
#					popup.launch()
			else:
				sdEcho('%s captured by %s. No unknown techs found.'
					%(city.getName(), gc.getPlayer(city.getOwner()).getCivilizationDescription(0)))
