## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## CulturalDecay by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import Popup as PyPopup

# globals
gc = CyGlobalContext()

class CulturalDecay:
	def getMaxCulture3x3(self, iXOrig, iYOrig, pMap, iPlayer):
		iRetCulture = 0
		for iX in range(3):
			for iY in range(3):
				iXPt = iXOrig + iX - 1
				iYPt = iYOrig + iY - 1
				if (iXPt < 0) or (iXPt >= pMap.getGridWidth()):
					continue
				if (iYPt < 0) or (iYPt >= pMap.getGridHeight()):
					continue
				if (iXPt == iXOrig) and (iYPt == iYOrig):
					continue
				iLclCulture = pMap.plot(iXPt, iYPt).getCulture(iPlayer)
				if (iLclCulture > iRetCulture):
					iRetCulture = iLclCulture
		return iRetCulture

	def onEndGameTurn(self, argsList):
		pMap = CyMap()
		for iX in range(pMap.getGridWidth()):
			for iY in range(pMap.getGridHeight()):
				pPlot = pMap.plot(iX, iY)
				if (pPlot.countTotalCulture() > 0):
					for iLoop in range(gc.getMAX_PLAYERS()):
						pPlayer = gc.getPlayer(iLoop)
						if (pPlayer.isAlive()) or (pPlayer.isBarbarian()):
							iCulture = pPlot.getCulture(iLoop)
							iNumCultureCities = pPlot.getNumCultureRangeCities(iLoop)
							if (iCulture > 0) and (iNumCultureCities == 0):
								iCultureDecay = (int)(iCulture * 0.05)
								if (iCultureDecay < 1):
									iCultureDecay = 1
								pPlot.changeCulture(iLoop, -iCultureDecay)
							elif (iNumCultureCities == 1) and (pPlot.isCity() == false):
								iMaxCulture = self.getMaxCulture3x3(iX, iY, pMap, iLoop)
								if (iCulture > iMaxCulture):
									iCultureDecay = (int)(iCulture * 0.05)
									if (iCultureDecay < 1):
										iCultureDecay = 1
									if ((iCulture - iCultureDecay) < iMaxCulture):
										iCultureDecay = iCulture - iMaxCulture
									pPlot.changeCulture(iLoop, -iCultureDecay)
