## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## sdCultureConquest by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version 1.20


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import PyHelpers
import Popup as PyPopup
import sys
import cPickle as pickle

gc = CyGlobalContext()
CyGameInstance = gc.getGame()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################# SD-UTILITY-PACK ###################
import sdToolKit
sdEcho         = sdToolKit.sdEcho
sdGetTimeInt   = sdToolKit.sdGetTimeInt
sdGameYearsInt = sdToolKit.sdGameYearsInt
sdModLoad      = sdToolKit.sdModLoad
sdModSave      = sdToolKit.sdModSave
sdEntityInit   = sdToolKit.sdEntityInit
sdEntityWipe   = sdToolKit.sdEntityWipe
sdGetVal       = sdToolKit.sdGetVal
sdSetVal       = sdToolKit.sdSetVal

############### SD-CULTURE-CONQUEST #################

szModID        = 'sdCultureConquest'

class sdCultureConquest:

	def sdCultureConquestGetCityID(self, city):
		plot = ('%s%s' %(city.plot().getX(), city.plot().getY()))
		return ('City_%s' %(plot.rjust(6,'0')))

	# <Will be removed at version 2, which will require a new game for prior versions.>
	# Eliminates exploit cheat and opens additional possibilities.
	def sdCultureConquestFixCities(self):
		for i in range(gc.getMAX_PLAYERS()):
			iPlayer = PyPlayer(i)
			if ((iPlayer.isAlive()) or (iPlayer.isBarbarian())):
				cityList = iPlayer.getCityList()
				mTable = sdModLoad(szModID)
				for c in range(len(cityList)):
					city = cityList[c]
					szCityID = self.sdCultureConquestGetCityID(city)
					if ( not mTable.has_key(city.getName()) ):
						continue
					eTable = pickle.loads(mTable[city.getName()])
					mTable[szCityID] = pickle.dumps(eTable)
					del mTable[city.getName()]
					sdEcho('City Protected : %s is now %s' %(city.getName(), szCityID))
				sdModSave(szModID, mTable)
	# </Will be removed at version 2, which will require a new game for prior versions.>

	def sdCultureConquestValidateCity(self, city):
		# Called to validate and initialize a city's data.
		szCityID = self.sdCultureConquestGetCityID(city)
		try:
			sdGetVal(szModID, szCityID, 'CaptureCount')
		except:
			self.sdCultureConquestInitCity(city)

		# Avoid having to start a new game - add/change/remove variables in new mod versions.
		try:
			sdGetVal(szModID, szCityID, 'fDateLost')
		except:
			sdSetVal(szModID, szCityID, 'fDateLost', sdGetTimeInt(gc.getGame().getGameTurn()))
		return 0

	def sdCultureConquestInitCity(self, city):
		vTable = {
			'Name'         : city.getName(),
			'CaptureCount' : 0,
			'CaptureState' : 0,
			'founder'      : city.getOwner(),
			'fCulture'     : 0,
			'fDateLost'    : sdGetTimeInt(gc.getGame().getGameTurn()),
			'loser'        : 0,
			'oCulture'     : 0
		}
		sdEntityInit(szModID, self.sdCultureConquestGetCityID(city), vTable)

	def sdCultureConquestCityAcquired(self, argsList):
		# Called at city acquired event.
		loser,playerType,city,bConquest,bTrade = argsList
		self.sdCultureConquestFixCities()
		self.sdCultureConquestValidateCity(city)
		szCityID = self.sdCultureConquestGetCityID(city)
		sdSetVal(szModID, szCityID, 'CaptureState', 1)
		sdSetVal(szModID, szCityID, 'loser', loser)
		sdSetVal(szModID, szCityID, 'oCulture', city.getCulture(loser))
		# Decrease this to 1 in order to avoid losing another population point due to starvation
		city.setOccupationTimer(1)
		return 0

	def sdCultureConquestCityRazed(self, city):
		# Leave this alone for now, I have plans.   :)
		# sdEntityWipe(szModID, self.sdCultureConquestGetCityID(city))
		return 0

	def sdCultureConquestEndGameTurn(self):
		# Called at the end of the turn. Odd, that, isn't it?
		for i in range(gc.getMAX_PLAYERS()):
			iPlayer = PyPlayer(i)
			if ((iPlayer.isAlive()) or (iPlayer.isBarbarian())):
				cityList = iPlayer.getCityList()
				for c in range(len(cityList)):
					city                    = cityList[c]
					szCityID                = self.sdCultureConquestGetCityID(city)
					self.sdCultureConquestFixCities()
					self.sdCultureConquestValidateCity(city)
					if (sdGetVal(szModID, szCityID, 'CaptureState') > 0):
						CaptureCount    = sdGetVal(szModID, szCityID, 'CaptureCount')
						CaptureState    = sdGetVal(szModID, szCityID, 'CaptureState')
						founder         = sdGetVal(szModID, szCityID, 'founder')
						fCulture        = sdGetVal(szModID, szCityID, 'fCulture')
						fDateLost       = sdGetVal(szModID, szCityID, 'fDateLost')
						loser           = sdGetVal(szModID, szCityID, 'loser')
						oCulture        = sdGetVal(szModID, szCityID, 'oCulture')

						if (oCulture < 4):
							oCulture        = 4

						cdice       = CyRandom()
						cdice.init(oCulture)

						if ((loser != founder) and (oCulture > (fCulture*200))):
							founder         = loser
						if ((loser == founder) or ((city.getOwner() == founder) and (oCulture > fCulture))):
							fCulture        = oCulture
							fDateLost       = sdGetTimeInt(gc.getGame().getGameTurn())

						nCulture = (oCulture/2) + cdice.get((oCulture/4), "Culture Conquest") + cdice.get((oCulture/4), "Culture Conquest")

						if (city.getOwner() == founder):
							yearMax         = sdGameYearsInt()
							yearNow         = sdGetTimeInt(gc.getGame().getGameTurn())
							yearDif         = yearNow - fDateLost
							Redux           = 1.0 - (yearDif/(yearMax * 0.25))
							if (Redux < 0.0):
								Redux = 0.0
							iCulture = int(fCulture*Redux)
						#	sdEcho('Conquest : %s : fDateLost = %d, yearMax = %d, yearDif = %d, Redux = %s, fCulture = %d'
						#		%(city.getName(), fDateLost, yearMax, yearDif, str(Redux), fCulture))
							sdEcho('Conquest : After %d years, the %s has recaptured %s! (%d : %d x %s)'
								%(yearDif, gc.getPlayer(city.getOwner()).getCivilizationDescription(0), city.getName(), nCulture, fCulture, str(Redux)))
							if (nCulture > iCulture):
								sdEcho('Conquest : Sanity Check. Restored founder culture (%d) is less than current non-founder culture (%d), so non-founder culture is used.'
									%(iCulture, nCulture))
						else:
							sdEcho('Conquest : %s (%s) was captured by the %s.'
								%(city.getName(), gc.getPlayer(loser).getCivilizationAdjective(0), gc.getPlayer(city.getOwner()).getCivilizationDescription(0)))

						city.setCulture(nCulture, True)
						sdEcho('Conquest : %s Culture is %d (WAS %d)'
							%(city.getName(), city.getCulture(), oCulture))
						CaptureCount += 1
						CaptureState  = 0
						sdSetVal(szModID, szCityID, 'CaptureCount', CaptureCount)
						sdSetVal(szModID, szCityID, 'CaptureState', CaptureState)
						sdSetVal(szModID, szCityID, 'founder', founder)
						sdSetVal(szModID, szCityID, 'fCulture', fCulture)
						sdSetVal(szModID, szCityID, 'fDateLost', fDateLost)
						sdEcho('Conquest : %s has been captured %d times.'
							%(city.getName(), CaptureCount))
		return 0
