## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## ReligiousCrusades by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import Popup as PyPopup

# globals
gc = CyGlobalContext()

class ReligiousCrusade:
	def __init__(self):
		return
		
	def calculateReligion(self, iReligion, iPlayer):
		iRet = 0
		pPlayer = gc.getPlayer(iPlayer)
		if ((pPlayer.isAlive() == false) or pPlayer.isBarbarian() or (pPlayer.getNumCities() == 0)):
			return iRet
		if (iReligion == -1):
			return iRet
		for iCity in range(pPlayer.getNumCities()):
			pCity = pPlayer.getCity(iCity)
			if (pCity.isHasReligion(iReligion)):
				iRet += pCity.getPopulation()
				if (pCity.isHolyCityByType(iReligion)):
					iRet += pCity.getPopulation()
				iReligiousBuildings = 36 + (iReligion * 4)
				if (pCity.hasBuilding(iReligiousBuildings)):
					'Temple'
					iRet += 2
				if (pCity.hasBuilding(iReligiousBuildings + 1)):
					'Cathedral'
					iRet += 3
				if (pCity.hasBuilding(iReligiousBuildings + 2)):
					'Monastery'
					iRet += 1
				if (pCity.hasBuilding(iReligiousBuildings + 3)):
					'Shrine'
					iRet += 5
		return iRet
		
	def calculateHighestReligion(self, iStateReligion, iPlayer):
		iRet = iStateReligion
		iHighestValue = self.calculateReligion(iStateReligion, iPlayer)
		for iReligion in range(gc.getNumReligionInfos()):
			iValue = self.calculateReligion(iReligion, iPlayer)
			if (iValue > iHighestValue):
				iHighestValue = iValue
				iRet = iReligion
		return iRet
			
	def setReligion(self, iPlayer):
		pPlayer = gc.getPlayer(iPlayer)
		if ((pPlayer.isAlive() == false) or pPlayer.isBarbarian()):
			return
		iHighestReligion = self.calculateHighestReligion(pPlayer.getStateReligion(), iPlayer)
		if (iHighestReligion != pPlayer.getStateReligion()):
			pPlayer.setLastStateReligion(iHighestReligion)
			for iLoop in range(gc.getMAX_PLAYERS()):
				if (iLoop == iPlayer):
					continue
				self.setWarStatus(iPlayer, iLoop)
		return
		
	def setWarStatus(self, iOurPlayer, iTheirPlayer):
		pOurPlayer = gc.getPlayer(iOurPlayer)
		if ((pOurPlayer.isAlive() == false) or pOurPlayer.isBarbarian()):
			return
		pTheirPlayer = gc.getPlayer(iTheirPlayer)
		if ((pTheirPlayer.isAlive() == false) or pTheirPlayer.isBarbarian()):
			return
		if ((pTheirPlayer.getStateReligion() == -1) or (pOurPlayer.getStateReligion == -1)):
			return
		pOurTeam = gc.getTeam(pOurPlayer.getTeam())
		if (pOurTeam.isHasMet(pTheirPlayer.getTeam())):
			if (pOurPlayer.getStateReligion() == pTheirPlayer.getStateReligion()):
				pOurTeam.makePeace(pTheirPlayer.getTeam())
			else:
				pOurTeam.declareWar(pTheirPlayer.getTeam(), false)
		return
		
	def onReligionSpread(self, argsList):
		iReligion, iOwner, pSpreadCity = argsList
		self.setReligion(iOwner)
		return
		
	def onCityAcquired(self, argsList):
		iOwner, playerType, pCity, bConquest, bTrade = argsList
		self.setReligion(iOwner)
		self.setReligion(pCity.getOwner())
		return
	
	def onCityLost(self, argsList):
		pCity = argsList[0]
		self.setReligion(pCity.getOwner())
		return
		
	def onCityDoTurn(self, argsList):
		iPlayer = argsList[1]
		self.setReligion(iPlayer)
		
	def onFirstContact(self, argsList):
		iTeamX, iHasMetTeamY = argsList
		listOurTeam = []
		listTheirTeam = []
		for iLoop in range(gc.getMAX_PLAYERS()):
			pPlayer = gc.getPlayer(iLoop)
			if ((pPlayer.isAlive() == false) or (pPlayer.isBarbarian())):
				continue
			if (pPlayer.getTeam() == iTeamX):
				listOurTeam.append(iLoop)
			if (pPlayer.getTeam() == iHasMetTeamY):
				listTheirTeam.append(iLoop)
		for iOurPlayer in listOurTeam:
			for iTheirPlayer in listTheirTeam:
				self.setWarStatus(iOurPlayer, iTheirPlayer)
		return		
