## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
##  AlterReligion by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup

# globals
gc = CyGlobalContext()

class SettlerReligion:
	def __init__(self):
		self.city = None
		
	def onUnitBuilt(self, argsList):
		city = argsList[0]
		unit = argsList[1]

		if (unit.getUnitType() != gc.getInfoTypeForString("UNIT_SETTLER")):
			return
		listReligions = []
		for iReligion in range(gc.getNumReligionInfos()):
			if city.isHasReligion(iReligion):
				listReligions.append(iReligion)
		if (len(listReligions) == 0):
			unit.setScriptData("NO_RELIGION")
		else:
			pPlayer = gc.getPlayer(unit.getOwner())
			if (pPlayer.getCivics(gc.getInfoTypeForString("CIVICOPTION_RELIGION")) == gc.getInfoTypeForString("CIVIC_THEOCRACY")):
				bHasStateReligion = false
				for iList in listReligions:
					if (iList == pPlayer.getStateReligion()):
						bHasStateReligion = true
						break
				if (bHasStateReligion):
					unit.setScriptData(gc.getReligionInfo(pPlayer.getStateReligion()).getType())
				else:
					unit.setScriptData("NO_RELIGION")
			else:
				dice = gc.getGame().getMapRand()
				iRandReligion = dice.get(len(listReligions), "Religion Selection - AlterReligion PYTHON")
				iSelectedReligion = listReligions[iRandReligion]
				unit.setScriptData(gc.getReligionInfo(iSelectedReligion).getType())

	def onUnitLost(self, argsList):
		unit = argsList[0]
		if (unit.getUnitType() != gc.getInfoTypeForString("UNIT_SETTLER")):
			return
		if (self.city):
			iReligion = gc.getInfoTypeForString(unit.getScriptData())
			if (iReligion > -1):
				self.city.setHasReligion(iReligion, true, true, true)
			self.city = None

	def onCityBuilt(self, argsList):
		city = argsList[0]
		self.city = city
		