## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## SdToolKit by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version 1.00


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import PyHelpers
import Popup as PyPopup
import sys
import cPickle as pickle
	
gc = CyGlobalContext()
CyGameInstance = gc.getGame()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################# SD-UTILITY-PACK ###################
################# BASIC UTILITIES ###################
def SdEcho(argsList):
	printToScr = False
	printToLog = True
	message = "%s" %(argsList)
	if (printToScr):
		CyInterface().addImmediateMessage(message,"")
	if (printToLog):
		CvUtil.pyPrint(message)
	return 0

################# SD-DATA-STORAGE ###################
# What an utter cunt this was.  :/
def SdModInit( ModID ):
	try:
		cyTable = pickle.loads( CyGameInstance.getScriptData() )
	except:
		cyTable = {}
	if ( not cyTable.has_key(ModID) ):
		cyTable[ModID] = pickle.dumps({})
		SdEcho('Mod Data Initialized : %s %s' %(ModID, cyTable.has_key(ModID)))
	CyGameInstance.setScriptData( pickle.dumps(cyTable) )

def SdModLoad( ModID ):
	cyTable = pickle.loads( CyGameInstance.getScriptData() )
	return pickle.loads(cyTable[ModID])

def SdModSave( ModID, mTable ):
	cyTable = pickle.loads( CyGameInstance.getScriptData() )
	cyTable[ModID] = pickle.dumps(mTable)
	CyGameInstance.setScriptData( pickle.dumps(cyTable) )

def SdEntityInit( ModID, entity, eTable ):
	SdModInit(ModID)
	mTable = SdModLoad(ModID)
	mTable[entity] = pickle.dumps(eTable)
	SdModSave(ModID, mTable)
	SdEcho('Entity Initialized : %s' %(entity))

def SdGetVal( ModID, entity, var ):
	mTable = SdModLoad(ModID)
	eTable = pickle.loads(mTable[entity])
#	SdEcho('%s : Load : %s, %s = %d' %(ModID, entity, var, eTable[var]))
	return eTable[var]

def SdSetVal( ModID, entity, var, val ):
	mTable = SdModLoad(ModID)
	eTable = pickle.loads(mTable[entity])
	eTable[var] = val
	mTable[entity] = pickle.dumps(eTable)
	SdModSave(ModID, mTable)
#	SdEcho('%s : Save : %s, %s = %d' %(ModID, entity, var, eTable[var]))
