## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## SdReligion by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005
##
## Version 1.10


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import PyHelpers
import Popup as PyPopup
import sys
import pickle
	
gc = CyGlobalContext()
CyGameInstance = gc.getGame()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################# SD-UTILITY-PACK ###################
import SdToolKit
SdEcho       = SdToolKit.SdEcho

################### SD-RELIGION #####################
class SdReligion:
	def DistributeReligionTechs(self, argsList):
		'Distribute Religion Techs'
		iReligion, iFounder = argsList
		GcPlayer = gc.getPlayer(iFounder)
		iFounded  = gc.getGame().getReligionGameTurnFounded(iReligion)
		sFounded  = CyGameTextMgr().getTimeStr(iFounded, false)
		rTech  = gc.getReligionInfo(iReligion).getTechPrereq()
		iTech  = gc.getTechInfo(rTech).getPrereqOrTechs(0)
		SdEcho('Religion : %s : %s founded by %s.'
			%(sFounded, gc.getReligionInfo(iReligion).getDescription(), GcPlayer.getCivilizationShortDescription(0)))
		for i in range(gc.getMAX_PLAYERS()):
			cPlayer = PyPlayer(i)
			if ((cPlayer.isAlive()) or (cPlayer.isBarbarian())):
				cPlayer.setHasTech( rTech )
				SdEcho('Religion : %s tech given to %s.'
					%(gc.getTechInfo(rTech).getDescription(), cPlayer.getCivilizationName()))

	def HolyCityCheck(self, argsList):
		'Religion Founded'
		iReligion, iOwner, pSpreadCity = argsList
		pHolyCity = gc.getGame().getHolyCity(iReligion)
		iFounded  = gc.getGame().getReligionGameTurnFounded(iReligion)
		sFounded  = CyGameTextMgr().getTimeStr(iFounded, false)
		iTurn     = gc.getGame().getGameTurn()
		sTurn     = CyGameTextMgr().getTimeStr(iTurn, false)
		if (pHolyCity.isNone()):
			if ((iFounded < 0) or (iFounded == iTurn)):
				gc.getGame().setHolyCity(iReligion, pSpreadCity, False)
				SdEcho('Religion : %s : Holy City for %s set to %s.'
					%(sTurn, gc.getReligionInfo(iReligion).getDescription(), pSpreadCity.getName()))
			else:
				SdEcho('Religion : %s : Holy City for %s NOT set. Founded %s.'
					%(sTurn, gc.getReligionInfo(iReligion).getDescription(), sFounded))
