## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## 
## CvEventManager
## This class is passed an argsList from CvAppInterface.onEvent
## The argsList can contain anything from mouse location to key info
## The EVENTLIST that are being notified can be found 


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import CvWBPopups
import PyHelpers
import Popup as PyPopup
import CvCameraControls
import CvTopCivs
import sys
import CvWorldBuilderScreen
import CvAdvisorUtils
import CvTechChooser

import CvEventManager

import pickle

import SdReligion
	
gc = CyGlobalContext()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

################ UTILITY FUNCTIONS ##################
def SdEcho(argsList):
	printToScr = True
	printToLog = True
	message = "%s" %(argsList)
	if (printToScr):
		CyInterface().addImmediateMessage(message,"")
	if (printToLog):
		CvUtil.pyPrint(message)
	return 0

#####################################################
class SdEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)

		self.SdReligion        = SdReligion.SdReligion()

#################### ON EVENTS ######################
	def onReligionFounded(self, argsList):
		self.SdReligion.DistributeReligionTechs(argsList)
		self.parent.onReligionFounded(self, argsList)

	def onReligionSpread(self, argsList):
		self.SdReligion.HolyCityCheck(argsList)
		self.parent.onReligionSpread(self, argsList)
