# Sid Meier's Civilization 4 
# Copyright Firaxis Games 2005 
# 
# Additional information: http://session.apolyton.net/modiki/index.php?title=Main_Page

from __future__ import division
import os
import wx
import wx.lib.imagebrowser as ib
import Image
import BMPtoWBSConverter186

# Scenario file for BMP to WBS Converter Version 18.6
# Author: Gabriele "Rhye" Trovato
# This file contains all the info the BMPConverter will put in Civ4WorldBuilderSave headers


class ScenarioClass:

        iDefaultWidth = 128
        iDefaultHeight = 80        
        iDefaultRiverSensitivity = 5        # 1 to 7, higher means FEWER river plots are put on the map based upon the RiverMap - 5 is recommended    
        iDefaultCoastsAssignment = 1
        iDefaultFloodPlainsAssignment = 3
        iDefaultXWrapping = 1
        iDefaultYWrapping = 0
        iDefaultNumberOfCivs = 12
        HeightMapPath = "J:\Works\Civ4\Miracle\miracle_h.bmp"
        TerrainMapPath = "J:\Works\Civ4\Miracle\miracle_t.bmp"
        FeatureMapPath = "J:\Works\Civ4\Miracle\miracle_f.bmp"
        RiverMapPath = "J:\Works\Civ4\Miracle\miracle_r.bmp"
        BonusMapPath = "J:\Works\Civ4\Miracle\miracle_b.bmp"


        #Fog of war

        dltRevealPlots = {}

        dltRevealPlots[0] =    []
        dltRevealPlots[1] =    []
        dltRevealPlots[2] =    []
        dltRevealPlots[3] =    []
        dltRevealPlots[4] =    []
        dltRevealPlots[5] =    []
        dltRevealPlots[6] =    []
        dltRevealPlots[7] =    []
        dltRevealPlots[8] =    []
        dltRevealPlots[9] =    []
        dltRevealPlots[10] =    []
        dltRevealPlots[11] =    []
        dltRevealPlots[12] =    []
        dltRevealPlots[13] =    []
        dltRevealPlots[14] =    []
        dltRevealPlots[15] =    []
        dltRevealPlots[16] =    []
        dltRevealPlots[17] =    []


        #Terrain improvements
        
        dltFBoats =	[]
        dltWBoats =	[]
        dltMine =	[]
        dltQuarry =	[]
        dltCamp =	[]
        dltFarm =	[]
        dltPlantation =	[]
        dltWinery =	[]
        dltPasture =	[]
        dltWindmill =	[]
        dltLumbermill =	[]
        dltWatermill =	[]
        dltFort =	[]
        dltOPlatform =	[]
        dltWell =	[]
        dltWorkshop =	[]
        dltCottage =	[]
        dltHamlet =	[]
        dltVillage =	[]
        dltTown =	[]
        dltRuins =	[]
        dltGoodyHut =	[]
        dltRoad =	[]
        dltRailroad =	[]

        
	def TerrainChanges(self, bmpc, iPlotX, iPlotY):

                # Scenario-specific changes to the map
                bmpc.DebugLogging("No further terrain changes\n")
                

	def WriteStartingPlots(self, bmpc, iPlotX, iPlotY):

                if iPlotX == 8 and iPlotY == 64:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 12 and iPlotY == 49:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 17 and iPlotY == 32:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 26 and iPlotY == 68:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 33 and iPlotY == 57:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 40 and iPlotY == 61:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 63 and iPlotY == 40:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 106 and iPlotY == 66:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 80 and iPlotY == 16:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 107 and iPlotY == 14:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 108 and iPlotY == 28:
                        bmpc.OutputFile.write("\tStartingPlot\n")
                if iPlotX == 115 and iPlotY == 6:
                        bmpc.OutputFile.write("\tStartingPlot\n")

	def WriteCitiesUnits(self, bmpc, iPlotX, iPlotY):

		# Write cities and units
                bmpc.DebugLogging("No cities or units\n")


	def getExtraWBSText_GameSettings(self):
		WBSText = "Version=11 \
		\nBeginGame \
		\n\tSpeed=GAMESPEED_EPIC \
		\n\tCalendar=CALENDAR_DEFAULT \
		\n\tGameTurn=0 \
		\n\tStartYear=-4000 \
		\n\tVictory=VICTORY_SCORE\
                \n\tVictory=VICTORY_TIME\
                \n\tVictory=VICTORY_CONQUEST\
                \n\tVictory=VICTORY_DOMINATION\
                \n\tVictory=VICTORY_CULTURAL\
                \n\tVictory=VICTORY_SPACE_RACE\
                \n\tVictory=VICTORY_DIPLOMATIC\
                \n\tDescription=Builder's Paradise\
		\nEndGame"
		return WBSText
	    
	def getExtraWBSText_Diplomacy(self):

                #teams
                WBSText = ""
                
                return WBSText



	def getExtraWBSText_Civs(self):
            
                #players
                WBSText = "\nBeginPlayer\n\tLeaderType=LEADER_SALADIN\n\tCivType=CIVILIZATION_ARABIA\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_MAO_ZEDONG\n\tCivType=CIVILIZATION_CHINA\n\tTeam=1\n\tStartingX=108, StartingY=28\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_JULIUS_CAESAR\n\tCivType=CIVILIZATION_ROME\n\tTeam=2\n\tStartingX=40, StartingY=61\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_ISABELLA\n\tCivType=CIVILIZATION_SPAIN\n\tTeam=3\n\tStartingX=106, StartingY=66\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_GENGHIS_KHAN\n\tCivType=CIVILIZATION_MONGOL\n\tTeam=4\n\tStartingX=107, StartingY=14\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_ALEXANDER\n\tCivType=CIVILIZATION_GREECE\n\tTeam=5\n\tStartingX=26, StartingY=68\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_TOKUGAWA\n\tCivType=CIVILIZATION_JAPAN\n\tTeam=6\n\tStartingX=33, StartingY=57\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_MONTEZUMA\n\tCivType=CIVILIZATION_AZTEC\n\tTeam=7\n\tStartingX=8, StartingY=64\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_NAPOLEON\n\tCivType=CIVILIZATION_FRANCE\n\tTeam=8\n\tStartingX=12, StartingY=49\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_ELIZABETH\n\tCivType=CIVILIZATION_ENGLAND\n\tTeam=9\n\tStartingX=17, StartingY=32\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_BISMARCK\n\tCivType=CIVILIZATION_GERMANY\n\tTeam=10\n\tStartingX=115, StartingY=6\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_CATHERINE\n\tCivType=CIVILIZATION_RUSSIA\n\tTeam=11\n\tStartingX=80, StartingY=16\n\tPlayableCiv=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_PETER\n\tCivType=CIVILIZATION_RUSSIA\n\tTeam=12\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_GANDHI\n\tCivType=CIVILIZATION_INDIA\n\tTeam=13\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_QIN_SHI_HUANG\n\tCivType=CIVILIZATION_CHINA\n\tTeam=14\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_VICTORIA\n\tCivType=CIVILIZATION_ENGLAND\n\tTeam=15\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_WASHINGTON\n\tCivType=CIVILIZATION_AMERICA\n\tTeam=16\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_ASOKA\n\tCivType=CIVILIZATION_INDIA\n\tTeam=17\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_HUAYNA_CAPAC\n\tCivType=CIVILIZATION_INCA\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_FRANKLIN_ROOSEVELT\n\tCivType=CIVILIZATION_AMERICA\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_FREDERICK\n\tCivType=CIVILIZATION_GERMANY\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_HATSHEPSUT\n\tCivType=CIVILIZATION_EGYPT\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_MANSA_MUSA\n\tCivType=CIVILIZATION_MALI\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_CYRUS\n\tCivType=CIVILIZATION_PERSIA\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_KUBLAI_KHAN\n\tCivType=CIVILIZATION_MONGOL\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=LEADER_LOUIS_XIV\n\tCivType=CIVILIZATION_FRANCE\n\tTeam=0\n\tStartingX=63, StartingY=40\n\tPlayableCiv=1\nEndPlayer"
                
                return WBSText

	def getExtraWBSText_WorldSettings(self, bmpConverter):
                WBSText = "\n\tworld size=WORLDSIZE_HUGE \
                \n\tclimate=CLIMATE_TEMPERATE \
                \n\tsealevel=SEALEVEL_MEDIUM \
                \n\tnum plots written=%d\nEndMap\n" %(bmpConverter.iSizeX * bmpConverter.iSizeY)
		return WBSText
	
bmpc = BMPtoWBSConverter186.runBMPConvertToWBSApp(ScenarioClass())
