## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## RealFort by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import Popup as PyPopup

# globals
gc = CyGlobalContext()

class RealFort:
	def onUnitMove(self, argsList):
		'unit move'
		pPlot,pUnit = argsList

		impFort = gc.getInfoTypeForString("IMPROVEMENT_FORT")
		promFort1 = gc.getInfoTypeForString("PROMOTION_FORT1")
		promFort2 = gc.getInfoTypeForString("PROMOTION_FORT2")
		promFort3 = gc.getInfoTypeForString("PROMOTION_FORT3")
		uctRecon = gc.getInfoTypeForString("UNITCOMBAT_RECON")
		uctArcher = gc.getInfoTypeForString("UNITCOMBAT_ARCHER")
		uctMounted = gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")
		uctMelee = gc.getInfoTypeForString("UNITCOMBAT_MELEE")
		uctSiege = gc.getInfoTypeForString("UNITCOMBAT_SIEGE")
		uctGun = gc.getInfoTypeForString("UNITCOMBAT_GUN")
		uctArmor = gc.getInfoTypeForString("UNITCOMBAT_ARMOR")
		
		if (pPlot.getImprovementType() == impFort):
			uct = pUnit.getUnitCombatType()
			if (uct == uctRecon) or (uct == uctArcher) or (uct == uctMounted) or (uct == uctMelee) or (uct == uctSiege) or (uct == uctGun) or (uct == uctArmor):
				pUnit.setHasPromotion(promFort1, true)
				pTeam = gc.getTeam(pUnit.getTeam())
				pFort = gc.getPromotionInfo(promFort2)
				if (pTeam.isHasTech(pFort.getTechPrereq())):
					pUnit.setHasPromotion(promFort2, true)
				pFort = gc.getPromotionInfo(promFort3)
				if (pTeam.isHasTech(pFort.getTechPrereq())):
					pUnit.setHasPromotion(promFort3, true)

		else:
			if (pUnit.isHasPromotion(promFort1)):
				pUnit.setHasPromotion(promFort1, false)
			if (pUnit.isHasPromotion(promFort2)):
				pUnit.setHasPromotion(promFort2, false)
			if (pUnit.isHasPromotion(promFort3)):
				pUnit.setHasPromotion(promFort3, false)
	
	
	def onImprovementBuilt(self, argsList):
		'Improvement Built'
		iImprovement, iX, iY = argsList

		impFort = gc.getInfoTypeForString("IMPROVEMENT_FORT")
		promFort1 = gc.getInfoTypeForString("PROMOTION_FORT1")
		promFort2 = gc.getInfoTypeForString("PROMOTION_FORT2")
		promFort3 = gc.getInfoTypeForString("PROMOTION_FORT3")
		uctRecon = gc.getInfoTypeForString("UNITCOMBAT_RECON")
		uctArcher = gc.getInfoTypeForString("UNITCOMBAT_ARCHER")
		uctMounted = gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")
		uctMelee = gc.getInfoTypeForString("UNITCOMBAT_MELEE")
		uctSiege = gc.getInfoTypeForString("UNITCOMBAT_SIEGE")
		uctGun = gc.getInfoTypeForString("UNITCOMBAT_GUN")
		uctArmor = gc.getInfoTypeForString("UNITCOMBAT_ARMOR")

		pMap = CyMap()
		pPlot = pMap.plot(iX, iY)
		if (iImprovement == impFort):
			for iUnit in range(pPlot.getNumUnits()):
				pUnit = pPlot.getUnit(iUnit)
				uct = pUnit.getUnitCombatType()
				if (uct == uctRecon) or (uct == uctArcher) or (uct == uctMounted) or (uct == uctMelee) or (uct == uctSiege) or (uct == uctGun) or (uct == uctArmor):
					pUnit.setHasPromotion(promFort1, true)
					pTeam = gc.getTeam(pUnit.getTeam())
					pFort = gc.getPromotionInfo(promFort2)
					if (pTeam.isHasTech(pFort.getTechPrereq())):
						pUnit.setHasPromotion(promFort2, true)
					pFort = gc.getPromotionInfo(promFort3)
					if (pTeam.isHasTech(pFort.getTechPrereq())):
						pUnit.setHasPromotion(promFort3, true)
		else:
			for iUnit in range(pPlot.getNumUnits()):
				pUnit = pPlot.getUnit(iUnit)
				if (pUnit.isHasPromotion(promFort1)):
					pUnit.setHasPromotion(promFort1, false)
				if (pUnit.isHasPromotion(promFort2)):
					pUnit.setHasPromotion(promFort2, false)
				if (pUnit.isHasPromotion(promFort3)):
					pUnit.setHasPromotion(promFort3, false)

	def onTechAcquired(self, argsList):
		iTechType, iTeam, iPlayer, bAnnounce = argsList
	
		impFort = gc.getInfoTypeForString("IMPROVEMENT_FORT")
		promFort1 = gc.getInfoTypeForString("PROMOTION_FORT1")
		promFort2 = gc.getInfoTypeForString("PROMOTION_FORT2")
		promFort3 = gc.getInfoTypeForString("PROMOTION_FORT3")
		uctRecon = gc.getInfoTypeForString("UNITCOMBAT_RECON")
		uctArcher = gc.getInfoTypeForString("UNITCOMBAT_ARCHER")
		uctMounted = gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")
		uctMelee = gc.getInfoTypeForString("UNITCOMBAT_MELEE")
		uctSiege = gc.getInfoTypeForString("UNITCOMBAT_SIEGE")
		uctGun = gc.getInfoTypeForString("UNITCOMBAT_GUN")
		uctArmor = gc.getInfoTypeForString("UNITCOMBAT_ARMOR")

		pFort2 = gc.getPromotionInfo(promFort2)
		pFort3 = gc.getPromotionInfo(promFort3)
		if (iTechType == pFort2.getTechPrereq()) or (iTechType == pFort3.getTechPrereq()):
			pMap = CyMap()
			for iX in range(pMap.getGridWidth()):
				for iY in range(pMap.getGridHeight()):
					pPlot = pMap.plot(iX, iY)
					if (pPlot.getImprovementType() == impFort):
						for iUnit in range(pPlot.getNumUnits()):
							pUnit = pPlot.getUnit(iUnit)
							if (pUnit.getTeam() == iTeam):
								uct = pUnit.getUnitCombatType()
								if (uct == uctRecon) or (uct == uctArcher) or (uct == uctMounted) or (uct == uctMelee) or (uct == uctSiege) or (uct == uctGun) or (uct == uctArmor):
									pUnit.setHasPromotion(promFort1, true)
									pTeam = gc.getTeam(pUnit.getTeam())
									if (iTechType == pFort2.getTechPrereq()):
										pUnit.setHasPromotion(promFort2, true)
									if (iTechType == pFort3.getTechPrereq()):
										pUnit.setHasPromotion(promFort3, true)