/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class SavedGameFile {
    private RandomAccessFile rules;
    private RandomAccessFile file;
    private long techPosition;
    private long leadersPosition;
    private int techCount;
    private static final String STRING_CIVILIZE = new String("CIVILIZE");
    private static final String STRING_RULES_CIVILIZE = new String("@CIVILIZE");
    private static final String STRING_RULES_LEADERS = new String("@LEADERS");
    private static final String STRING_PARAMETER = new String("Wrong Parameter!");
    private static final byte FINAL = 0;
    private static final byte VERSION_MGE = 44;
    public static final int MIN_CIV = 0;
    public static final int MAX_CIV = 6;
    public static final int MAX_GOLD = 32000;
    public static final int MIN_GOLD = 0;
    public static final int MIN_TECH = 1;
    public static final int MAX_TECH = 104;
    private static final int POS_TRIBES = 584;
    private static final int POS_TECHS = 3706;
    private static final int POS_CLAVES = 400;
    private static final int POS_MAP_HEADER = 13702;
    private static final int POS_TURN = 28;
    private static final int POS_LAST_CIV_MOVED = 41;
    private static final int LEN_MAP_HEADER = 14;
    public static final int LEN_SIGNATURE = 14;
    private static final int LEN_TRIBES = 242;
    private static final int LEN_PASSWORD = 5;
    private static final int LEN_TRIBE_NAME = 13;
    private static final int LEN_TECHS = 1428;
    private static final int LEN_TECHS_TECS = 11;
    private static final int LEN_DIPLOMACY = 4;
    private static final int OFF_LEADER_NAME = 2;
    private static final int OFF_DIPLOMACY = 36;
    private static final int OFF_GOLD = 2;
    private static final int OFF_TECHS = 88;
    private static final int OFF_TRIBE_NAME = 26;
    private static final int OFF_CIV_NUMBER = 6;
    private static final int SUB_LEN_LEADER_NAME = 23;
    private static final int CONTACT = 1;
    private static final int CEASE_FIRE = 2;
    private static final int PEACE = 4;
    private static final int ALLIANCE = 8;
    private static final int VENDETTA = 16;
    private static final int WAR = 32;
    private static final int EMBASSY = 128;
    private static final char RULES_COMENTARY = ';';
    private static final char RULES_FIELD = '@';
    private static final char RULES_SUB_FIELD = ',';
    private static final int RULES_SUB_FIELD_NAME = 6;

    public SavedGameFile(File f) throws IOException, FileNotFoundException, NotNetFormatException, NotRulesFileFoundException, NotRulesFormatException {
        this.file = new RandomAccessFile(f, "rw");
        this.file.seek(0L);
        byte[] cadenaCIV = new byte[STRING_CIVILIZE.length()];
        int i = 0;
        while (i < STRING_CIVILIZE.length()) {
            cadenaCIV[i] = this.file.readByte();
            ++i;
        }
        if (!STRING_CIVILIZE.equals(new String(cadenaCIV))) {
            throw new NotNetFormatException();
        }
        if (this.file.readByte() != 0) {
            throw new NotNetFormatException();
        }
        this.file.readByte();
        if (this.file.readByte() != 44) {
            throw new NotNetFormatException();
        }
        String folderFile = f.getAbsolutePath();
        int tempIndex = folderFile.lastIndexOf(File.separatorChar);
        String folder = folderFile.substring(0, tempIndex);
        try {
            this.rules = new RandomAccessFile(new File(folder, File.separatorChar + "RULES.TXT"), "r");
        }
        catch (FileNotFoundException e) {
            throw new NotRulesFileFoundException();
        }
        try {
            String tempString;
            do {
                tempString = this.rules.readLine();
                this.techPosition = this.rules.getFilePointer();
            } while (tempString != null && !tempString.equals(STRING_RULES_CIVILIZE));
            this.rules.seek(0L);
            do {
                tempString = this.rules.readLine();
                this.leadersPosition = this.rules.getFilePointer();
            } while (tempString != null && !tempString.equals(STRING_RULES_LEADERS));
        }
        catch (IOException e) {
            throw new NotRulesFormatException();
        }
        this.techCount = 0;
        this.rules.seek(this.techPosition);
        String temp = new String();
        do {
            temp = this.rules.readLine();
            ++this.techCount;
        } while (temp.length() > 0 && temp.charAt(0) != ';' && temp.charAt(0) != '@');
        --this.techCount;
    }

    public int getTechCount() throws IOException {
        return this.techCount;
    }

    public String[] getTechName(int[] i) throws IOException {
        String[] temp = new String[i.length];
        int j = 0;
        while (j < i.length) {
            temp[j] = this.getTechName(i[j]);
            ++j;
        }
        return temp;
    }

    public String getTechName(int i) throws IOException {
        if (i < 1 || i > this.getTechCount()) {
            throw new AssertionError();
        }
        this.rules.seek(this.techPosition);
        String temp = new String("");
        int j = 0;
        while (j < i) {
            temp = this.rules.readLine();
            ++j;
        }
        int pos = temp.indexOf(44);
        return temp.substring(0, pos);
    }

    public boolean isPasswordProtected(int civ) throws IOException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.file.seek(400 + civ * 5);
        byte temp = this.file.readByte();
        return temp != 0;
    }

    public boolean equalPassword(int civ, String texto) throws IOException, NotPasswordProtectedException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        if (!this.isPasswordProtected(civ)) {
            throw new NotPasswordProtectedException();
        }
        this.file.seek(400 + civ * 5);
        byte temp = this.file.readByte();
        int hash = this.file.readInt();
        return hash == texto.hashCode();
    }

    public void setPassword(int civ, String text) throws IOException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.file.seek(400 + civ * 5);
        this.file.writeByte(5);
        this.file.writeInt(text.hashCode());
    }

    public String[] getLeadersNames() throws IOException {
        String[] names = new String[7];
        int i = 0;
        while (i <= 6) {
            this.file.seek(584 + i * 242 + 2);
            byte[] temp = new byte[23];
            int j = 0;
            do {
                temp[j] = this.file.readByte();
            } while (++j < 23 && temp[j - 1] != 0);
            names[i] = temp[0] == 0 ? new String() : new String(temp, 0, j - 1);
            ++i;
        }
        return names;
    }

    public byte[] getSignature() throws IOException {
        this.file.seek(13702L);
        byte[] temp = new byte[14];
        int i = 0;
        while (i < 14) {
            temp[i] = this.file.readByte();
            ++i;
        }
        return temp;
    }

    public void setPeace(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        diplomacy[0] = diplomacy[0] | 4;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFD;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFF7;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ1, civ2, diplomacy);
        diplomacy = this.getDiplomacy(civ2, civ1);
        diplomacy[0] = diplomacy[0] | 4;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFD;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFF7;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ2, civ1, diplomacy);
    }

    public void setCeaseFire(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFB;
        diplomacy[0] = diplomacy[0] | 2;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFF7;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ1, civ2, diplomacy);
        diplomacy = this.getDiplomacy(civ2, civ1);
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFB;
        diplomacy[0] = diplomacy[0] | 2;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFF7;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ2, civ1, diplomacy);
    }

    private int[] getDiplomacy(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ1 + 36 + 4 * civ2);
        int[] diplomacy = new int[4];
        int i = 0;
        while (i < 4) {
            diplomacy[i] = this.file.readUnsignedByte();
            ++i;
        }
        return diplomacy;
    }

    private void setDiplomacy(int civ1, int civ2, int[] diplomacy) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0 || diplomacy.length != 4) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ1 + 36 + 4 * civ2);
        int i = 0;
        while (i < 4) {
            this.file.writeByte(diplomacy[i]);
            ++i;
        }
    }

    public void setAlliance(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFB;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFD;
        diplomacy[0] = diplomacy[0] | 8;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ1, civ2, diplomacy);
        diplomacy = this.getDiplomacy(civ2, civ1);
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFB;
        diplomacy[0] = diplomacy[0] & 0xFFFFFFFD;
        diplomacy[0] = diplomacy[0] | 8;
        diplomacy[1] = diplomacy[1] & 0xFFFFFFDF;
        this.setDiplomacy(civ2, civ1, diplomacy);
    }

    public int getMoney(int civ) throws IOException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ + 2);
        int goldLow = this.file.readUnsignedByte();
        int goldHigh = this.file.readUnsignedByte();
        return goldHigh << 8 | goldLow;
    }

    public void setMoney(int civ, int gold) throws IOException {
        if (civ > 6 || civ < 0 || gold < 0 || gold > 32000) {
            throw new AssertionError();
        }
        int goldLow = gold;
        int goldHigh = gold >>> 8;
        this.file.seek(3706 + 1428 * civ + 2);
        this.file.writeByte(goldLow);
        this.file.writeByte(goldHigh);
    }

    public boolean hasEmbassy(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ1 < 0 || civ2 > 6 || civ2 < 0 || civ1 == civ2) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ1 + 36 + 4 * civ2);
        int temp = this.file.readUnsignedByte();
        return (temp & 0x80) == 128;
    }

    public boolean isAdvance(int civ, int[] i) throws IOException {
        boolean result = true;
        int j = 0;
        while (j < i.length && result) {
            result = result && this.isAdvance(civ, i[j]);
            ++j;
        }
        return result;
    }

    public boolean isAdvance(int civ, int i) throws IOException {
        if (civ > 6 || civ < 0 || i < 1 || i > this.getTechCount()) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ + (i - 1) / 8 + 88);
        int temp = this.file.readUnsignedByte();
        return (temp >>> (i - 1) % 8 & 1) == 1;
    }

    public void setAdvance(int civ, int i, boolean state) throws IOException {
        if (state) {
            this.setAdvanceOn(civ, i);
        } else {
            this.setAdvanceOff(civ, i);
        }
    }

    public void setAdvanceOn(int civ, int i) throws IOException {
        if (civ > 6 || civ < 0 || i < 1 || i > this.getTechCount()) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ + (i - 1) / 8 + 88);
        int temp = this.file.readUnsignedByte();
        this.file.seek(this.file.getFilePointer() - 1L);
        this.file.writeByte(temp |= 1 << (i - 1) % 8);
    }

    public void setAdvanceOff(int civ, int i) throws IOException {
        if (civ > 6 || civ < 0 || i < 1 || i > this.getTechCount()) {
            throw new AssertionError();
        }
        this.file.seek(3706 + 1428 * civ + (i - 1) / 8);
        int temp = this.file.readUnsignedByte();
        this.file.seek(this.file.getFilePointer() - 1L);
        this.file.writeByte(temp &= ~(1 << i - 1));
    }

    public int getTurnNumber() throws IOException {
        this.file.seek(28L);
        int turnLow = this.file.readUnsignedByte();
        int turnHigh = this.file.readUnsignedByte();
        return (turnHigh << 8) + turnLow;
    }

    public boolean checkOfferObsolecence(Offer o) throws IOException {
        boolean check = o.getCivTributer() == 0 ? o.getTurnGame() == this.getTurnNumber() : (o.getCivDemmander() > o.getCivTributer() ? o.getTurnGame() + 1 == this.getTurnNumber() && o.getCivTributer() != this.getLastCivMoved() : o.getTurnGame() == this.getTurnNumber() && o.getCivTributer() != this.getLastCivMoved());
        check = check && o.getGoldDemmander() == this.getMoney(o.getCivDemmander());
        check = check && o.getGoldTributer() == this.getMoney(o.getCivTributer());
        return check;
    }

    public boolean checkOffer(Offer o) throws IOException {
        boolean check = true;
        try {
            int i;
            check = Arrays.equals(o.getSignature(), this.getSignature());
            check = check && o.getCivDemmander() <= 6;
            check = check && o.getCivDemmander() >= 0;
            check = check && o.getCivTributer() <= 6;
            check = check && o.getCivTributer() >= 0;
            check = check && o.getCivDemmander() != o.getCivTributer();
            check = check && o.getGoldDemmanderTributer() <= o.getGoldDemmander();
            check = check && o.getGoldDemmanderTributer() >= 0;
            check = check && o.getGoldTributerDemmander() <= o.getGoldTributer();
            check = check && o.getGoldTributerDemmander() >= 0;
            boolean bl = check = check && this.checkOfferObsolecence(o);
            if (o.getTechDemmanderTributer() != null && check) {
                i = 0;
                while (i < o.getTechDemmanderTributer().length) {
                    check = check && this.isAdvance(o.getCivDemmander(), o.getTechDemmanderTributer()[i]);
                    check = check && !this.isAdvance(o.getCivTributer(), o.getTechDemmanderTributer()[i]);
                    ++i;
                }
            }
            if (o.getTechTributerDemmander() != null && check) {
                i = 0;
                while (i < o.getTechTributerDemmander().length) {
                    check = check && this.isAdvance(o.getCivTributer(), o.getTechTributerDemmander()[i]);
                    check = check && !this.isAdvance(o.getCivDemmander(), o.getTechTributerDemmander()[i]);
                    ++i;
                }
            }
        }
        catch (AssertionError e) {
            check = false;
        }
        return check;
    }

    public int[] getCivsMeet(int civ1) throws IOException {
        if (civ1 > 6 || civ1 < 0) {
            throw new AssertionError();
        }
        int[] contact = new int[7];
        int count = 0;
        int i = 0;
        while (i <= 6) {
            if (i != civ1) {
                this.file.seek(3706 + 1428 * civ1 + 36 + 4 * i);
                int tempByte = this.file.readUnsignedByte();
                int tempByte2 = this.file.readUnsignedByte();
                if ((tempByte & 1) == 1 || (tempByte & 4) == 4 || (tempByte & 2) == 2 || (tempByte & 8) == 8 || (tempByte & 0x10) == 16 || (tempByte & 0x80) == 128 || (tempByte2 & 0x20) == 32) {
                    contact[count++] = i;
                }
            }
            ++i;
        }
        int[] contact2 = null;
        if (count > 0) {
            contact2 = new int[count];
            int i2 = 0;
            while (i2 < count) {
                contact2[i2] = contact[i2];
                ++i2;
            }
        }
        return contact2;
    }

    public int getLastCivMoved() throws IOException {
        this.file.seek(41L);
        return this.file.readUnsignedByte() - 1;
    }

    public void setOffer(Offer o) throws NotOfferCheckedException, IOException {
        int i;
        if (!this.checkOffer(o)) {
            throw new NotOfferCheckedException();
        }
        this.setMoney(o.getCivDemmander(), this.getMoney(o.getCivDemmander()) + o.getGoldTributerDemmander() - o.getGoldDemmanderTributer());
        this.setMoney(o.getCivTributer(), this.getMoney(o.getCivTributer()) + o.getGoldDemmanderTributer() - o.getGoldTributerDemmander());
        if (o.getTechDemmanderTributer() != null) {
            i = 0;
            while (i < o.getTechDemmanderTributer().length) {
                this.setAdvanceOn(o.getCivTributer(), o.getTechDemmanderTributer()[i]);
                ++i;
            }
        }
        if (o.getTechTributerDemmander() != null) {
            i = 0;
            while (i < o.getTechTributerDemmander().length) {
                this.setAdvanceOn(o.getCivDemmander(), o.getTechTributerDemmander()[i]);
                ++i;
            }
        }
        if (o.getPeace()) {
            this.setPeace(o.getCivDemmander(), o.getCivTributer());
        } else if (o.getCeaseFire()) {
            this.setCeaseFire(o.getCivDemmander(), o.getCivTributer());
        } else if (o.getAlliance()) {
            this.setAlliance(o.getCivDemmander(), o.getCivTributer());
        }
    }

    public static void main(String[] args) {
        System.exit(0);
        System.out.println("Standard test for Civ2 PBEM Diplomacy-NET Files");
        System.out.println("Made by Javier Mu\u00f1oz Kirschberg - M\u00e1laga 2002");
        System.out.println("Please enter the full path of the file to open:");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            String name = input.readLine();
            File file = new File(name);
            SavedGameFile saved = new SavedGameFile(file);
            System.out.println("The leaders names:");
            String[] cadenas = saved.getLeadersNames();
            int i = 0;
            while (i < cadenas.length) {
                System.out.println(i + "." + cadenas[i]);
                ++i;
            }
        }
        catch (NullPointerException e) {
            System.out.println("Incorrect FileName");
        }
        catch (IOException e) {
            System.out.println("Error while reading file name");
        }
        catch (NotNetFormatException e) {
            System.out.println("Not a corret CIV2-MGE multiplayer savegame!");
        }
        catch (NotRulesFileFoundException e) {
            System.out.println("RULES.TXT must be in the same folder that .NET file");
        }
        catch (NotRulesFormatException e) {
            System.out.println("Not a correct RULES.TXT");
        }
    }

    public int[] getTechCommon(int civ1, int civ2) throws IOException {
        int[] temp2;
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] temp = new int[104];
        int count = 0;
        int i = 1;
        while (i < this.getTechCount()) {
            if (this.isAdvance(civ1, i) && this.isAdvance(civ2, i)) {
                temp[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            temp2 = null;
        } else {
            temp2 = new int[count];
            int i2 = 0;
            while (i2 < count) {
                temp2[i2] = temp[i2];
                ++i2;
            }
        }
        return temp2;
    }

    public int[] getTechAll() throws IOException {
        int[] temp = new int[this.techCount];
        int count = 0;
        int i = 1;
        while (i <= this.techCount) {
            temp[count++] = i++;
        }
        return temp;
    }

    public int[] getTechCiv(int civ1) throws IOException {
        int[] temp = new int[this.techCount];
        int count = 0;
        int i = 1;
        while (i <= this.techCount) {
            if (this.isAdvance(civ1, i)) {
                temp[count++] = i;
            }
            ++i;
        }
        int[] temp2 = new int[count];
        int i2 = 0;
        while (i2 < count) {
            temp2[i2] = temp[i2];
            ++i2;
        }
        return temp2;
    }

    public int[] getTechLess(int[] tech1, int[] tech2) throws IOException {
        int[] tech3 = tech2;
        if (tech1 != null && tech2 != null) {
            int[] tech4 = new int[104];
            int count = 0;
            int i = 0;
            while (i < tech2.length) {
                boolean found = false;
                int j = 0;
                while (j < tech1.length) {
                    if (tech1[j] == tech2[i]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    tech4[count++] = tech2[i];
                }
                ++i;
            }
            tech3 = new int[count];
            int i2 = 0;
            while (i2 < count) {
                tech3[i2] = tech4[i2];
                ++i2;
            }
        }
        return tech3;
    }

    public int[] getTechAdvantage(int civ1, int civ2) throws IOException {
        int[] temp2;
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] temp = new int[104];
        int count = 0;
        int i = 1;
        while (i < this.getTechCount()) {
            if (this.isAdvance(civ1, i) && !this.isAdvance(civ2, i)) {
                temp[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            temp2 = null;
        } else {
            temp2 = new int[count];
            int i2 = 0;
            while (i2 < count) {
                temp2[i2] = temp[i2];
                ++i2;
            }
        }
        return temp2;
    }

    public String getTribeName(int civ) throws IOException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.file.seek(584 + civ * 242 + 26);
        byte[] tribe = new byte[13];
        this.file.readFully(tribe);
        String temp = new String(tribe);
        if (tribe[0] == 0) {
            this.rules.seek(this.leadersPosition);
            this.file.seek(3706 + civ * 1428 + 6);
            int civNumber = this.file.readUnsignedByte();
            String temp2 = new String(tribe);
            int i = 0;
            while (i <= civNumber) {
                temp2 = this.rules.readLine();
                ++i;
            }
            int indexStart = 0;
            int indexFinish = indexStart + 1;
            int i2 = 1;
            while (i2 <= 6) {
                indexStart = temp2.indexOf(44, indexStart + 1);
                ++i2;
            }
            indexFinish = temp2.indexOf(44, indexStart + 1);
            temp = temp2.substring(indexStart + 1, indexFinish).trim();
        } else {
            int index = temp.indexOf(0);
            if (index < temp.length() && index > 0) {
                temp = temp.substring(0, index);
            }
        }
        return temp;
    }

    public boolean isPeace(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        return (diplomacy[0] & 4) == 4;
    }

    public boolean isAlliance(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        return (diplomacy[0] & 8) == 8;
    }

    public boolean isCeaseFire(int civ1, int civ2) throws IOException {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        int[] diplomacy = this.getDiplomacy(civ1, civ2);
        return (diplomacy[0] & 2) == 2;
    }

    static {
        FINAL = 0;
        VERSION_MGE = (byte)44;
        MIN_CIV = 0;
        MAX_CIV = 6;
        MAX_GOLD = 32000;
        MIN_GOLD = 0;
        MIN_TECH = 1;
        MAX_TECH = 104;
        POS_TRIBES = 584;
        POS_TECHS = 3706;
        POS_CLAVES = 400;
        POS_MAP_HEADER = 13702;
        POS_TURN = 28;
        POS_LAST_CIV_MOVED = 41;
        LEN_MAP_HEADER = 14;
        LEN_SIGNATURE = 14;
        LEN_TRIBES = 242;
        LEN_PASSWORD = 5;
        LEN_TRIBE_NAME = 13;
        LEN_TECHS = 1428;
        LEN_TECHS_TECS = 11;
        LEN_DIPLOMACY = 4;
        OFF_LEADER_NAME = 2;
        OFF_DIPLOMACY = 36;
        OFF_GOLD = 2;
        OFF_TECHS = 88;
        OFF_TRIBE_NAME = 26;
        OFF_CIV_NUMBER = 6;
        SUB_LEN_LEADER_NAME = 23;
        CONTACT = 1;
        CEASE_FIRE = 2;
        PEACE = 4;
        ALLIANCE = 8;
        VENDETTA = 16;
        WAR = 32;
        EMBASSY = 128;
        RULES_COMENTARY = (char)59;
        RULES_FIELD = (char)64;
        RULES_SUB_FIELD = (char)44;
        RULES_SUB_FIELD_NAME = 6;
    }
}

