/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class Launcher
extends JFrame {
    public static final int ENGLISH = 0;
    public static final int SPANISH = 1;
    public static final int ITALIAN = 2;
    public static final int GERMAN = 3;
    private static final String STR_NEW_LINE;
    private static final String[] STR_WELCOME;
    private static final String[] STR_FILE_NOT_FOUND_ERROR;
    private static final String[] STR_ERROR;
    private static final String[] STR_IO_ERROR;
    private static final String[] STR_NO_NET_ERROR;
    private static final String[] STR_RULES_NOT_FOUND_ERROR;
    private static final String[] STR_RULES_BAD_FORMAT_ERROR;
    private static final String[] STR_SELECT_LEADER_NAME;
    private static final String[] STR_WELCOME_LEADER;
    private static final String[] STR_SET_PASSWORD;
    private static final String[] STR_MAKE_BARTER;
    private static final String[] STR_VIEW_BARTER;
    private static final String[] STR_NO_DIP_WITHOUT_PASSWORD;
    private static final String[] STR_PASSWORD;
    private static final String[] STR_FIRST_PASSWORD;
    private static final String[] STR_PASSWORD_ERROR;
    private static final String[] STR_CONFIRM_PASSWORD;
    private static final String[] STR_NOT_MATCH_PASSWORD;
    private static final String[] STR_DONE;
    private static final String[] STR_OPPOSITE_LEADER;
    private static final String[] STR_FIRST_OFFER;
    private static final String[] STR_SECOND_OFFER;
    private static final String[] STR_DO_YOU_ACCEPT;
    private static final String[] STR_GOLD;
    private static final String[] STR_PEACE_TEATRY;
    private static final String[] STR_ALLIANCE_TEATRY;
    private static final String[] STR_CEASE_FIRE_TEATRY;
    private static final String[] STR_SECRET_OF;
    private static final String[] STR_THIRD_OFFER;
    private static final String[] STR_FOUR_OFFER;
    private static final String[] STR_NOT_GOOD_OFFER_ERROR;
    private static final String[] STR_NOT_NEW_OFFER_ERROR;
    private static final String[] STR_SECURITY_ERROR;
    private static final String[] STR_INTERNAL_ERROR;
    private static final String[] STR_BUTTON_NEXT;
    private static final String[] STR_BUTTON_PREV;
    private static final String[] STR_LANGUAGE;
    private static final String[] STR_ENGLISH;
    private static final String[] STR_SPANISH;
    private static final String[] STR_NOT_FOR_YOU;
    private static final String[] STR_ITALIAN;
    private static final String[] STR_GERMAN;
    private static final String[] STR_CREDITS;
    private static final int INIT_STATE = 0;
    private static final int SELECTED_FILE = 1;
    private static final int SELECTED_CIV = 2;
    private static final int INTRO_PASSWORD = 3;
    private static final int RE_INTRO_PASSWORD = 4;
    private static final int MAKE_OFFER = 5;
    private static final int VIEW_OFFER = 6;
    private static final int SELECT_TRIBUTER_CIV = 7;
    private static final int NO_ACTION = 0;
    private static final int SET_PASSWORD_ACTION = 1;
    private static final int MAKE_BARTER_ACTION = 2;
    private static final int VIEW_BARTER_ACTION = 3;
    private int action = 0;
    private boolean firstPassword = false;
    private int state = 0;
    private SavedGameFile file = null;
    private int[] matching = new int[7];
    private String[] names = null;
    private String tempPassword;
    private JRadioButton[] jRadioButtonArray;
    private int language = 0;
    private int civSelected;
    private Offer offer = new Offer();
    private JPanel jPanel1;
    private JLabel label;
    private JLabel labelLanguage;
    private ButtonGroup buttonGroup1;
    private JComboBox languageComboBox;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton1;
    private JPasswordField textField;
    private JLabel jLabel1;
    private JLabel labelCredits;
    private JButton buttonPrev;
    private JButton buttonNext;

    public Launcher() {
        this.initComponents();
        this.state = 0;
        this.jRadioButtonArray = new JRadioButton[7];
        this.jRadioButtonArray[0] = this.jRadioButton1;
        this.jRadioButtonArray[1] = this.jRadioButton2;
        this.jRadioButtonArray[2] = this.jRadioButton3;
        this.jRadioButtonArray[3] = this.jRadioButton4;
        this.jRadioButtonArray[4] = this.jRadioButton5;
        this.jRadioButtonArray[5] = this.jRadioButton6;
        this.jRadioButtonArray[6] = this.jRadioButton7;
        this.languageComboBox.setVisible(true);
        this.languageComboBox.removeAllItems();
        this.languageComboBox.addItem(STR_ENGLISH[this.language]);
        this.languageComboBox.addItem(STR_SPANISH[this.language]);
        this.languageComboBox.addItem(STR_ITALIAN[this.language]);
        this.languageComboBox.addItem(STR_GERMAN[this.language]);
        this.setState();
    }

    private void showDone() {
        JOptionPane.showMessageDialog(null, STR_DONE[this.language], STR_DONE[this.language], 1);
    }

    private void hideAll() {
        int i = 0;
        while (i < this.jRadioButtonArray.length) {
            this.jRadioButtonArray[i].setVisible(false);
            this.jRadioButtonArray[i].setSelected(false);
            ++i;
        }
        this.label.setVisible(false);
        if (this.state != 0) {
            this.buttonPrev.setEnabled(true);
            this.buttonNext.setEnabled(false);
            this.labelCredits.setVisible(false);
        } else {
            this.buttonPrev.setEnabled(false);
            this.buttonNext.setEnabled(true);
            this.labelCredits.setText(STR_CREDITS[this.language]);
            this.labelCredits.setVisible(true);
        }
        this.buttonNext.setText(STR_BUTTON_NEXT[this.language]);
        this.buttonPrev.setText(STR_BUTTON_PREV[this.language]);
        this.labelLanguage.setText(STR_LANGUAGE[this.language]);
        this.labelLanguage.setVisible(true);
        this.languageComboBox.setVisible(true);
        this.languageComboBox.removeAllItems();
        this.languageComboBox.addItem(STR_ENGLISH[this.language]);
        this.languageComboBox.addItem(STR_SPANISH[this.language]);
        this.languageComboBox.addItem(STR_ITALIAN[this.language]);
        this.languageComboBox.addItem(STR_GERMAN[this.language]);
        this.textField.setVisible(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.buttonNext = new JButton();
        this.buttonPrev = new JButton();
        this.label = new JLabel();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.textField = new JPasswordField();
        this.labelLanguage = new JLabel();
        this.languageComboBox = new JComboBox();
        this.labelCredits = new JLabel();
        this.setTitle("CIV2 PBEM DIPLOMACY");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Launcher.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.jPanel1.setPreferredSize(new Dimension(600, 440));
        this.jLabel1.setFont(new Font("Dialog", 1, 24));
        this.jLabel1.setText("CIV2 PBEM DIPLOMACY Utility");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(100, 20, 370, 40);
        this.jRadioButton1.setText("Set Password");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton1);
        this.jRadioButton1.setBounds(40, 90, 160, 24);
        this.jRadioButton2.setText("Make Barter");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton2);
        this.jRadioButton2.setBounds(230, 90, 180, 24);
        this.jRadioButton3.setText("Accept Barter");
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton3);
        this.jRadioButton3.setBounds(420, 90, 160, 24);
        this.buttonNext.setText("Next>>");
        this.buttonNext.setAutoscrolls(true);
        this.buttonNext.setEnabled(false);
        this.buttonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.buttonNextActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buttonNext);
        this.buttonNext.setBounds(510, 330, 74, 26);
        this.buttonPrev.setText("<<Prev");
        this.buttonPrev.setEnabled(false);
        this.buttonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.buttonPrevActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buttonPrev);
        this.buttonPrev.setBounds(10, 330, 74, 26);
        this.label.setText("First of all, we're going to load the save file");
        this.jPanel1.add(this.label);
        this.label.setBounds(120, 246, 330, 20);
        this.jRadioButton4.setText("jRadioButton4");
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton4);
        this.jRadioButton4.setBounds(40, 140, 170, 24);
        this.jRadioButton5.setText("jRadioButton5");
        this.buttonGroup1.add(this.jRadioButton5);
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton5);
        this.jRadioButton5.setBounds(230, 140, 170, 24);
        this.jRadioButton6.setText("jRadioButton6");
        this.buttonGroup1.add(this.jRadioButton6);
        this.jRadioButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton6);
        this.jRadioButton6.setBounds(420, 140, 170, 24);
        this.jRadioButton7.setText("jRadioButton7");
        this.buttonGroup1.add(this.jRadioButton7);
        this.jRadioButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton7);
        this.jRadioButton7.setBounds(40, 190, 180, 24);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                Launcher.this.textFieldTextChange(evt);
            }
        });
        this.jPanel1.add(this.textField);
        this.textField.setBounds(10, 290, 570, 20);
        this.labelLanguage.setText("Language");
        this.jPanel1.add(this.labelLanguage);
        this.labelLanguage.setBounds(120, 330, 120, 16);
        this.languageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.languageComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.languageComboBox);
        this.languageComboBox.setBounds(270, 330, 120, 25);
        this.labelCredits.setText("jLabel2");
        this.jPanel1.add(this.labelCredits);
        this.labelCredits.setBounds(40, 80, 550, 40);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(600, 390));
        this.setLocation((screenSize.width - 600) / 2, (screenSize.height - 390) / 2);
    }

    private void languageComboBoxActionPerformed(ActionEvent evt) {
        if (this.languageComboBox.getSelectedItem() == STR_ENGLISH[this.language]) {
            this.language = 0;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == STR_SPANISH[this.language]) {
            this.language = 1;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == STR_ITALIAN[this.language]) {
            this.language = 2;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == STR_GERMAN[this.language]) {
            this.language = 3;
            this.setState();
        }
    }

    private void textFieldTextChange(KeyEvent evt) {
        if (new String(this.textField.getPassword()).length() > 0) {
            this.buttonNext.setEnabled(true);
        } else {
            this.buttonNext.setEnabled(false);
        }
    }

    private void jRadioButton7ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void buttonPrevActionPerformed(ActionEvent evt) {
        switch (this.state) {
            case 1: {
                this.state = 0;
                this.setState();
                break;
            }
            case 2: {
                this.state = 1;
                this.setState();
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                this.state = 2;
                this.setState();
            }
        }
    }

    private void buttonNextActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        switch (this.state) {
            case 0: {
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal != 0) break;
                try {
                    this.file = new SavedGameFile(chooser.getSelectedFile());
                    this.state = 1;
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(null, STR_FILE_NOT_FOUND_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotNetFormatException e) {
                    JOptionPane.showMessageDialog(null, STR_NO_NET_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotRulesFileFoundException e) {
                    JOptionPane.showMessageDialog(null, STR_RULES_NOT_FOUND_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotRulesFormatException e) {
                    JOptionPane.showMessageDialog(null, STR_RULES_BAD_FORMAT_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                this.setState();
                break;
            }
            case 1: {
                int i = 0;
                while (i < 7) {
                    if (this.jRadioButtonArray[i].isSelected()) {
                        this.offer.setCivDemmander(this.matching[i]);
                        this.civSelected = this.matching[i];
                    }
                    ++i;
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 2: {
                try {
                    if (!this.file.isPasswordProtected(this.civSelected)) {
                        if (this.jRadioButton1.isSelected()) {
                            if (this.action == 1) {
                                this.firstPassword = true;
                                this.state = 3;
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, STR_NO_DIP_WITHOUT_PASSWORD[this.language], STR_ERROR[this.language], 0);
                            this.state = 1;
                        }
                    } else {
                        this.state = 3;
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                this.setState();
                break;
            }
            case 3: {
                this.tempPassword = new String(this.textField.getPassword());
                if (this.action == 1 && this.firstPassword) {
                    this.state = 4;
                } else {
                    try {
                        if (!this.file.equalPassword(this.civSelected, this.tempPassword)) {
                            JOptionPane.showMessageDialog(null, STR_PASSWORD_ERROR[this.language], STR_ERROR[this.language], 0);
                            this.state = 3;
                        } else {
                            switch (this.action) {
                                case 1: {
                                    this.state = 4;
                                    break;
                                }
                                case 2: {
                                    this.state = 7;
                                    break;
                                }
                                case 3: {
                                    this.state = 6;
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                        this.state = 2;
                    }
                    catch (NotPasswordProtectedException e) {
                        JOptionPane.showMessageDialog(null, STR_INTERNAL_ERROR[this.language], STR_ERROR[this.language], 0);
                        this.state = 2;
                    }
                }
                this.setState();
                break;
            }
            case 4: {
                String tempPassword2 = new String(this.textField.getPassword());
                try {
                    if (this.firstPassword && !tempPassword2.equals(this.tempPassword)) {
                        JOptionPane.showMessageDialog(null, STR_NOT_MATCH_PASSWORD[this.language], STR_ERROR[this.language], 0);
                    } else {
                        this.file.setPassword(this.civSelected, tempPassword2);
                        this.firstPassword = false;
                        this.showDone();
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 7: {
                int i = 0;
                while (i < 7 && !this.jRadioButtonArray[i].isSelected()) {
                    ++i;
                }
                this.offer.setCivTributer(this.matching[i]);
                this.state = 5;
                this.setState();
            }
        }
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 3;
        }
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 2;
        }
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 1;
        }
        this.buttonNext.setEnabled(true);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void setState() {
        JFileChooser chooser = new JFileChooser();
        DiplomaticDialog dialog = new DiplomaticDialog((Frame)this, true);
        switch (this.state) {
            case 0: {
                this.hideAll();
                this.label.setVisible(true);
                this.label.setText(STR_WELCOME[this.language]);
                break;
            }
            case 1: {
                this.hideAll();
                this.label.setVisible(true);
                this.label.setText(STR_SELECT_LEADER_NAME[this.language]);
                try {
                    this.names = this.file.getLeadersNames();
                    int j = 0;
                    int i = 0;
                    while (i < this.names.length) {
                        if (this.names[i].length() > 0) {
                            this.jRadioButtonArray[j].setText(this.names[i] + " (" + this.file.getTribeName(i) + ")");
                            this.jRadioButtonArray[j].setVisible(true);
                            this.jRadioButtonArray[j].setEnabled(true);
                            this.matching[j] = i;
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                    this.state = 0;
                    this.setState();
                }
                break;
            }
            case 2: {
                this.hideAll();
                this.label.setText(STR_WELCOME_LEADER[this.language] + this.names[this.civSelected]);
                this.label.setVisible(true);
                this.jRadioButton1.setVisible(true);
                this.jRadioButton2.setVisible(true);
                this.jRadioButton3.setVisible(true);
                this.jRadioButton1.setText(STR_SET_PASSWORD[this.language]);
                this.jRadioButton2.setText(STR_MAKE_BARTER[this.language]);
                this.jRadioButton3.setText(STR_VIEW_BARTER[this.language]);
                break;
            }
            case 3: {
                this.hideAll();
                if (this.firstPassword) {
                    this.label.setText(STR_FIRST_PASSWORD[this.language]);
                } else {
                    this.label.setText(STR_PASSWORD[this.language]);
                }
                this.label.setVisible(true);
                this.textField.setVisible(true);
                this.textField.setEditable(true);
                this.textField.setText("");
                break;
            }
            case 4: {
                this.hideAll();
                if (this.firstPassword) {
                    this.label.setText(STR_CONFIRM_PASSWORD[this.language]);
                } else {
                    this.label.setText(STR_FIRST_PASSWORD[this.language]);
                }
                this.label.setVisible(true);
                this.textField.setVisible(true);
                this.textField.setEditable(true);
                this.textField.setText("");
                break;
            }
            case 7: {
                this.hideAll();
                this.label.setText(STR_OPPOSITE_LEADER[this.language]);
                this.label.setVisible(true);
                int j = 0;
                try {
                    int[] temp = this.file.getCivsMeet(this.civSelected);
                    int i = 0;
                    while (i < temp.length) {
                        if (this.names[temp[i]].length() > 0) {
                            this.matching[j] = temp[i];
                            this.jRadioButtonArray[j].setText(this.names[temp[i]] + " (" + this.file.getTribeName(temp[i]) + ")");
                            this.jRadioButtonArray[j].setVisible(true);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                }
                break;
            }
            case 5: {
                try {
                    if (dialog.show(this.offer, this.file, this.language) && chooser.showSaveDialog(this) == 0) {
                        FileOutputStream f = new FileOutputStream(chooser.getSelectedFile());
                        f.getChannel().truncate(0L);
                        ObjectOutputStream p = new ObjectOutputStream(f);
                        this.offer.setTurnGame(this.file.getTurnNumber());
                        this.offer.setSignature(this.file.getSignature());
                        this.offer.setGoldDemmander(this.file.getMoney(this.offer.getCivDemmander()));
                        this.offer.setGoldTributer(this.file.getMoney(this.offer.getCivTributer()));
                        this.offer.writeExternal(p);
                        this.showDone();
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                }
                catch (SecurityException e) {
                    JOptionPane.showMessageDialog(null, STR_SECURITY_ERROR[this.language], STR_ERROR[this.language], 0);
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 6: {
                if (chooser.showOpenDialog(this) == 0) {
                    try {
                        ObjectInputStream p = new ObjectInputStream(new FileInputStream(chooser.getSelectedFile()));
                        Offer offer = new Offer();
                        offer.readExternal(p);
                        if (offer.getCivTributer() != this.civSelected) {
                            JOptionPane.showMessageDialog(null, STR_NOT_FOR_YOU[this.language], STR_ERROR[this.language], 0);
                        } else if (!this.file.checkOffer(offer)) {
                            if (!this.file.checkOfferObsolecence(offer)) {
                                JOptionPane.showMessageDialog(null, STR_NOT_NEW_OFFER_ERROR[this.language], STR_ERROR[this.language], 0);
                            } else {
                                JOptionPane.showMessageDialog(null, STR_NOT_GOOD_OFFER_ERROR[this.language], STR_ERROR[this.language], 0);
                            }
                        } else {
                            String text = STR_FIRST_OFFER[this.language];
                            text = text + this.file.getLeadersNames()[offer.getCivDemmander()] + STR_SECOND_OFFER[this.language];
                            text = text + offer.getGoldDemmanderTributer() + STR_GOLD[this.language] + STR_NEW_LINE;
                            if (offer.getPeace()) {
                                text = text + STR_PEACE_TEATRY[this.language] + STR_NEW_LINE;
                            } else if (offer.getAlliance()) {
                                text = text + STR_ALLIANCE_TEATRY[this.language] + STR_NEW_LINE;
                            } else if (offer.getCeaseFire()) {
                                text = text + STR_CEASE_FIRE_TEATRY[this.language] + STR_NEW_LINE;
                            }
                            int[] techDemmanderTributer = offer.getTechDemmanderTributer();
                            if (techDemmanderTributer != null) {
                                int i = 0;
                                while (i < techDemmanderTributer.length) {
                                    text = text + STR_SECRET_OF[this.language];
                                    text = text + this.file.getTechName(techDemmanderTributer[i]);
                                    text = text + STR_NEW_LINE;
                                    ++i;
                                }
                            }
                            text = text + STR_THIRD_OFFER[this.language];
                            text = text + STR_FOUR_OFFER[this.language] + this.file.getLeadersNames()[offer.getCivTributer()] + STR_NEW_LINE;
                            text = text + offer.getGoldTributerDemmander() + STR_GOLD[this.language] + STR_NEW_LINE;
                            int[] techTributerDemmander = offer.getTechTributerDemmander();
                            if (techTributerDemmander != null) {
                                int i = 0;
                                while (i < techTributerDemmander.length) {
                                    text = text + STR_SECRET_OF[this.language] + this.file.getTechName(techTributerDemmander[i]) + STR_NEW_LINE;
                                    ++i;
                                }
                            }
                            if (JOptionPane.showConfirmDialog(null, text, STR_DO_YOU_ACCEPT[this.language], 0) == 0) {
                                this.file.setOffer(offer);
                                this.showDone();
                            }
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(null, STR_IO_ERROR[this.language], STR_ERROR[this.language], 0);
                    }
                    catch (SecurityException e) {
                        JOptionPane.showMessageDialog(null, STR_SECURITY_ERROR[this.language], STR_ERROR[this.language], 0);
                    }
                    catch (NotOfferCheckedException e) {
                        JOptionPane.showMessageDialog(null, STR_NOT_GOOD_OFFER_ERROR[this.language], STR_ERROR[this.language], 0);
                    }
                }
                this.state = 2;
                this.setState();
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Launcher().show();
    }

    static {
        ENGLISH = 0;
        SPANISH = 1;
        ITALIAN = 2;
        GERMAN = 3;
        STR_NEW_LINE = System.getProperty("line.separator");
        STR_WELCOME = new String[]{"First of all, we're going to load the .NET file", "Para empezar, cargemos el archivo .NET", "In primo luogo stiamo andando caricare il file del .NET", "Zuerst laden wir die .net Datei"};
        STR_FILE_NOT_FOUND_ERROR = new String[]{"File not found error", "Error: El archivo no se encuentra", "Non trovato del file", "Datei nicht gefunden"};
        STR_ERROR = new String[]{"Error", "Error", "Errore", "Fehler"};
        STR_IO_ERROR = new String[]{"Input/Output file error", "Error leyendo/escribiendo archivo", "Errore del file dell'ingreso/uscita", "Datei Fehler"};
        STR_NO_NET_ERROR = new String[]{"No a correct NET File", "No es un archivo NET con formato adecuado", "Non un file NET corretta", "Keine korrekte NET Datei"};
        STR_RULES_NOT_FOUND_ERROR = new String[]{"Unable to find a correct RULES.TXT in the same folder!", "No se puede encontrar el archivo RULES.TXT en el mismo directorio", "Incapace trovare un RULES.TXT corretto nello stesso dispositivo di piegatura!", "Es wurde keine korrekte RULES.TXT Datei gefunden!"};
        STR_RULES_BAD_FORMAT_ERROR = new String[]{"Bad RULES.TXT format", "Archivo RULES.TXT con formato incorrecto", "Disposizione difettosa di RULES.TXT", "Falsches RULES.TXT Format"};
        STR_SELECT_LEADER_NAME = new String[]{"Please select your leader name", "Escoge a tu lider", "Per favore selezioni il nome del vostro re", "Bitte w\u00e4hlen Sie einen Namen"};
        STR_WELCOME_LEADER = new String[]{"Welcome, great ", "Bienvenido, gran ", "Benvenuto, grande ", "Willkommen, gro\u00dfartiger "};
        STR_SET_PASSWORD = new String[]{"Set/Change Password", "Establecer/Modificar Clave", "Fissare/cambiare il codice", "Setzen Sie/\u00c4ndern Sie das Pa\u00dfwort"};
        STR_MAKE_BARTER = new String[]{"Make barter", "Hacer oferta", "Faccia il baratto", "Schlagen Sie einen Handel vor"};
        STR_VIEW_BARTER = new String[]{"View barter", "Ver oferta", "Guarda il baratto", "Handel ansehen"};
        STR_NO_DIP_WITHOUT_PASSWORD = new String[]{"You can not make/view barter withouth setting a password!", "No se pueden realizar acciones diplomaticas sin clave", "Non potete di faccia/guarda il baratto senza regolare un codice!", "Sie k\u00f6nnen keinen Handel vorschlagen ohne ein Pa\u00dfwort zu setzen!"};
        STR_PASSWORD = new String[]{"Please enter your password for this file", "Por favor introduzca su clave para este archivo", "Prego digiti il vostro codice per queste file", "Bitte geben Sie Ihr Pa\u00dfwort f\u00fcr diese Datei ein"};
        STR_FIRST_PASSWORD = new String[]{"Please enter a NEW password for this file", "Por favor introduzca una NUEVA clave para este archivo", "Prego digiti un NUOVO codice per queste file", "Bitte setzen Sie ein NEUES Pa\u00dfwort f\u00fcr diese Datei"};
        STR_PASSWORD_ERROR = new String[]{"You're a pretender! The password you enter is not valid!", "\u00a1Impostor! \u00a1La clave que has introducido no es la correcta!", "Siete un pretender! Il codice che digitate \u00e8 non valide!", "Sie sind ein Usurpator! Pa\u00dfwort nicht korrekt!"};
        STR_CONFIRM_PASSWORD = new String[]{"Please confirm password:", "Por favor, confirma la contrase\u00f1a", "Prego confermi il codice:", "Bitte best\u00e4tigen Sie das Pa\u00dfwort:"};
        STR_NOT_MATCH_PASSWORD = new String[]{"Passwords does not match!", "\u00a1Las contrase\u00f1as introducidas no son iguales!", "Il codice non \u00e8 valido!", "Nicht korrektes Pa\u00dfwort!"};
        STR_DONE = new String[]{"Done!", "\u00a1Hecho!", "Fatto!", "Erledigt!"};
        STR_OPPOSITE_LEADER = new String[]{"Please select the leader name to make offer to", "\u00bfA que lider quieres realizar la oferta?", "Prego selezioni il nome del re per fare l'offerta a", "Bitte w\u00e4hlen Sie den Herrscher dem Sie einen Handel vorschlagen m\u00f6chten"};
        STR_FIRST_OFFER = new String[]{"The offer..." + STR_NEW_LINE, "La oferta..." + STR_NEW_LINE, "L'offerta..." + STR_NEW_LINE, "Das Angebot..." + STR_NEW_LINE};
        STR_SECOND_OFFER = new String[]{" offers you:" + STR_NEW_LINE, " te ofrece:" + STR_NEW_LINE, " offerte voi:" + STR_NEW_LINE, " bietet Ihnen:" + STR_NEW_LINE};
        STR_DO_YOU_ACCEPT = new String[]{" Do you accept the offer?", " \u00bfAceptas la oferta?", " accettate l'offerta?", " Akzeptieren Sie das Angebot?"};
        STR_GOLD = new String[]{" gold", " oro", " soldi", " Gold"};
        STR_PEACE_TEATRY = new String[]{"A peace teatry", "Un tratado de paz", "Un trattato di pace", "Ein Friedensvertrag"};
        STR_ALLIANCE_TEATRY = new String[]{"An alliance", "Una alianza", "Un'alleanza", "Eine Allianz"};
        STR_CEASE_FIRE_TEATRY = new String[]{"A cease-fire", "Una tregua", "Un'armistizio", "Ein Waffenstillstand"};
        STR_SECRET_OF = new String[]{"The secret of ", "El secreto de ", "Il segreto di", "Das Geheimnis "};
        STR_THIRD_OFFER = new String[]{"And demmands from you ", "Y exige de ti ", "E richieste da voi", "Und verlangt von Ihnen "};
        STR_FOUR_OFFER = new String[]{"Great Leader, ", "Gran lider, ", "Righello Grande, ", "Gro\u00dfer Herrscher, "};
        STR_NOT_GOOD_OFFER_ERROR = new String[]{"Incorrect offer - The other leader ask you for something that you don't have ", "Oferta inv\u00e1lida: te demandan algo que no tienes, ", "Offerta errata - l'altra righello vi chiede qualcosa che non abbiate", "Inkorrektes Angebot: Der Herrscher verlangte etwas von Ihnen das sie nicht besitzen "};
        STR_NOT_NEW_OFFER_ERROR = new String[]{"Obsolete offer", "Oferta anticuada", "Disusi l'offerta", "Veraltetes Angebot"};
        STR_SECURITY_ERROR = new String[]{"Error security!", "\u00a1Error de seguridad!", "Errore della sicurezza!", "Sicherheitsfehler!"};
        STR_INTERNAL_ERROR = new String[]{"Internal errror", "Error Interno", "Errore interno", "Interner Fehler"};
        STR_BUTTON_NEXT = new String[]{"Next>>", "Sig>>", "Dopo>>", "Weiter>>"};
        STR_BUTTON_PREV = new String[]{"<<Prev", "<<Ant", "<<Precedente", "<<Vorherige"};
        STR_LANGUAGE = new String[]{"Language:", "Lengua:", "Lingua:", "Sprache:"};
        STR_ENGLISH = new String[]{"English", "Ingl\u00e9s", "Inglese", "Englisch"};
        STR_SPANISH = new String[]{"Spanish", "Espa\u00f1ol", "Spagnolo", "Spanisch"};
        STR_NOT_FOR_YOU = new String[]{"This offer is not for you!", "\u00a1Esta oferta no es para usted!", "Questa offerta non \u00e8 per voi!", "Dieses Angebot ist nicht f\u00fcr Sie!"};
        STR_ITALIAN = new String[]{"Italian", "Italiano", "Italiano", "Italienisch"};
        STR_GERMAN = new String[]{"German", "Aleman", "Tedesco", "Deustch"};
        STR_CREDITS = new String[]{"by Javier Mu\u00f1oz Kirschberg (aka Yaroslav), with translations of Markus Kraus von G\u00fcntner (aka Galvatron)", "por Javier Mu\u00f1oz Kirschberg (alias yaroslav), con traducciones de Markus Kraus von G\u00fcntner (alias Galvatron)", "da Javier Mu\u00f1oz Kirschberg (aka Yaroslav), traduzioni da Markus Kraus von G\u00fcntner (aka Galvatron)", "von Javier Mu\u00f1oz Kirschberg (aka Yaroslav), \u00dcbersetzungen von Markus Kraus von G\u00fcntner (aka Galvatron)"};
        INIT_STATE = 0;
        SELECTED_FILE = 1;
        SELECTED_CIV = 2;
        INTRO_PASSWORD = 3;
        RE_INTRO_PASSWORD = 4;
        MAKE_OFFER = 5;
        VIEW_OFFER = 6;
        SELECT_TRIBUTER_CIV = 7;
        NO_ACTION = 0;
        SET_PASSWORD_ACTION = 1;
        MAKE_BARTER_ACTION = 2;
        VIEW_BARTER_ACTION = 3;
    }
}

