/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;

public class Offer
implements Externalizable {
    private static final String IDENTIFIER_STRING = "CIV2-PBEM-DIPLOMACY";
    private static final int VERSION = 1;
    private static final int NONE = 0;
    private static final int PEACE = 1;
    private static final int CEASE_FIRE = 2;
    private static final int ALLIANCE = 3;
    private int goldDemmanderTributer = 0;
    private int goldDemmander = 0;
    private int goldTributerDemmander = 0;
    private int goldTributer = 0;
    private boolean peace = false;
    private boolean alliance = false;
    private boolean ceaseFire = false;
    private int turnGame;
    private int[] techDemmanderTributer = null;
    private int[] techTributerDemmander = null;
    private int civDemmander = 0;
    private int civTributer = 0;
    private byte[] signature = new byte[14];

    public int getCivDemmander() {
        return this.civDemmander;
    }

    public int getCivTributer() {
        return this.civTributer;
    }

    public int getGoldDemmanderTributer() {
        return this.goldDemmanderTributer;
    }

    public int getGoldTributerDemmander() {
        return this.goldTributerDemmander;
    }

    public int[] getTechDemmanderTributer() {
        return this.techDemmanderTributer;
    }

    public int[] getTechTributerDemmander() {
        return this.techTributerDemmander;
    }

    public int getTurnGame() {
        return this.turnGame;
    }

    public boolean getPeace() {
        return this.peace;
    }

    public boolean getAlliance() {
        return this.alliance;
    }

    public boolean getCeaseFire() {
        return this.ceaseFire;
    }

    public int getGoldDemmander() {
        return this.goldDemmander;
    }

    public int getGoldTributer() {
        return this.goldTributer;
    }

    public void setGoldDemmanderTributer(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldDemmanderTributer = gold;
    }

    public void setGoldTributerDemmander(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldTributerDemmander = gold;
    }

    public void setGoldDemmander(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldDemmander = gold;
    }

    public void setGoldTributer(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldTributer = gold;
    }

    public void setTurnGame(int turn) {
        if (turn < 0) {
            throw new AssertionError();
        }
        this.turnGame = turn;
    }

    public void setTechDemmanderTributer(int[] tech) {
        this.techDemmanderTributer = tech;
    }

    public void setTechTributerDemmander(int[] tech) {
        this.techTributerDemmander = tech;
    }

    public void setCivDemmander(int civ) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.civDemmander = civ;
    }

    public void setCivTributer(int civ) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.civTributer = civ;
    }

    public void setPeace() {
        this.alliance = false;
        this.ceaseFire = false;
        this.peace = true;
    }

    public void setAlliance() {
        this.alliance = true;
        this.ceaseFire = false;
        this.peace = false;
    }

    public void setCeaseFire() {
        this.alliance = false;
        this.ceaseFire = true;
        this.peace = false;
    }

    public void setSignature(byte[] sig) {
        this.signature = sig;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        String temp = (String)in.readObject();
        int version = (Integer)in.readObject();
        this.civDemmander = (Integer)in.readObject();
        this.civTributer = (Integer)in.readObject();
        this.turnGame = (Integer)in.readObject();
        this.goldDemmander = (Integer)in.readObject();
        this.goldTributer = (Integer)in.readObject();
        this.goldDemmanderTributer = (Integer)in.readObject();
        this.goldTributerDemmander = (Integer)in.readObject();
        int tempTeatry = (Integer)in.readObject();
        this.peace = false;
        this.alliance = false;
        this.ceaseFire = false;
        if (tempTeatry == 1) {
            this.peace = true;
        } else if (tempTeatry == 3) {
            this.alliance = true;
        } else if (tempTeatry == 2) {
            this.ceaseFire = true;
        }
        int tempLength = (Integer)in.readObject();
        if (tempLength > 0) {
            this.techDemmanderTributer = new int[tempLength];
            i = 0;
            while (i < tempLength) {
                this.techDemmanderTributer[i] = (Integer)in.readObject();
                ++i;
            }
        } else {
            this.techDemmanderTributer = null;
        }
        tempLength = (Integer)in.readObject();
        if (tempLength > 0) {
            this.techTributerDemmander = new int[tempLength];
            i = 0;
            while (i < tempLength) {
                this.techTributerDemmander[i] = (Integer)in.readObject();
                ++i;
            }
        } else {
            this.techTributerDemmander = null;
        }
        this.signature = new byte[14];
        i = 0;
        while (i < 14) {
            this.signature[i] = (Byte)in.readObject();
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(IDENTIFIER_STRING);
        out.writeObject(new Integer(1));
        out.writeObject(new Integer(this.civDemmander));
        out.writeObject(new Integer(this.civTributer));
        out.writeObject(new Integer(this.turnGame));
        out.writeObject(new Integer(this.goldDemmander));
        out.writeObject(new Integer(this.goldTributer));
        out.writeObject(new Integer(this.goldDemmanderTributer));
        out.writeObject(new Integer(this.goldTributerDemmander));
        if (this.peace) {
            out.writeObject(new Integer(1));
        } else if (this.alliance) {
            out.writeObject(new Integer(3));
        } else if (this.ceaseFire) {
            out.writeObject(new Integer(2));
        } else {
            out.writeObject(new Integer(0));
        }
        if (this.techDemmanderTributer != null) {
            out.writeObject(new Integer(this.techDemmanderTributer.length));
            i = 0;
            while (i < this.techDemmanderTributer.length) {
                out.writeObject(new Integer(this.techDemmanderTributer[i]));
                ++i;
            }
        } else {
            out.writeObject(new Integer(0));
        }
        if (this.techTributerDemmander != null) {
            out.writeObject(new Integer(this.techTributerDemmander.length));
            i = 0;
            while (i < this.techTributerDemmander.length) {
                out.writeObject(new Integer(this.techTributerDemmander[i]));
                ++i;
            }
        } else {
            out.writeObject(new Integer(0));
        }
        i = 0;
        while (i < 14) {
            out.writeObject(new Byte(this.signature[i]));
            ++i;
        }
    }

    public static void main(String[] args) {
        System.exit(0);
        System.out.println("Standard test for Civ2 PBEM Diplomacy-Offer");
        System.out.println("Made by Javier Mu\u00f1oz Kirschberg - M\u00e1laga 2002");
        System.out.println("Please enter the full path of the file to open:");
        Offer o = new Offer();
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            int i;
            String name = input.readLine();
            File file = new File(name);
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(file));
            o.readExternal(p);
            System.out.println("Civ Demmander " + o.getCivDemmander());
            System.out.println("Civ Tributer " + o.getCivTributer());
            System.out.println("Gold Civ Demmander " + o.getGoldDemmander());
            System.out.println("Gold Civ Tributer " + o.getGoldTributer());
            System.out.println("Gold Civ Demmander->Tributer " + o.getGoldDemmanderTributer());
            System.out.println("Gold Civ Tributer->Demmander " + o.getGoldTributerDemmander());
            if (o.getTechDemmanderTributer() != null) {
                i = 0;
                while (i < o.getTechDemmanderTributer().length) {
                    System.out.println("Tech Demmander->Tributer " + o.getTechDemmanderTributer()[i]);
                    ++i;
                }
            }
            if (o.getTechTributerDemmander() != null) {
                i = 0;
                while (i < o.getTechTributerDemmander().length) {
                    System.out.println("Tech Tributer->Demmander " + o.getTechTributerDemmander()[i]);
                    ++i;
                }
            }
            if (o.getPeace()) {
                System.out.println("Peace Offer ");
            } else if (o.getAlliance()) {
                System.out.println("Alliance Offer ");
            } else if (o.getCeaseFire()) {
                System.out.println("Cease Fire ");
            }
        }
        catch (NullPointerException e) {
            System.out.println("Incorrect FileName");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class Not Found Exception");
        }
        catch (IOException e) {
            System.out.println("Error while reading file name");
        }
    }

    static {
        IDENTIFIER_STRING = IDENTIFIER_STRING;
        VERSION = 1;
        NONE = 0;
        PEACE = 1;
        CEASE_FIRE = 2;
        ALLIANCE = 3;
    }
}

