## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005

## Europe Screen Release 4
## by Koma13 (Dec 2008)

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import CvScreenEnums
import sys
import cPickle as pickle
		
# globals
gc = CyGlobalContext()
CyGameInstance = gc.getGame()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()


class CvEuropeScreen:

	def __init__(self):
						
		self.WIDGET_ID = "EuropeScreenWidget"
		self.nWidgetCount = 0
						
		self.UNIT_BUTTON_ID = 1
		self.UNIT_CARGO_BUTTON_ID = 2
		self.BUY_YIELD_BUTTON_ID = 3
		self.YIELD_CARGO_BUTTON_ID = 4
		self.BUY_UNIT_BUTTON_ID = 5
		self.DOCK_BUTTON_ID = 6
		self.SAIL_TO_NEW_WORLD = 7
		self.SELL_ALL = 8
		self.LOAD_ALL = 9
		self.HELP_CROSS_RATE = 10
		self.TREASURY_ID = 11
		self.BOUND = 12
		self.TRADE = 13
		self.SAIL_WEST = 14
		
	def getScreen(self):
		return CyGInterfaceScreen("EuropeScreen", CvScreenEnums.EUROPE_SCREEN)

	def interfaceScreen(self):
			
		if ( CyGame().isPitbossHost() ):
			return

		if gc.getPlayer(gc.getGame().getActivePlayer()).getParent() == PlayerTypes.NO_PLAYER:
			return
	
		screen = self.getScreen()
		if screen.isActive():
			return

		player = gc.getPlayer(gc.getGame().getActivePlayer())
		self.Pirates = gc.getPlayer(gc.getGame().getActivePlayer()).isPirates()
		
		self.CREDITS = localText.getText("[COLOR_YELLOW]Europe Screen[COLOR_REVERT] (Release [COLOR_HIGHLIGHT_TEXT]4.1[COLOR_REVERT] AOD2)[NEWLINE]", ((),""))
		self.CREDITS += localText.getText("by [COLOR_YELLOW]koma13[COLOR_REVERT], [COLOR_YELLOW]Fankman[COLOR_REVERT] and [COLOR_YELLOW]Dale[COLOR_REVERT]", ((),""))
		
		# Europe Screen Configuration
		#
		# Winter: 0 - Winter screen disabled ; 1 - enabled
		# WinterInt: minimum interval (in turns) between 2 winter screens (default: 9)
		# Recruits3D: 0 - old 2D Icons; 1 - new 3D models for recruits
		# InBound3D: 0 - old 2D Icons; 1 - new 3D models for inbound ships
		# Audio: 0 - additional sfx disabled; 1 - enabled
		# TopBar: 0 - top bar always disabled; 1 - enabled in winter; 2 - always enabled  (default: 0)
		#
		# Don't change TradeBox, MultiLang, LastWinter and ThisWinter! There are for internal use!
		
		if (self.Pirates):
			if (not sdEntityExists( 'komaScreens', player.getName())):
				sdEntityInit('komaScreens', player.getName(), {'Winter': 0, 'WinterInt': 9, 'Recruits3D': 1, 'InBound3D': 0, 'Audio': 1, 'TopBar': 0, 'TradeBox': 0, 'MultiLang': 0 , 'ThisWinter': 0, 'LastWinter': 0})
		else:
			if (not sdEntityExists( 'komaScreens', player.getName())):
				sdEntityInit('komaScreens', player.getName(), {'Winter': 1, 'WinterInt': 9, 'Recruits3D': 1, 'InBound3D': 0, 'Audio': 1, 'TopBar': 0, 'TradeBox': 0, 'MultiLang': 0 , 'ThisWinter': 0, 'LastWinter': 0})

		screen.setRenderInterfaceOnly(True)
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)

		self.XResolution = screen.getXResolution()
		self.YResolution = screen.getYResolution()

		self.Y_EXIT = self.YResolution - 36
		self.X_EXIT = self.XResolution - 30

		self.Y_RATES = self.YResolution * 29 / 32 + 5
		
		self.IN_PORT_PANE_WIDTH = self.XResolution * 9 / 20
		self.X_IN_PORT = self.XResolution * 3 / 10
		self.PANE_HEIGHT = (self.YResolution - 55) * 31 / 40
		self.X_DOCK = self.XResolution * 7 / 10

		self.SHIP_ICON_SIZE = self.YResolution / 10
		self.CARGO_ICON_SIZE = self.XResolution / 25
		self.CARGO_SPACING  = self.CARGO_ICON_SIZE + 2

		self.H_TEXT_MARGIN = self.YResolution / 30
		self.W_TEXT_MARGIN = self.XResolution / 30

		self.X_RECRUIT_PANE = self.X_IN_PORT + self.IN_PORT_PANE_WIDTH + (self.W_TEXT_MARGIN / 2)
		self.PANE_WIDTH = self.XResolution * 7 / 20
		self.W_SLIDER = self.PANE_WIDTH - (self.W_TEXT_MARGIN * 2)
		self.H_LOADING_SLIDER = self.YResolution * 7 / 10
		self.Y_UPPER_EDGE = self.YResolution / 10
		self.RECRUIT_PANE_HEIGHT = self.YResolution / 7

		self.Y_RECRUIT_OFFSET = 25
		self.Y_TITLE = 4
		self.Y_BOUND = self.Y_UPPER_EDGE + (self.PANE_HEIGHT / 2)
		self.Y_DOCKS_OFFSET = 50
		self.H_DOCK = (self.PANE_HEIGHT - (self.H_TEXT_MARGIN * 2)) * 35 / 100
		
		posY = self.YResolution - self.YResolution * 4 / 23 - self.YResolution * 44 / 96
		self.EuropeUnitsListBackup = []
		self.OutboundUnitsListBackup = []
				
		# Set the background and exit button, and show the screen
		screen.setDimensions(0, 0, self.XResolution, self.YResolution)
		screen.showWindowBackground(False)
		
		#screen.addDDSGFC("EuropeScreenColor", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_OUT_BOUND_BOX").getPath(), 0, 0, self.XResolution, self.YResolution, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		if (self.Pirates):
			screen.addDDSGFC("EuropeScreenBackground", ArtFileMgr.getInterfaceArtInfo("INTERFACE_PIRATE_BACKGROUND").getPath(), 0, 0, self.XResolution, self.YResolution, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		else:
			screen.addDDSGFC("EuropeScreenBackground", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_BACKGROUND").getPath(), 0, 0, self.XResolution, self.YResolution, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		# Winter
		if (sdGetVal('komaScreens', player.getName(), 'Winter') == 1):
			currentTurn = CyGame().getGameTurn()
			dateString = CyGameTextMgr().getTimeStr(currentTurn, true)
			winterInt = sdGetVal('komaScreens', player.getName(), 'WinterInt')
			
			January = localText.getText("TXT_KEY_MONTH_JANUARY", ())
			February = localText.getText("TXT_KEY_MONTH_FEBRUARY", ())
			December = localText.getText("TXT_KEY_MONTH_DECEMBER", ())
						
			if (gc.getGameSpeedInfo(gc.getGame().getGameSpeedType()).getGameTurnInfo(0).iMonthIncrement != 12):
				if (January in dateString or February in dateString or December in dateString):
					LastWinterDiff = currentTurn - sdGetVal('komaScreens', player.getName(), 'LastWinter')
								
					if (LastWinterDiff >= sdGetVal('komaScreens', player.getName(), 'WinterInt') or LastWinterDiff == 0) and (currentTurn != 0):
						sdSetVal('komaScreens', player.getName(), 'ThisWinter', 1)
						sdSetVal('komaScreens', player.getName(), 'LastWinter', currentTurn)
				else:
					sdSetVal('komaScreens', player.getName(), 'ThisWinter', 0)
			elif (currentTurn % winterInt == 0) and (currentTurn != 0):
				sdSetVal('komaScreens', player.getName(), 'ThisWinter', 1)
			else:
				sdSetVal('komaScreens', player.getName(), 'ThisWinter', 0)
		
			if (sdGetVal('komaScreens', player.getName(), 'ThisWinter') == 1):
				#screen.addDDSGFC("EuropeScreenBackgroundWinter", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_IN_BOUND_BOX").getPath(), 0, 0, self.XResolution, self.YResolution, WidgetTypes.WIDGET_GENERAL, -1, -1 )
				screen.changeDDSGFC ("EuropeScreenBackground", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_IN_BOUND_BOX").getPath())
				
		#screen.enableWorldSounds(false)
		self.unitsSound = 0
						
		#TopBar (Shadow)
		topBarY = 70 + ((self.YResolution - 768) / 40)
		
		if (sdGetVal('komaScreens', player.getName(), 'TopBar') == 2):
			screen.addDDSGFC("TopBar", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SHADOW_BOX").getPath(), -150, -20, self.XResolution + 300, topBarY, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		if (sdGetVal('komaScreens', player.getName(), 'TopBar') == 1) and (sdGetVal('komaScreens', player.getName(), 'ThisWinter') == 1):
			screen.addDDSGFC("TopBar", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SHADOW_BOX").getPath(), -150, -20, self.XResolution + 300, topBarY, WidgetTypes.WIDGET_GENERAL, -1, -1 )
			#screen.moveBackward("TopBar")
			
		# InBound
		if (self.Pirates):
			screen.addScrollPanel("InBoundList", u"", self.W_TEXT_MARGIN / 2, self.YResolution * 67 / 160, self.W_SLIDER * 3 / 2, self.YResolution / 14, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		else:
			screen.addScrollPanel("InBoundList", u"", self.W_TEXT_MARGIN / 2, self.YResolution * 61 / 320, self.W_SLIDER * 3 / 2, self.YResolution / 14, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		# OutBound
		if (self.Pirates):
			screen.addScrollPanel("OutBoundList", u"", self.W_TEXT_MARGIN / 4, self.YResolution / 3 + 100, self.W_SLIDER * 2, self.SHIP_ICON_SIZE * 3 + 20, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_SAIL, UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE, -1 )
		else:
			screen.addScrollPanel("OutBoundList", u"", self.W_TEXT_MARGIN / 4, self.YResolution * 9 / 40, self.W_SLIDER * 2, self.SHIP_ICON_SIZE * 3 + 20, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_SAIL, UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE, -1 )

		# In Port
		if (self.Pirates):
			screen.addScrollPanel("LoadingList", u"", -5, posY + 50, self.XResolution + 10, self.YResolution - posY - 23, PanelStyles.PANEL_STYLE_MAIN, True, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		else:
			screen.addScrollPanel("LoadingList", u"", -5, posY, self.XResolution + 10, self.YResolution - posY - 23, PanelStyles.PANEL_STYLE_MAIN, True, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		# Recruit
		#screen.addScrollPanel("RecruitList", u"", self.XResolution - self.XResolution / 6, self.YResolution - self.YResolution / 5 - 5, self.RECRUIT_PANE_HEIGHT * 7 / 5, self.RECRUIT_PANE_HEIGHT, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
		if (self.Pirates):
			screen.addScrollPanel("RecruitList", u"", self.XResolution - self.XResolution / 4 + 25, self.YResolution / 2 - self.CARGO_ICON_SIZE * 2 + 30, self.RECRUIT_PANE_HEIGHT * 7 / 5, self.RECRUIT_PANE_HEIGHT, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
		else:
			screen.addScrollPanel("RecruitList", u"", self.XResolution * 47 / 56, self.YResolution - self.YResolution / 5 - 5, self.X_RECRUIT_PANE / 5, self.RECRUIT_PANE_HEIGHT, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
		
		# Dock
		#screen.addScrollPanel("DockList", u"", self.X_IN_PORT + self.IN_PORT_PANE_WIDTH * 17 / 24, self.YResolution * 2 / 5 - self.CARGO_ICON_SIZE * 2, self.XResolution * 2 / 7, self.CARGO_ICON_SIZE * 5 / 2, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
		if (self.Pirates):
			screen.addScrollPanel("DockList", u"", self.X_IN_PORT - self.CARGO_ICON_SIZE * 2, self.YResolution / 2 - self.CARGO_ICON_SIZE * 2, self.XResolution * 2 / 7, self.CARGO_ICON_SIZE * 5 / 2, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
		else:
			screen.addScrollPanel("DockList", u"", self.X_IN_PORT + self.IN_PORT_PANE_WIDTH * 35 / 48, self.YResolution * 2 / 5 - self.CARGO_ICON_SIZE * 2, self.XResolution * 2 / 7, self.CARGO_ICON_SIZE * 5 / 2, PanelStyles.PANEL_STYLE_MAIN, false, WidgetTypes.WIDGET_DOCK, -1, -1 )
			
		# Messages
		screen.setImageButton("TradeButton", ArtFileMgr.getInterfaceArtInfo("INTERFACE_GENERAL_TURNLOG_ICON").getPath(), self.W_TEXT_MARGIN / 5, self.YResolution - 17 - self.CARGO_ICON_SIZE * 3 / 4 - (self.YResolution * 2 / 23 * 6 / 7) / 2, self.CARGO_ICON_SIZE * 3 / 2, self.CARGO_ICON_SIZE * 3 / 2, WidgetTypes.WIDGET_GENERAL, self.TRADE, -1)
		
		# Purchase
		if (gc.getPlayer(gc.getGame().getActivePlayer()).canTradeWithEurope()):
			screen.setImageButton("HireButton", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_PURCHASE_UNIT").getPath(), self.XResolution - self.CARGO_ICON_SIZE * 3 / 2 - self.W_TEXT_MARGIN / 5, self.YResolution - 17 - self.CARGO_ICON_SIZE * 3 / 4 - (self.YResolution * 2 / 23 * 6 / 7) / 2, self.CARGO_ICON_SIZE * 3 / 2,self.CARGO_ICON_SIZE * 3 / 2, WidgetTypes.WIDGET_GENERAL, self.BUY_UNIT_BUTTON_ID, -1)
		
		#Water Animation
		screen.addUnitGraphicGFC("WaterAnim_Widget", 31, -1, 0, 0,self.XResolution,self.XResolution, WidgetTypes.WIDGET_UNIT_MODEL, -1, -1, 0, 0, 0, true)			
		screen.moveToBack("WaterAnim_Widget")
		
		# draw the contents
		self.drawContents()
		
		
	def drawContents(self):
		
		player = gc.getPlayer(gc.getGame().getActivePlayer())
		playerEurope = gc.getPlayer(player.getParent())
		
		#print playerEurope
		#print playerEurope.getNameKey()
		
		self.deleteAllWidgets()

		screen = self.getScreen()
				
		#CyGame().setCurrentLanguage(0)		
		if (CyGame().getCurrentLanguage() != 0):
			sdSetVal('komaScreens', player.getName(), 'MultiLang', 1)
			
		HudColor = "[COLOR_WHITE]"
				
		if (sdGetVal('komaScreens', player.getName(), 'ThisWinter') == 1):
			HudColor = "[COLOR_WHITE]"
		
		screen.setText(self.getNextWidgetName(), "Background", u"<font=4>" + localText.getText(HudColor, ()) + localText.getText("TXT_KEY_FINANCIAL_ADVISOR_TREASURY", (player.getGold(), )).upper() + u"</font>", CvUtil.FONT_LEFT_JUSTIFY, self.W_TEXT_MARGIN / 2, self.Y_TITLE + self.YResolution / 60, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, self.TREASURY_ID, -1 )
		
		if (sdGetVal('komaScreens', player.getName(), 'MultiLang') == 0):
			screen.setText(self.getNextWidgetName(), "Background", u"<font=4>" + localText.getText(HudColor, ()) + localText.getText("TXT_KEY_MISC_TAX_RATE", (player.getTaxRate(), )).upper() + u"</font>", CvUtil.FONT_RIGHT_JUSTIFY, self.XResolution - self.W_TEXT_MARGIN / 2 - self.CARGO_ICON_SIZE * 3 / 2 - 15, self.Y_TITLE + self.YResolution / 60, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		else:
			screen.setText(self.getNextWidgetName(), "Background", u"<font=4>" + localText.getText(HudColor, ()) + localText.getText("TXT_KEY_MISC_TAX_RATE", (player.getTaxRate(), )).upper() + u"</font>", CvUtil.FONT_RIGHT_JUSTIFY, self.XResolution * 6 / 7 + self.W_TEXT_MARGIN / 2  - self.CARGO_ICON_SIZE * 2 / 3, self.Y_TITLE + self.YResolution / 60, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		
		# Exit
		screen.setText("EuropeScreenExitWidget", "Background", u"<font=4>" + localText.getText(HudColor, ()) + localText.getText("TXT_KEY_PEDIA_SCREEN_EXIT", ()).upper() + "</font>", CvUtil.FONT_RIGHT_JUSTIFY, self.X_EXIT + self.XResolution / 75 - 15, self.Y_TITLE + self.YResolution / 60, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1 )
		
		#Sound
		if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
			unitsVolume = 0.08 * player.getNumEuropeUnits()
			
			if (unitsVolume >= 1.0):
				unitsVolume = 1.0
						
			if (sdGetVal('komaScreens', player.getName(), 'ThisWinter') == 0):
				if (self.unitsSound != 0):
					CyAudioGame().Destroy2DSound(self.unitsSound)
				
				if (unitsVolume >= 0.56):
					screen.setSoundId(self.playSoundID("AS2D_SS_CITY_MIDDLE_SMALL_BED"))
				else:
					screen.setSoundId(self.playSoundID("AS2D_SS_COASTLOOP"))
					unitsVolume = 0.70
			
				CyAudioGame().Set2DSoundVolume(self.unitsSound, unitsVolume)
					
			else:
				if (self.unitsSound != 0):
					CyAudioGame().Destroy2DSound(self.unitsSound)
				
				screen.setSoundId(self.playSoundID("AS2D_SS_TUNDRALOOP"))

				
		# Trade Messages
		if (sdGetVal('komaScreens', player.getName(), 'TradeBox') == 0):
			screen.hide("MessageList")
			screen.hide("EuropeScreenMessageImage")
		else:
			screen.addDDSGFC("EuropeScreenMessageImage", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SHADOW_BOX").getPath(), self.W_TEXT_MARGIN / 5, self.YResolution - self.YResolution / 3 - 7, self.XResolution / 5 + self.W_TEXT_MARGIN / 2 + 10, self.YResolution / 4 - 7, WidgetTypes.WIDGET_GENERAL, -1, -1 )
			screen.addListBoxGFC("MessageList", "", self.W_TEXT_MARGIN / 2, self.YResolution - self.YResolution / 3 + self.W_TEXT_MARGIN / 5 - 7, self.XResolution / 5 + 10, self.YResolution / 4 - self.W_TEXT_MARGIN / 2 - 7, TableStyles.TABLE_STYLE_EMPTY)
			screen.enableSelect("MessageList", False)
			screen.moveToBack("MessageList")
			screen.moveToBack("EuropeScreenMessageImage")
			for i in range(5):
				screen.moveForward("MessageList")
				screen.moveForward("EuropeScreenMessageImage")
		

		# UnitsList handling
		EuropeUnitsList = []
		InboundUnitsList = []
		OutboundUnitsList = []
		(unit, iter) = player.firstUnit()
		while (unit):
			if (not unit.isCargo() and not unit.isDelayedDeath()):
				if (unit.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_IN_EUROPE):
					EuropeUnitsList.append(unit)
					diff_list = []
					for unit_backup in self.EuropeUnitsListBackup:
						diff_list.append(unit_backup.getID())
					if (not unit.getID() in diff_list):
						self.EuropeUnitsListBackup.append(unit)
				
				elif (unit.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_TO_EUROPE):
					InboundUnitsList.append(unit)

				if (unit.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE):
					OutboundUnitsList.append(unit)
					diff_outbound = []
					for unit_outbound in self.OutboundUnitsListBackup:
						diff_outbound.append(unit_outbound.getID())
					if (not unit.getID() in diff_outbound):
						self.OutboundUnitsListBackup.append(unit)
			
			(unit, iter) = player.nextUnit(iter)
		
		remove_list = []
		
		for unit in EuropeUnitsList:
			remove_list.append(unit.getID())
		
		for unit_backup in self.EuropeUnitsListBackup:
			if (not unit_backup.getID() in remove_list):
				self.EuropeUnitsListBackup.remove(unit_backup)
		
				
		EuropeUnitsList = self.EuropeUnitsListBackup		
		OutboundUnitsList = self.OutboundUnitsListBackup
		
		# Units
		ShipPanelWidth = self.IN_PORT_PANE_WIDTH - (self.W_TEXT_MARGIN * 3)			
		ShipPanelHight = self.YResolution / 10
		if (ShipPanelHight < 90):
			ShipPanelHight = 90
		xLocation_InPort = self.XResolution / 2 - self.SHIP_ICON_SIZE * 11 / 8
		yLocation_InPort = 0
		yLocation_ToEurope = 0
		yLocation_FromEurope = 0
		yCenterCorrection = (self.SHIP_ICON_SIZE / 2) - (self.CARGO_ICON_SIZE / 2)
		
		#In_Port Units
		for unit in EuropeUnitsList:
			screen.addDragableButtonAt("LoadingList", self.getNextWidgetName(), unit.getFullLengthIcon(), "", xLocation_InPort, yLocation_InPort, self.SHIP_ICON_SIZE * 14 / 4, self.SHIP_ICON_SIZE * 24 / 4, WidgetTypes.WIDGET_SHIP_CARGO, unit.getID(), -1, ButtonStyles.BUTTON_STYLE_LABEL)
			box_count = 0
					
			for l in range(unit.cargoSpace()):
				box_count += 1
			
			for i in range(unit.cargoSpace()):
				screen.addDDSGFCAt(self.getNextWidgetName(), "LoadingList", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_BOX_CARGO").getPath(), xLocation_InPort + ((self.SHIP_ICON_SIZE * 15 / 4) / 2) - ((self.CARGO_SPACING * box_count) / 2) + (self.CARGO_SPACING * i) , self.SHIP_ICON_SIZE * 29 / 8, self.CARGO_ICON_SIZE, self.CARGO_ICON_SIZE, WidgetTypes.WIDGET_SHIP_CARGO, unit.getID(), -1, False)

			YieldOnBoard = False
			iCargoCount = 0
			plot = unit.plot()
			for i in range(plot.getNumUnits()):
				loopUnit = plot.getUnit(i)
				transportUnit = loopUnit.getTransportUnit()
				if (not transportUnit.isNone() and transportUnit.getID() == unit.getID() and transportUnit.getOwner() == unit.getOwner()):
					if loopUnit.isGoods():
						szText = u"<font=2>%s</font>" % loopUnit.getYieldStored()
						iWidgetId = self.YIELD_CARGO_BUTTON_ID
						YieldOnBoard = True
					else:
						szText = ""
						iWidgetId = self.UNIT_CARGO_BUTTON_ID

					screen.addDragableButtonAt("LoadingList", self.getNextWidgetName(), loopUnit.getButton(), "", xLocation_InPort + ((self.SHIP_ICON_SIZE * 15 / 4) / 2) - ((self.CARGO_SPACING * box_count) / 2) + (self.CARGO_SPACING * iCargoCount) , self.SHIP_ICON_SIZE * 29 / 8, self.CARGO_ICON_SIZE, self.CARGO_ICON_SIZE, WidgetTypes.WIDGET_SHIP_CARGO, loopUnit.getID(), transportUnit.getID(), ButtonStyles.BUTTON_STYLE_LABEL)
					iCargoCount = iCargoCount + 1

			if (YieldOnBoard):
				screen.setImageButtonAt(self.getNextWidgetName(), "LoadingList", gc.getActionInfo(gc.getInfoTypeForString("COMMAND_YIELD_TRADE")).getButton(), xLocation_InPort + self.SHIP_ICON_SIZE * 13 / 4 - self.CARGO_ICON_SIZE * 5 / 4, yLocation_InPort +  self.SHIP_ICON_SIZE * 22 / 8, self.CARGO_ICON_SIZE * 5 / 4, self.CARGO_ICON_SIZE * 5 / 4, WidgetTypes.WIDGET_GENERAL, self.SELL_ALL, unit.getID())
						
			if (not unit.isFull() and player.getNumEuropeUnits() > 0 and not unit.getNameKey() == "TXT_KEY_UNIT_PRIVATEER"):
				screen.setImageButtonAt(self.getNextWidgetName(), "LoadingList", gc.getActionInfo(gc.getInfoTypeForString("COMMAND_LOAD")).getButton(), xLocation_InPort + self.SHIP_ICON_SIZE * 13 / 4 - self.CARGO_ICON_SIZE * 34 / 16, yLocation_InPort +  self.SHIP_ICON_SIZE * 22 / 8, self.CARGO_ICON_SIZE * 5 / 4, self.CARGO_ICON_SIZE * 5 / 4, WidgetTypes.WIDGET_GENERAL, self.LOAD_ALL, unit.getID())

			#screen.setImageButtonAt(self.getNextWidgetName(), "LoadingList", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SAIL").getPath(), xLocation_InPort + self.SHIP_ICON_SIZE * 2 / 4, yLocation_InPort +  self.SHIP_ICON_SIZE * 22 / 8, self.CARGO_ICON_SIZE * 5 / 4, self.CARGO_ICON_SIZE * 5 / 4, WidgetTypes.WIDGET_GENERAL, self.SAIL_TO_NEW_WORLD, unit.getID())
			
			if (unit.canSailWest()):
				screen.setImageButtonAt(self.getNextWidgetName(), "LoadingList", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SAIL_WEST").getPath(), xLocation_InPort + self.SHIP_ICON_SIZE * 2 / 4, yLocation_InPort +  self.SHIP_ICON_SIZE * 22 / 8, self.CARGO_ICON_SIZE * 5 / 4, self.CARGO_ICON_SIZE * 5 / 4, WidgetTypes.WIDGET_GENERAL, self.SAIL_WEST, unit.getID())
			if (unit.canSailEast()):
				screen.setImageButtonAt(self.getNextWidgetName(), "LoadingList", ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SAIL_EAST").getPath(), xLocation_InPort + self.SHIP_ICON_SIZE * 2 / 4 + self.CARGO_ICON_SIZE * 6 / 7, yLocation_InPort +  self.SHIP_ICON_SIZE * 22 / 8, self.CARGO_ICON_SIZE * 5 / 4, self.CARGO_ICON_SIZE * 5 / 4, WidgetTypes.WIDGET_GENERAL, self.SAIL_TO_NEW_WORLD, unit.getID())
			
			
			xLocation_InPort += self.XResolution * 4 / 13
				
		#Inbound Units
		ShipPanelHight = self.YResolution / 12
		xLocation_ToEurope = 0
		
		ibWidth = 1
		self.InBoundCargoList = []
		
		for b in InboundUnitsList:
			ibWidth += 1
			
		for unit in InboundUnitsList:
			#travel_timer_base = gc.getPlayer(gc.getGame().getActivePlayer()).getUnit(unit.getID()).getUnitTravelTimer()
			#print travel_timer_base
			
			if (sdGetVal('komaScreens', player.getName(), 'InBound3D') == 1):
				Inbound3DScale = 0.25 + ((self.YResolution - 768.0) / 900.0)
				Inbound3DySize = 135 - ((self.YResolution - 768) / 10)
				if (self.Pirates):
					Inbound3DyPos = self.YResolution / 3 + 110 - Inbound3DySize
				else:
					Inbound3DyPos = self.YResolution * 41 / 168 - Inbound3DySize - ((self.YResolution - 768) / 30)
			
				if (unit.getNameKey() == "TXT_KEY_UNIT_CARAVEL"):
					Inbound3DScale -= 0.05
			
				InBoundUnitWidget = self.getNextWidgetName()
				screen.addUnitGraphicGFC( InBoundUnitWidget, unit.getUnitType(), -1, xLocation_ToEurope, Inbound3DyPos, self.XResolution / 10, Inbound3DySize, WidgetTypes.WIDGET_GENERAL, -1, -1, 0, 0, Inbound3DScale, false)			
				screen.moveToBack(InBoundUnitWidget)
				screen.moveForward(InBoundUnitWidget)
				screen.moveForward(InBoundUnitWidget)
				screen.moveForward(InBoundUnitWidget)
				
				#if (sdGetVal('komaScreens', player.getName(), 'ThisWinter') == 1):
				#	screen.moveForward(InBoundUnitWidget)

				screen.addDDSGFCAt(self.getNextWidgetName(), "InBoundList", "", xLocation_ToEurope + self.XResolution / 55, yLocation_ToEurope, 12 * self.SHIP_ICON_SIZE / 40, 21 * self.SHIP_ICON_SIZE / 40, WidgetTypes.WIDGET_GENERAL, self.BOUND, unit.getID(), False)
				
			else:
				screen.addDDSGFCAt(self.getNextWidgetName(), "InBoundList", unit.getFullLengthIcon(), xLocation_ToEurope + self.XResolution / 55, yLocation_ToEurope, 12 * self.SHIP_ICON_SIZE / 40, 21 * self.SHIP_ICON_SIZE / 40, WidgetTypes.WIDGET_GENERAL, self.BOUND, unit.getID(), False)
			
			xLocation_ToEurope += (self.SHIP_ICON_SIZE * 4 / ibWidth) * 4 / 3
			iCargoCount = 0
			plot = unit.plot()
			
			for i in range(plot.getNumUnits()):
				loopUnit = plot.getUnit(i)
				transportUnit = loopUnit.getTransportUnit()
				
				if (loopUnit.isCargo()):
					if (not transportUnit.isNone() and transportUnit.getID() == unit.getID() and transportUnit.getOwner() == unit.getOwner()):
						self.InBoundCargoList.append(loopUnit)
						iCargoCount += 1
		
		#Outbound Units
		obWidth = 0
		
		for a in OutboundUnitsList:
			obWidth += 1
				
		if (obWidth < 5): 
			obWidth = 5
		
		obCount = 0
		obSHIP_ICON_SIZE = self.YResolution / 10
		xLocation_FromEurope = 0
		xLocation_Space = 2 * ShipPanelHight / obWidth * 4
		self.OutBoundCargoList = []
		
		for unit in OutboundUnitsList:
			obCount += 1
						
			if (obCount%2 == 0):
				xLocation_FromEurope += xLocation_Space / 2
				yLocation_FromEurope = obSHIP_ICON_SIZE * 3 / 5
				obSHIP_ICON_SIZE += 25
				
			if (obCount%2 != 0) and (obCount != 1):
				xLocation_FromEurope += xLocation_Space / 3
				yLocation_FromEurope = 0
				obSHIP_ICON_SIZE -= 25
						
			iCargoCount = 0
			plot = unit.plot()
			
			for i in range(plot.getNumUnits()):
				loopUnit = plot.getUnit(i)
				transportUnit = loopUnit.getTransportUnit()
				if (loopUnit.isCargo()):
					if (not transportUnit.isNone() and transportUnit.getID() == unit.getID() and transportUnit.getOwner() == unit.getOwner()):
						self.OutBoundCargoList.append(loopUnit)
						#screen.setImageButtonAt( self.getNextWidgetName(), "OutBoundList", loopUnit.getButton(), self.W_SLIDER - (self.W_TEXT_MARGIN * 2) - ((self.CARGO_SPACING / 2) * iCargoCount), yLocation_FromEurope + (self.SHIP_ICON_SIZE / 3) + (self.SHIP_ICON_SIZE / 2) - (self.CARGO_ICON_SIZE / 4), self.CARGO_ICON_SIZE / 2, self.CARGO_ICON_SIZE / 2, WidgetTypes.WIDGET_GENERAL, -1, -1)
						iCargoCount += 1
			
			OutBoundIcons = self.getNextWidgetName()
			screen.addDDSGFCAt(OutBoundIcons, "OutBoundList", unit.getFullLengthIcon(), xLocation_FromEurope * 7 / 4, yLocation_FromEurope, obSHIP_ICON_SIZE * 5 / 4, obSHIP_ICON_SIZE * 8 / 4, WidgetTypes.WIDGET_GENERAL, self.BOUND, unit.getID(), False)
			if (yLocation_FromEurope == 0):
				screen.moveBackward(OutBoundIcons)
				
		# Units waiting on Docks
		XLocation = 0
		YLocation = 0
		unit_count = 0
		
		for u in range(player.getNumEuropeUnits()):
			unit_count += 1
		
		if (unit_count < 5):
			unit_count = 5
		
		for i in range(player.getNumEuropeUnits()):
			loopUnit = player.getEuropeUnit(i)
			UnitPosX = XLocation
			UnitPosY = YLocation
			UnitIconSizeX = self.CARGO_ICON_SIZE
			UnitIconSizeY = self.CARGO_ICON_SIZE * 2
			
			if (loopUnit.getNameKey() == "TXT_KEY_UNIT_CRIMINAL"):
				UnitPosY = YLocation - 5
				UnitIconSizeX = self.CARGO_ICON_SIZE * 11 / 10
				UnitIconSizeY = self.CARGO_ICON_SIZE * 22 / 10
			if (loopUnit.getNameKey() == "TXT_KEY_UNIT_VETERAN"):
				UnitPosY = YLocation - 5
				UnitIconSizeX = self.CARGO_ICON_SIZE * 13 / 10
				UnitIconSizeY = self.CARGO_ICON_SIZE * 23 / 10
			if (loopUnit.getNameKey() == "TXT_KEY_UNIT_FARMER"):
				UnitPosY = YLocation - 6
				UnitIconSizeX = self.CARGO_ICON_SIZE * 12 / 11
				UnitIconSizeY = self.CARGO_ICON_SIZE * 24 / 11
			if (loopUnit.getNameKey() == "TXT_KEY_UNIT_CANNON"):
				UnitPosY = YLocation + 5
				UnitIconSizeX = self.CARGO_ICON_SIZE * 13 / 10
				UnitIconSizeY = self.CARGO_ICON_SIZE * 26 / 10
			if (loopUnit.getProfession() == 24) and not (loopUnit.getNameKey() == "TXT_KEY_UNIT_VETERAN"):
				UnitPosY = YLocation - 12
				UnitIconSizeX = self.CARGO_ICON_SIZE * 12 / 10
				UnitIconSizeY = self.CARGO_ICON_SIZE * 22 / 10
			if (loopUnit.getNameKey() == "TXT_KEY_UNIT_STATESMAN"):
				UnitPosY = YLocation + 5
				UnitIconSizeX = self.CARGO_ICON_SIZE * 18 / 20
				UnitIconSizeY = self.CARGO_ICON_SIZE * 19 / 10
				
			screen.addDragableButtonAt("DockList", self.getNextWidgetName(), loopUnit.getFullLengthIcon(), "", UnitPosX, UnitPosY, UnitIconSizeX, UnitIconSizeY, WidgetTypes.WIDGET_DOCK, loopUnit.getID(), -1, ButtonStyles.BUTTON_STYLE_LABEL )
			XLocation += (self.CARGO_ICON_SIZE * 6 / unit_count)
			
		# Units to Recruit
		RecruitPaneWidth = self.XResolution - self.X_RECRUIT_PANE
		
		for i in range (gc.getDefineINT("DOCKS_NEXT_UNITS")):
			UnitPosX = i * self.X_RECRUIT_PANE * 1 / 21
			UnitPosY = 0
			UnitIconSizeX = self.RECRUIT_PANE_HEIGHT * 1 / 3
			UnitIconSizeY = self.RECRUIT_PANE_HEIGHT * 2 / 3
					
			Unit3DScale = 1.0
			Unit3DySize = 100 + ((self.YResolution - 768) / 11)
			Unit3DxPos = self.XResolution * 91 / 112 
			
			if (self.Pirates):
				Unit3DxPos = self.XResolution - self.XResolution / 4
				Unit3DyPos = self.YResolution * 42 / 80 - self.CARGO_ICON_SIZE * 2
			else:
				Unit3DyPos = self.YResolution - self.YResolution * 2 / 21 - Unit3DySize
						
			if player.getDocksNextUnit(i) != UnitTypes.NO_UNIT:
				UnitInfo = gc.getUnitInfo(player.getDocksNextUnit(i))
				iProfession = UnitInfo.getDefaultProfession()
				if (UnitInfo.getType() == "UNIT_CRIMINAL"):
					UnitPosY = -5
					UnitIconSizeX = self.RECRUIT_PANE_HEIGHT * 3 / 8
					UnitIconSizeY = self.RECRUIT_PANE_HEIGHT * 6 / 8
					if (not self.Pirates):
						Unit3DScale += 0.1
				
				if (UnitInfo.getType() == "UNIT_VETERAN"):
					UnitPosY = -10
					UnitIconSizeX = self.RECRUIT_PANE_HEIGHT * 4 / 8
					UnitIconSizeY = self.RECRUIT_PANE_HEIGHT * 13 / 16
					Unit3DScale += 0.05
				if (UnitInfo.getType() == "UNIT_FARMER"):
					UnitPosY = -5
					UnitIconSizeX = self.RECRUIT_PANE_HEIGHT * 3 / 8
					UnitIconSizeY = self.RECRUIT_PANE_HEIGHT * 11 / 16
				if (UnitInfo.getType() == "UNIT_INDENTURED_SERVANT"):
					Unit3DScale += 0.1
				if (UnitInfo.getType() == "UNIT_PIONEER"):
					Unit3DScale += 0.1
				if (UnitInfo.getType() == "UNIT_COLONIST"):
					Unit3DScale += 0.1		
				if (UnitInfo.getDefaultProfession() == 23):
					Unit3DScale += 0.1
				
				if (sdGetVal('komaScreens', player.getName(), 'Recruits3D') == 1):
					recruitsAnim = self.getNextWidgetName()
					screen.addUnitGraphicGFC( recruitsAnim, player.getDocksNextUnit(i), UnitInfo.getDefaultProfession(), Unit3DxPos + UnitPosX, Unit3DyPos, self.XResolution / 10 , Unit3DySize, WidgetTypes.WIDGET_GENERAL, -1, -1, 0, 0, Unit3DScale, false)			
					screen.moveToFront(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)
					screen.moveBackward(recruitsAnim)

					recruitsAnimButton = self.getNextWidgetName()	
					screen.setImageButtonAt( recruitsAnimButton, "RecruitList", "", UnitPosX, UnitPosY, UnitIconSizeX, UnitIconSizeY, WidgetTypes.WIDGET_PLAYER_HURRY, gc.getInfoTypeForString("HURRY_IMMIGRANT"), i)
					screen.moveToFront(recruitsAnimButton)
					
				else:
					screen.setImageButtonAt( self.getNextWidgetName(), "RecruitList", UnitInfo.getArtInfo(0, iProfession).getFullLengthIcon(), UnitPosX, UnitPosY, UnitIconSizeX, UnitIconSizeY, WidgetTypes.WIDGET_PLAYER_HURRY, gc.getInfoTypeForString("HURRY_IMMIGRANT"), i)
				
		# Trade Messages
		screen.clearListBoxGFC("MessageList")
			
		for i in range(player.getNumTradeMessages()):
			screen.prependListBoxString("MessageList", player.getTradeMessage(i), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

		# Yield Rates
		YieldList = []
		for iYield in range(YieldTypes.NUM_YIELD_TYPES):
			kYield = gc.getYieldInfo(iYield)
			if kYield.isCargo():
				YieldList.append(iYield)

		YieldAreaWidth = (self.XResolution / 20) * len(YieldList)
		xLocation = 0
		BoxSize = self.XResolution / len(YieldList)
		BoxSizeY = self.YResolution * 2 / 21
		Yield_space = (self.XResolution - (BoxSize * 6 / 7 * len(YieldList))) / 2
		
		for iYield in YieldList:
			kYield = gc.getYieldInfo(iYield)
			iSellPrice = playerEurope.getYieldSellPrice(iYield)
			iBuyPrice = playerEurope.getYieldBuyPrice(iYield)

			screen.addDDSGFC(self.getNextWidgetName(), ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SHADOW_BOX").getPath(), xLocation + Yield_space, self.YResolution - BoxSizeY * 6 / 7 - 17, BoxSize * 6 / 7, BoxSizeY * 6 / 7, WidgetTypes.WIDGET_MOVE_CARGO_TO_TRANSPORT, iYield, -1 )
			screen.addDDSGFC(self.getNextWidgetName(), ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_BOX_PRICE").getPath(), xLocation + Yield_space, self.YResolution - BoxSizeY * 6 / 7 - 17, BoxSize * 6 / 7, BoxSizeY * 6 / 7, WidgetTypes.WIDGET_MOVE_CARGO_TO_TRANSPORT, iYield, -1 )
			screen.addDragableButton(self.getNextWidgetName(), gc.getYieldInfo(iYield).getIcon(), "", xLocation + BoxSize / 10 + Yield_space, self.YResolution - (self.YResolution * 2 / 23) * 2 / 3 - 17, BoxSize * 2 / 3, (self.YResolution * 2 / 23) * 2 / 3, WidgetTypes.WIDGET_MOVE_CARGO_TO_TRANSPORT, iYield, -1, ButtonStyles.BUTTON_STYLE_IMAGE )
			szPrices = u"<font=3>%d/%d</font>" % (iBuyPrice, iSellPrice)
			if not player.isYieldEuropeTradable(iYield):
				szPrices = u"<color=255,0,0>" + szPrices + u"</color>"
			
			szWidget = self.getNextWidgetName()
			screen.setLabel(szWidget, "Background", szPrices, CvUtil.FONT_CENTER_JUSTIFY, xLocation + self.XResolution / 38 + Yield_space, self.YResolution - self.YResolution * 3 / 46 - 25, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_MOVE_CARGO_TO_TRANSPORT, iYield, -1)
			screen.moveBackward(szWidget)
			xLocation += BoxSize * 6 / 7
			
		#Immigration Bar
		
		if (not self.Pirates):
			szWidget = self.getNextWidgetName()

			if (sdGetVal('komaScreens', player.getName(), 'MultiLang') == 0):
				screen.addStackedBarGFC(szWidget, self.XResolution / 2 - self.XResolution / 12, self.Y_TITLE + self.YResolution / 75, self.XResolution / 6, 30, InfoBarTypes.NUM_INFOBAR_TYPES, WidgetTypes.WIDGET_GENERAL, self.HELP_CROSS_RATE, -1)
			else:
				screen.addStackedBarGFC(szWidget, self.XResolution * 8 / 20 - self.XResolution / 12, self.Y_TITLE + self.YResolution / 75, self.XResolution / 6, 30, InfoBarTypes.NUM_INFOBAR_TYPES, WidgetTypes.WIDGET_GENERAL, self.HELP_CROSS_RATE, -1)
		
			screen.setStackedBarColors(szWidget, InfoBarTypes.INFOBAR_STORED, gc.getInfoTypeForString("COLOR_WATER_TEXT"))
			screen.setStackedBarColors(szWidget, InfoBarTypes.INFOBAR_RATE, gc.getInfoTypeForString("COLOR_CITY_BLUE"))
			screen.setStackedBarColors(szWidget, InfoBarTypes.INFOBAR_RATE_EXTRA, gc.getInfoTypeForString("COLOR_EMPTY"))
			screen.setStackedBarColors(szWidget, InfoBarTypes.INFOBAR_EMPTY, gc.getInfoTypeForString("COLOR_EMPTY"))
			fStoredPercent = float(player.getCrossesStored()) / float(player.immigrationThreshold())
			screen.setBarPercentage(szWidget, InfoBarTypes.INFOBAR_STORED, fStoredPercent)
		
			if (fStoredPercent < 1.0):
				fRatePercent = float(player.getYieldRate(YieldTypes.YIELD_CROSSES)) / float(player.immigrationThreshold()) / (1 - fStoredPercent)
				screen.setBarPercentage(szWidget, InfoBarTypes.INFOBAR_RATE, fRatePercent)

			if (sdGetVal('komaScreens', player.getName(), 'MultiLang') == 0):
				screen.setLabel(self.getNextWidgetName(), "", u"<font=3>" + localText.getText("TXT_KEY_IMMIGRATION_BAR", (player.getCrossesStored(), player.immigrationThreshold(), gc.getYieldInfo(YieldTypes.YIELD_CROSSES).getChar())) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, self.XResolution / 2, self.Y_TITLE + self.YResolution / 50, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, self.HELP_CROSS_RATE, -1)
			else:
				screen.setLabel(self.getNextWidgetName(), "", u"<font=3>" + localText.getText("TXT_KEY_IMMIGRATION_BAR", (player.getCrossesStored(), player.immigrationThreshold(), gc.getYieldInfo(YieldTypes.YIELD_CROSSES).getChar())) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, self.XResolution * 8 / 20, self.Y_TITLE + self.YResolution / 50, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, self.HELP_CROSS_RATE, -1)
		
		return 0
		
		
	def getNextWidgetName(self):
		szName = self.WIDGET_ID + str(self.nWidgetCount)
		self.nWidgetCount += 1
		return szName

	def deleteAllWidgets(self):
		screen = self.getScreen()
		i = self.nWidgetCount - 1
		while (i >= 0):
			self.nWidgetCount = i
			if (self.getNextWidgetName() != "Immigrant_Widget") or (self.getNextWidgetName() != "WaterAnim_Widget"):
				screen.deleteWidget(self.getNextWidgetName())
			i -= 1

		self.nWidgetCount = 0

	# Will handle the input for this screen...
	def handleInput(self, inputClass):
		'Calls function mapped in EuropeScreenInputMap'
		
		player = gc.getPlayer(gc.getGame().getActivePlayer())
		playerEurope = gc.getPlayer(player.getParent())
				
		if (inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED):

			player = gc.getPlayer(gc.getGame().getActivePlayer())
		
			if (inputClass.getButtonType() == WidgetTypes.WIDGET_PLAYER_HURRY):
			
				if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
				
					if (playerEurope.getNameKey() == "TXT_KEY_LEADER_FRENCH_KING"):
						soundPlayerHurry = "AS3D_FRANCE_SELECT"
					elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_SPANISH_KING"):
						soundPlayerHurry = "AS3D_SPAIN_SELECT"
					elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_DUTCH_KING"):
						soundPlayerHurry = "AS3D_NETHERLANDS_SELECT"
					elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_PORTUGUESE_KING"):
						soundPlayerHurry = "AS3D_PORTUGAL_SELECT"
					else:
						soundPlayerHurry = "AS3D_ENGLAND_SELECT"
									
					self.getScreen().setSoundId(CyAudioGame().Play3DSound(soundPlayerHurry, -1, -1, -1))
				
			if (inputClass.getButtonType() == WidgetTypes.WIDGET_GENERAL):
				
				if (inputClass.getData1() == self.BUY_UNIT_BUTTON_ID) :
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PURCHASE_EUROPE_UNIT)
					CyInterface().addPopup(popupInfo, gc.getGame().getActivePlayer(), true, false)

				elif (inputClass.getData1() == self.SAIL_TO_NEW_WORLD) :
					transport = player.getUnit(inputClass.getData2())
					transport.setSailEast()
					
					if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
						if (playerEurope.getNameKey() == "TXT_KEY_LEADER_FRENCH_KING"):
							soundSailToNewWorld = "AS3D_FRANCE_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_SPANISH_KING"):
							soundSailToNewWorld = "AS3D_SPAIN_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_DUTCH_KING"):
							soundSailToNewWorld = "AS3D_NETHERLANDS_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_PORTUGUESE_KING"):
							soundSailToNewWorld = "AS3D_PORTUGAL_ORDER"
						else:
							soundSailToNewWorld = "AS3D_ENGLAND_ORDER"
												
						self.getScreen().setSoundId(CyAudioGame().Play3DSound(soundSailToNewWorld, -1, -1 , -1))
					
					if (not transport.isNone()) and transport.getUnitTravelState() != UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE:
						CyMessageControl().sendDoCommand(inputClass.getData2(), CommandTypes.COMMAND_SAIL_TO_EUROPE, UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE, -1, false)
				
				elif (inputClass.getData1() == self.SAIL_WEST) :
					#activePlayer = gc.getPlayer(gc.getGame().getActivePlayer())
					transport = player.getUnit(inputClass.getData2())
					transport.setSailWest()
					
					if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
						if (playerEurope.getNameKey() == "TXT_KEY_LEADER_FRENCH_KING"):
							soundSailToNewWorld = "AS3D_FRANCE_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_SPANISH_KING"):
							soundSailToNewWorld = "AS3D_SPAIN_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_DUTCH_KING"):
							soundSailToNewWorld = "AS3D_NETHERLANDS_ORDER"
						elif (playerEurope.getNameKey() == "TXT_KEY_LEADER_PORTUGUESE_KING"):
							soundSailToNewWorld = "AS3D_PORTUGAL_ORDER"
						else:
							soundSailToNewWorld = "AS3D_ENGLAND_ORDER"
												
						self.getScreen().setSoundId(CyAudioGame().Play3DSound(soundSailToNewWorld, -1, -1 , -1))
					
					if (not transport.isNone()) and transport.getUnitTravelState() != UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE:
						CyMessageControl().sendDoCommand(inputClass.getData2(), CommandTypes.COMMAND_SAIL_TO_EUROPE, UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE, -1, false)
				
				elif (inputClass.getData1() == self.SELL_ALL) :
					transport = player.getUnit(inputClass.getData2())
					
					(unit, iter) = player.firstUnit()
					while (unit):
						if (unit.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_IN_EUROPE and unit.isCargo() and unit.isGoods()):
							if (unit.getTransportUnit().getID() == transport.getID()):
								CyMessageControl().sendPlayerAction(player.getID(), PlayerActionTypes.PLAYER_ACTION_SELL_YIELD_UNIT, 0, unit.getYieldStored(), unit.getID())
						(unit, iter) = player.nextUnit(iter)
					
					if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
						self.getScreen().setSoundId(CyAudioGame().Play2DSound("AS2D_BUILD_BANK"))
					
				elif (inputClass.getData1() == self.LOAD_ALL) :
					transport = player.getUnit(inputClass.getData2())
					for i in range(player.getNumEuropeUnits()):
						loopUnit = player.getEuropeUnit(i)
						if (not transport.isNone() and transport.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_IN_EUROPE and not transport.isFull()):
							CyMessageControl().sendPlayerAction(player.getID(), PlayerActionTypes.PLAYER_ACTION_LOAD_UNIT_FROM_EUROPE, loopUnit.getID(), inputClass.getData2(), -1)
					
					if (sdGetVal('komaScreens', player.getName(), 'Audio') == 1):
						self.getScreen().setSoundId(CyAudioGame().Play2DSound("AS2D_REVOLTEND"))
					
				elif (inputClass.getData1() == self.TRADE) :
					if (sdGetVal('komaScreens', player.getName(), 'TradeBox') == 1):
						sdSetVal('komaScreens', player.getName(), 'TradeBox', 0)
					else:
						sdSetVal('komaScreens', player.getName(), 'TradeBox', 1)
						
					if (CyInterface().isDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT)):
						CyInterface().setDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT, False)
					self.drawContents()
					return 0

	def update(self, fDelta):
		if (CyInterface().isDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT)):
			CyInterface().setDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT, False)
			
			self.drawContents()

	def getWidgetHelp(self, argsList):
		iScreen, eWidgetType, iData1, iData2, bOption = argsList

		if eWidgetType == WidgetTypes.WIDGET_GENERAL:
			if iData1 == self.SAIL_TO_NEW_WORLD:
				message = localText.getText("TXT_KEY_SAIL_EAST", ())
				message += localText.getText(" (Atlantic)", ())
				return message
			elif iData1 == self.SAIL_WEST:
				message = localText.getText("TXT_KEY_SAIL_WEST", ())
				message += localText.getText(" (Pacific)", ())
				return message
			elif iData1 == self.SELL_ALL:
				return localText.getText("TXT_KEY_SELL_ALL", ())
			elif iData1 == self.LOAD_ALL:
				return localText.getText("TXT_KEY_LOAD_ALL_EUROPE", ())
			elif iData1 == self.BUY_UNIT_BUTTON_ID:
				return localText.getText("TXT_KEY_PURCHASE_EUROPE", ())
			elif iData1 == self.TREASURY_ID:
				return localText.getText("TXT_KEY_ECON_GOLD_RESERVE" , ())
			elif iData1 == self.HELP_CROSS_RATE:
				player = gc.getPlayer(gc.getGame().getActivePlayer())
				return localText.getText("TXT_KEY_YIELD_RATE", (player.getYieldRate(YieldTypes.YIELD_CROSSES), gc.getYieldInfo(YieldTypes.YIELD_CROSSES).getChar()))
			elif iData1 == self.BOUND:
				player = gc.getPlayer(gc.getGame().getActivePlayer())
				transport = player.getUnit(iData2)
				
				if (transport.getUnitTravelState() == UnitTravelStates.UNIT_TRAVEL_STATE_FROM_EUROPE):
					currentCargoList = self.OutBoundCargoList
				else:
					currentCargoList = self.InBoundCargoList
					
				szText = localText.getText("[COLOR_HIGHLIGHT_TEXT]%s1[COLOR_REVERT][NEWLINE]", (transport.getName(),""))
				szText += localText.getText("TXT_KEY_ARRIVALS_IN", ("",transport.getUnitTravelTimer()))
			    
				cargoList = []
				cargoIndex = 0
				
				for cargo in currentCargoList:
					if ((cargo.isGoods()) and (cargo.getTransportUnit().getID() == iData2)):
						cargoIndex += 1
						if (not cargo.getName() in cargoList):
							cargoList.insert(cargoIndex, cargo.getName())
							cargoIndex += 1
							cargoList.insert(cargoIndex, cargo.getYieldStored())  
						else:
							index = cargoList.index(cargo.getName()) + 1
							allYieldStored = cargo.getYieldStored() + cargoList[index]
							del cargoList[index]
							cargoList.insert(index, allYieldStored)
							
					elif cargo.getTransportUnit().getID() == iData2:
						cargoIndex += 1
						if (not cargo.getName() in cargoList):
							cargoList.insert(cargoIndex, cargo.getName())
							cargoIndex += 1
							cargoList.insert(cargoIndex, 1)  
						else:
							index = cargoList.index(cargo.getName()) + 1
							allYieldStored = cargoList[index] + 1
							del cargoList[index - 1]
							cargoList.insert(index - 1, cargo.getNameForm(1)) 
							del cargoList[index]
							cargoList.insert(index, allYieldStored)
						
				cargoIndex = 0
				
				for i in range(1, len(cargoList), 2):
					szText += localText.getText("[NEWLINE][COLOR_BUILDING_TEXT][ICON_BULLET]", ())
					
					szText += u"<font=2>%s</font>" % cargoList[cargoIndex + 1]
					szText += u"<font=2> %s</font>" % cargoList[cargoIndex]
					
					szText += localText.getText("[COLOR_REVERT]", ())
					cargoIndex += 2
					
				return (szText)
				
			elif iData1 == self.TRADE:
				#if (CyGame().getCurrentLanguage() == 0):
				#	return localText.getText("Turn trade messages [COLOR_HIGHLIGHT_TEXT]on/off[COLOR_REVERT] ", ())
				return self.CREDITS
				
		return u""

	def playSoundID(self, SoundName):
		self.unitsSound = CyAudioGame().Play2DSound(SoundName)
		return self.unitsSound
		


################# SD-UTILITY-PACK ###################
# Taken from sdToolKit Version 1.22 by Stone-D (Laga Mahesa)

#-=-=-=-=-=-=-=-= SD-DATA-STORAGE =-=-=-=-=-=-=-=-=-#
# Every variable is a string, except for the actual
# value you want to store, which can be anything.

#--------------- INTERNAL USE ONLY -----------------#
	
def sdModInit( ModID ):
	try:
		cyTable = pickle.loads( CyGameInstance.getScriptData() )
	except:
		cyTable = {}
	if ( not cyTable.has_key(ModID) ):
		cyTable = sdModFixCase(ModID, cyTable) # Check for capitalization difference and fix in case of permanent change.
	if ( not cyTable.has_key(ModID) ):
		cyTable[ModID] = pickle.dumps({})      # Initialize with an empty table.
		#sdEcho('Mod Data Initialized : %s %s' %(ModID, cyTable.has_key(ModID)))
	CyGameInstance.setScriptData( pickle.dumps(cyTable) )
	return {}

#   For internal use. You should not use this function.
def sdModFixCase( ModID, cyTable ):
	for i, k in enumerate(cyTable):
		if (k.upper() == ModID.upper()):
			szStringData = cyTable[k]
			cyTable[ModID] = szStringData
			del cyTable[k]
			#sdEcho('Mod Data Fixed : %s : %s (was %s)' %(ModID, cyTable.has_key(ModID), k))
			break
	return cyTable

#   Loads previously initialized data from the central reservoir.
def sdModLoad( ModID ):
	try:
		cyTable = pickle.loads( CyGameInstance.getScriptData() )
		mTable  = pickle.loads(cyTable[ModID])
	except:
		mTable  = sdModInit(ModID)
	return mTable

#   Saves a mod's entire variable data to the central reservoir.
def sdModSave( ModID, mTable ):
	try:
		cyTable = pickle.loads( CyGameInstance.getScriptData() )
	except:
		cyTable = sdModInit(ModID)
	cyTable[ModID] = pickle.dumps(mTable)
	CyGameInstance.setScriptData( pickle.dumps(cyTable) )
	return 0

#----------------- MOD FUNCTIONS -------------------#

#   sdEntityInit( 'MyModName', 'UniqueName', Template_dictionary )
#   Initializes a unique data entity (city, unit, plot).
def sdEntityInit( ModID, entity, eTable ):
	mTable = sdModLoad(ModID)
	mTable[entity] = pickle.dumps(eTable)
	sdModSave(ModID, mTable)
	return 0

#   sdEntityExists( 'MyModName', 'UniqueName' )
#   Checks whether or not an entity has been initialized by sdEntityInit.
#   Returns bool False on failure, bool True on success.
def sdEntityExists( ModID, entity ):
	mTable = sdModLoad(ModID)
	if ( mTable.has_key(entity) ):
		return True
	return False

#   sdGetVal( 'MyModName', 'UniqueName', 'VariableName' )
#   Fetches a specific variable's value from the entity's data set.
def sdGetVal( ModID, entity, var ):
	mTable = sdModLoad(ModID)
	eTable = pickle.loads(mTable[entity])
	#	sdEcho('%s : Load : %s, %s = %d' %(ModID, entity, var, eTable[var]))
	return eTable[var]

#   sdSetVal( 'MyModName', 'UniqueName', 'VariableName', any_value )
#   Stores a specific variable's value within the entity's data set.
#   Returns bool False on failure, bool True on success.
def sdSetVal( ModID, entity, var, val ):
	mTable = sdModLoad(ModID)
	if ( mTable.has_key(entity) ):
		eTable         = pickle.loads(mTable[entity])
		eTable[var]    = val
		mTable[entity] = pickle.dumps(eTable)
		sdModSave(ModID, mTable)
		# sdEcho('%s : sdSetVal : %s, %s = %d' %(ModID, entity, var, eTable[var]))
		return True
	return False
