
/*
 * DO NOT EDIT THIS FILE!
 * It is generated automatically by ctpdb
 */
#include "c3.h"
#include "ReligionRecord.h"

#include <algorithm>
#include "BitArray.h"
#include "c3errors.h"
#include "CTPDatabase.h"
#include "DBLexer.h"
#include "DBTokens.h"
#include "StrDB.h"

#include "AdvanceRecord.h"
#include "AdvanceRecord.h"
#include "CityStyleRecord.h"
#include "IconRecord.h"

CTPDatabase<ReligionRecord> *g_theReligionDB = NULL;

void ReligionRecord::Init()
{
    m_flags0 = 0;
    m_FoodCoef = 0.000000;
    m_GoldCoef = 0.000000;
    m_ProductionCoef = 0.000000;
    m_SupportCoef = 0.000000;
    m_DefenseCoef = 0.000000;
    m_EnableAdvance = 0x7fffffff;
    memset(m_ObsoleteAdvance, 0, sizeof(m_ObsoleteAdvance));
    m_numObsoleteAdvance = 0;
    m_CultureOnly = NULL;
    m_numCultureOnly = 0;
    m_Icon = 0x7fffffff;
    m_GrowthRank = 0;
    m_ProductionRank = 0;
    m_ScienceRank = 0;
    m_GoldRank = 0;
    m_MilitaryRank = 0;
    m_CommerceRank = 0;
    m_PollutionRank = 0;
    m_LoyaltyRank = 0;
    m_MartialLawRank = 0;
    m_MaxScienceRate = 0.000000;
    m_UnitRushModifier = 0.000000;
    m_BuildingRushModifier = 0.000000;
    m_WonderRushModifier = 0.000000;
    m_EndGameRushModifier = 0.000000;
    m_MaxIncomingTrade = 0;
    m_MaxOutgoingTrade = 0;
    m_InfrastructureCoefficient = 0.000000;
    m_CapitalizationCoefficient = 0.000000;
    m_WarDiscontentMaxUnits = 0;
    m_WarDiscontentPerUnit = 0.000000;
    m_Rank = 0;
    m_SameRankAdvice = 0;
    m_HigherRankAdvice = 0;
    //GovMod Specific flag initialization
    m_hasGovernmentsModified = false;
}

void ReligionRecord::Serialize(CivArchive &archive)
{
    if(archive.IsStoring()) {
        archive << m_index;
        if(m_name >= 0){
            archive << GetIDText();
        }
        else{
            archive << static_cast<MBCHAR*>(NULL);
        }
        archive << m_flags0;
        archive << m_FoodCoef;
        archive << m_GoldCoef;
        archive << m_ProductionCoef;
        archive << m_SupportCoef;
        archive << m_DefenseCoef;
        archive << m_EnableAdvance;
        archive << m_numObsoleteAdvance;
        archive.Store((uint8*)&m_ObsoleteAdvance, sizeof(m_ObsoleteAdvance));
        archive << m_numCultureOnly;
        archive.Store((uint8*)m_CultureOnly, m_numCultureOnly * sizeof(sint32));

        archive << m_Icon;
        archive << m_GrowthRank;
        archive << m_ProductionRank;
        archive << m_ScienceRank;
        archive << m_GoldRank;
        archive << m_MilitaryRank;
        archive << m_CommerceRank;
        archive << m_PollutionRank;
        archive << m_LoyaltyRank;
        archive << m_MartialLawRank;
        archive << m_MaxScienceRate;
        archive << m_UnitRushModifier;
        archive << m_BuildingRushModifier;
        archive << m_WonderRushModifier;
        archive << m_EndGameRushModifier;
        archive << m_MaxIncomingTrade;
        archive << m_MaxOutgoingTrade;
        archive << m_InfrastructureCoefficient;
        archive << m_CapitalizationCoefficient;
        archive << m_WarDiscontentMaxUnits;
        archive << m_WarDiscontentPerUnit;
        archive << m_Rank;
        {
            MBCHAR* tmpString = g_theStringDB->GetIdStr(m_SameRankAdvice);
            archive << tmpString;
        }

        {
            MBCHAR* tmpString = g_theStringDB->GetIdStr(m_HigherRankAdvice);
            archive << tmpString;
        }

    } else {
        //GovMod Specific flag initialization
        m_hasGovernmentsModified = false;

        archive >> m_index;
        {
            MBCHAR* tmpStr = NULL;
            archive >> tmpStr;
            g_theStringDB->GetStringID(tmpStr, m_name);
            SetTextName(g_theStringDB->GetNameStr(m_name));
        }
        archive >> m_flags0;
        archive >> m_FoodCoef;
        archive >> m_GoldCoef;
        archive >> m_ProductionCoef;
        archive >> m_SupportCoef;
        archive >> m_DefenseCoef;
        archive >> m_EnableAdvance;
        archive >> m_numObsoleteAdvance;
        archive.Load((uint8*)&m_ObsoleteAdvance, sizeof(m_ObsoleteAdvance));
        archive >> m_numCultureOnly;
        archive.Load((uint8*)m_CultureOnly, m_numCultureOnly * sizeof(sint32));

        archive >> m_Icon;
        archive >> m_GrowthRank;
        archive >> m_ProductionRank;
        archive >> m_ScienceRank;
        archive >> m_GoldRank;
        archive >> m_MilitaryRank;
        archive >> m_CommerceRank;
        archive >> m_PollutionRank;
        archive >> m_LoyaltyRank;
        archive >> m_MartialLawRank;
        archive >> m_MaxScienceRate;
        archive >> m_UnitRushModifier;
        archive >> m_BuildingRushModifier;
        archive >> m_WonderRushModifier;
        archive >> m_EndGameRushModifier;
        archive >> m_MaxIncomingTrade;
        archive >> m_MaxOutgoingTrade;
        archive >> m_InfrastructureCoefficient;
        archive >> m_CapitalizationCoefficient;
        archive >> m_WarDiscontentMaxUnits;
        archive >> m_WarDiscontentPerUnit;
        archive >> m_Rank;
        {
            MBCHAR* tmpString = NULL;
            archive >> tmpString;
            g_theStringDB->GetStringID(tmpString, m_SameRankAdvice);
            delete[] tmpString;
        }

        {
            MBCHAR* tmpString = NULL;
            archive >> tmpString;
            g_theStringDB->GetStringID(tmpString, m_HigherRankAdvice);
            delete[] tmpString;
        }

    }
}

ReligionRecord::~ReligionRecord()
{
    delete [] m_CultureOnly;
}

ReligionRecord const & ReligionRecord::operator = (ReligionRecord const & rval)
{
    if (this != &rval)
    {
        m_index = rval.m_index;
        m_flags0 = rval.m_flags0;
        m_hasGovernmentsModified = rval.m_hasGovernmentsModified;

        m_FoodCoef = rval.m_FoodCoef;

        m_GoldCoef = rval.m_GoldCoef;

        m_ProductionCoef = rval.m_ProductionCoef;

        m_SupportCoef = rval.m_SupportCoef;

        m_DefenseCoef = rval.m_DefenseCoef;

        m_EnableAdvance = rval.m_EnableAdvance;

        std::copy(rval.m_ObsoleteAdvance, rval.m_ObsoleteAdvance + rval.m_numObsoleteAdvance, m_ObsoleteAdvance);

        delete [] m_CultureOnly;
        m_CultureOnly = NULL;
        if (rval.m_numCultureOnly > 0)
        {
            m_CultureOnly = new sint32 [rval.m_numCultureOnly];
            std::copy(rval.m_CultureOnly, rval.m_CultureOnly + rval.m_numCultureOnly, m_CultureOnly);
        }
        m_numCultureOnly = rval.m_numCultureOnly;

        m_Icon = rval.m_Icon;

        m_GrowthRank = rval.m_GrowthRank;

        m_ProductionRank = rval.m_ProductionRank;

        m_ScienceRank = rval.m_ScienceRank;

        m_GoldRank = rval.m_GoldRank;

        m_MilitaryRank = rval.m_MilitaryRank;

        m_CommerceRank = rval.m_CommerceRank;

        m_PollutionRank = rval.m_PollutionRank;

        m_LoyaltyRank = rval.m_LoyaltyRank;

        m_MartialLawRank = rval.m_MartialLawRank;

        m_MaxScienceRate = rval.m_MaxScienceRate;

        m_UnitRushModifier = rval.m_UnitRushModifier;

        m_BuildingRushModifier = rval.m_BuildingRushModifier;

        m_WonderRushModifier = rval.m_WonderRushModifier;

        m_EndGameRushModifier = rval.m_EndGameRushModifier;

        m_MaxIncomingTrade = rval.m_MaxIncomingTrade;

        m_MaxOutgoingTrade = rval.m_MaxOutgoingTrade;

        m_InfrastructureCoefficient = rval.m_InfrastructureCoefficient;

        m_CapitalizationCoefficient = rval.m_CapitalizationCoefficient;

        m_WarDiscontentMaxUnits = rval.m_WarDiscontentMaxUnits;

        m_WarDiscontentPerUnit = rval.m_WarDiscontentPerUnit;

        m_Rank = rval.m_Rank;

        m_SameRankAdvice = rval.m_SameRankAdvice;

        m_HigherRankAdvice = rval.m_HigherRankAdvice;

    }

    return *this;
}

char *g_Religion_Tokens[] =
{
    "FoodCoef",
    "GoldCoef",
    "ProductionCoef",
    "SupportCoef",
    "DefenseCoef",
    "EnableAdvance",
    "ObsoleteAdvance",
    "CultureOnly",
    "Icon",
    "GrowthRank",
    "ProductionRank",
    "ScienceRank",
    "GoldRank",
    "MilitaryRank",
    "CommerceRank",
    "PollutionRank",
    "LoyaltyRank",
    "MartialLawRank",
    "MaxScienceRate",
    "UnitRushModifier",
    "BuildingRushModifier",
    "WonderRushModifier",
    "EndGameRushModifier",
    "MaxIncomingTrade",
    "MaxOutgoingTrade",
    "InfrastructureCoefficient",
    "CapitalizationCoefficient",
    "WarDiscontentMaxUnits",
    "WarDiscontentPerUnit",
    "GLHidden",
    "Rank",
    "SameRankAdvice",
    "HigherRankAdvice",
};

ReligionRecordAccessorInfo g_ReligionRecord_Accessors[] =
{
    { NULL, NULL, &ReligionRecord::GetFoodCoef, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetGoldCoef, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetProductionCoef, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetSupportCoef, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetDefenseCoef, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetEnableAdvanceIndex, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetNumObsoleteAdvance, NULL, NULL, NULL, NULL, &ReligionRecord::GetObsoleteAdvanceIndex, NULL}, /* ObsoleteAdvance (array) */
    { &ReligionRecord::GetNumCultureOnly, NULL, NULL, NULL, NULL, &ReligionRecord::GetCultureOnlyIndex, NULL}, /* CultureOnly (array) */
    { &ReligionRecord::GetIconIndex, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetGrowthRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetProductionRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetScienceRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetGoldRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetMilitaryRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetCommerceRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetPollutionRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetLoyaltyRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetMartialLawRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetMaxScienceRate, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetUnitRushModifier, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetBuildingRushModifier, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetWonderRushModifier, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetEndGameRushModifier, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetMaxIncomingTrade, NULL, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetMaxOutgoingTrade, NULL, NULL, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetInfrastructureCoefficient, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetCapitalizationCoefficient, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetWarDiscontentMaxUnits, NULL, NULL, NULL, NULL, NULL, NULL },
    { NULL, NULL, &ReligionRecord::GetWarDiscontentPerUnit, NULL, NULL, NULL, NULL },
    { NULL, &ReligionRecord::GetGLHidden, NULL, NULL, NULL, NULL, NULL },
    { &ReligionRecord::GetRank, NULL, NULL, NULL, NULL, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL }, /* SameRankAdvice */
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL }, /* HigherRankAdvice */
};

#define k_Token_Religion_FoodCoef                ((k_Token_Custom_Base) + 0)
#define k_Token_Religion_GoldCoef                ((k_Token_Custom_Base) + 1)
#define k_Token_Religion_ProductionCoef          ((k_Token_Custom_Base) + 2)
#define k_Token_Religion_SupportCoef             ((k_Token_Custom_Base) + 3)
#define k_Token_Religion_DefenseCoef             ((k_Token_Custom_Base) + 4)
#define k_Token_Religion_EnableAdvance           ((k_Token_Custom_Base) + 5)
#define k_Token_Religion_ObsoleteAdvance         ((k_Token_Custom_Base) + 6)
#define k_Token_Religion_CultureOnly             ((k_Token_Custom_Base) + 7)
#define k_Token_Religion_Icon                    ((k_Token_Custom_Base) + 8)
#define k_Token_Religion_GrowthRank              ((k_Token_Custom_Base) + 9)
#define k_Token_Religion_ProductionRank          ((k_Token_Custom_Base) + 10)
#define k_Token_Religion_ScienceRank             ((k_Token_Custom_Base) + 11)
#define k_Token_Religion_GoldRank                ((k_Token_Custom_Base) + 12)
#define k_Token_Religion_MilitaryRank            ((k_Token_Custom_Base) + 13)
#define k_Token_Religion_CommerceRank            ((k_Token_Custom_Base) + 14)
#define k_Token_Religion_PollutionRank           ((k_Token_Custom_Base) + 15)
#define k_Token_Religion_LoyaltyRank             ((k_Token_Custom_Base) + 16)
#define k_Token_Religion_MartialLawRank          ((k_Token_Custom_Base) + 17)
#define k_Token_Religion_MaxScienceRate          ((k_Token_Custom_Base) + 18)
#define k_Token_Religion_UnitRushModifier        ((k_Token_Custom_Base) + 19)
#define k_Token_Religion_BuildingRushModifier    ((k_Token_Custom_Base) + 20)
#define k_Token_Religion_WonderRushModifier      ((k_Token_Custom_Base) + 21)
#define k_Token_Religion_EndGameRushModifier     ((k_Token_Custom_Base) + 22)
#define k_Token_Religion_MaxIncomingTrade        ((k_Token_Custom_Base) + 23)
#define k_Token_Religion_MaxOutgoingTrade        ((k_Token_Custom_Base) + 24)
#define k_Token_Religion_InfrastructureCoefficient ((k_Token_Custom_Base) + 25)
#define k_Token_Religion_CapitalizationCoefficient ((k_Token_Custom_Base) + 26)
#define k_Token_Religion_WarDiscontentMaxUnits   ((k_Token_Custom_Base) + 27)
#define k_Token_Religion_WarDiscontentPerUnit    ((k_Token_Custom_Base) + 28)
#define k_Token_Religion_GLHidden                ((k_Token_Custom_Base) + 29)
#define k_Token_Religion_Rank                    ((k_Token_Custom_Base) + 30)
#define k_Token_Religion_SameRankAdvice          ((k_Token_Custom_Base) + 31)
#define k_Token_Religion_HigherRankAdvice        ((k_Token_Custom_Base) + 32)
#define k_Token_Religion_Max                     ((k_Token_Custom_Base) + 33)


static BitArray s_ParsedTokens(33);
void ReligionRecord::CheckRequiredFields(DBLexer *lex)
{
    if(!s_ParsedTokens.Bit(k_Token_Religion_FoodCoef - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field FoodCoef missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_GoldCoef - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field GoldCoef missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_ProductionCoef - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field ProductionCoef missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_SupportCoef - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field SupportCoef missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_DefenseCoef - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field DefenseCoef missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_GrowthRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field GrowthRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_ProductionRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field ProductionRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_ScienceRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field ScienceRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_GoldRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field GoldRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_MilitaryRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field MilitaryRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_CommerceRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field CommerceRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_PollutionRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field PollutionRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_LoyaltyRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field LoyaltyRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_MartialLawRank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field MartialLawRank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_MaxScienceRate - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field MaxScienceRate missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_UnitRushModifier - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field UnitRushModifier missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_BuildingRushModifier - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field BuildingRushModifier missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_WonderRushModifier - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field WonderRushModifier missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_EndGameRushModifier - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field EndGameRushModifier missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_MaxIncomingTrade - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field MaxIncomingTrade missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_MaxOutgoingTrade - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field MaxOutgoingTrade missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_InfrastructureCoefficient - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field InfrastructureCoefficient missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_CapitalizationCoefficient - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field CapitalizationCoefficient missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_WarDiscontentMaxUnits - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field WarDiscontentMaxUnits missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_WarDiscontentPerUnit - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field WarDiscontentPerUnit missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_Rank - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field Rank missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_SameRankAdvice - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field SameRankAdvice missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Religion_HigherRankAdvice - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field HigherRankAdvice missing"));
    }
}

sint32 ReligionRecord::Parse(DBLexer *lex, sint32 numRecords)
{
    bool done = false;
    sint32 result = 0;
    sint32 tok;
    s_ParsedTokens.Clear();
    lex->SetTokens(g_Religion_Tokens, k_Token_Religion_Max);
    tok = lex->GetToken();
    if(tok == k_Token_Int) {
        tok = lex->GetToken(); // Accept number to make new db compatible with the old database format
    }
    if(tok != k_Token_Name) {
        char newName[256];
        sprintf(newName, "RELIGION_%i", numRecords);
        if(!g_theStringDB->GetStringID(newName, m_name)) {
            g_theStringDB->InsertStr(newName, newName);
            if(!g_theStringDB->GetStringID(newName, m_name))
                SetTextName(newName);
        }
    }
    else{
        if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name)) {
            g_theStringDB->InsertStr(lex->GetTokenText(), lex->GetTokenText());
            if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name))
                SetTextName(lex->GetTokenText());
        }
        tok = lex->GetToken();
    }


    if(tok != k_Token_OpenBrace) {
        DBERROR(("Missing open brace"));
        return 0;
    }

    while(!done) {
        tok = lex->GetToken();
        if(tok >= k_Token_Custom_Base && tok < k_Token_Religion_Max) {
            s_ParsedTokens.SetBit(tok - k_Token_Custom_Base);
        }
        switch(tok) {
            case k_Token_Religion_FoodCoef:
                if(!lex->GetFloatAssignment(m_FoodCoef)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_GoldCoef:
                if(!lex->GetFloatAssignment(m_GoldCoef)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_ProductionCoef:
                if(!lex->GetFloatAssignment(m_ProductionCoef)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_SupportCoef:
                if(!lex->GetFloatAssignment(m_SupportCoef)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_DefenseCoef:
                if(!lex->GetFloatAssignment(m_DefenseCoef)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_EnableAdvance:
                if (!g_theAdvanceDB->GetRecordFromLexer(lex, m_EnableAdvance)) {
                    done = true; break;
                }
                break;
            case k_Token_Religion_ObsoleteAdvance:
                if(!g_theAdvanceDB->ParseRecordInArray(lex, (sint32 *)m_ObsoleteAdvance, &m_numObsoleteAdvance, k_MAX_ObsoleteAdvance)) {
                    done = true; break;
                }
                break;
            case k_Token_Religion_CultureOnly:
                if(!g_theCityStyleDB->ParseRecordInArray(lex, (sint32 **)&m_CultureOnly, &m_numCultureOnly))
                {
                    done = true; break;
                }
                break;
            case k_Token_Religion_Icon:
                if (!g_theIconDB->GetRecordFromLexer(lex, m_Icon)) {
                    done = true; break;
                }
                break;
            case k_Token_Religion_GrowthRank:
                if(!lex->GetIntAssignment(m_GrowthRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_ProductionRank:
                if(!lex->GetIntAssignment(m_ProductionRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_ScienceRank:
                if(!lex->GetIntAssignment(m_ScienceRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_GoldRank:
                if(!lex->GetIntAssignment(m_GoldRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_MilitaryRank:
                if(!lex->GetIntAssignment(m_MilitaryRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_CommerceRank:
                if(!lex->GetIntAssignment(m_CommerceRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_PollutionRank:
                if(!lex->GetIntAssignment(m_PollutionRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_LoyaltyRank:
                if(!lex->GetIntAssignment(m_LoyaltyRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_MartialLawRank:
                if(!lex->GetIntAssignment(m_MartialLawRank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_MaxScienceRate:
                if(!lex->GetFloatAssignment(m_MaxScienceRate)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_UnitRushModifier:
                if(!lex->GetFloatAssignment(m_UnitRushModifier)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_BuildingRushModifier:
                if(!lex->GetFloatAssignment(m_BuildingRushModifier)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_WonderRushModifier:
                if(!lex->GetFloatAssignment(m_WonderRushModifier)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_EndGameRushModifier:
                if(!lex->GetFloatAssignment(m_EndGameRushModifier)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_MaxIncomingTrade:
                if(!lex->GetIntAssignment(m_MaxIncomingTrade)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_MaxOutgoingTrade:
                if(!lex->GetIntAssignment(m_MaxOutgoingTrade)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_InfrastructureCoefficient:
                if(!lex->GetFloatAssignment(m_InfrastructureCoefficient)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_CapitalizationCoefficient:
                if(!lex->GetFloatAssignment(m_CapitalizationCoefficient)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_WarDiscontentMaxUnits:
                if(!lex->GetIntAssignment(m_WarDiscontentMaxUnits)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_WarDiscontentPerUnit:
                if(!lex->GetFloatAssignment(m_WarDiscontentPerUnit)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_GLHidden:
                m_flags0 |= k_Religion_GLHidden_Bit;
                break;
            case k_Token_Religion_Rank:
                if(!lex->GetIntAssignment(m_Rank)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_SameRankAdvice:
                if(!lex->GetStringIdAssignment(m_SameRankAdvice)) {
                    DBERROR(("Expected string ID"));
                    done = true; break;
                }
                break;
            case k_Token_Religion_HigherRankAdvice:
                if(!lex->GetStringIdAssignment(m_HigherRankAdvice)) {
                    DBERROR(("Expected string ID"));
                    done = true; break;
                }
                break;
            case k_Token_CloseBrace:
                done = true;
                result = 1;
                break;
            default:
                if(!lex->GetFloat(m_FoodCoef)) {
                    DBERROR(("Unknown token"));
                    done = true; break;
                }
                break;
        }
    }
    CheckRequiredFields(lex);
    lex->RestoreTokens();
    return result;
}

void ReligionRecord::ResolveDBReferences()
{
    if(m_EnableAdvance & 0x80000000) {
        sint32 id = m_EnableAdvance & 0x7fffffff;
        if(!g_theAdvanceDB->GetNamedItem(id, m_EnableAdvance)) {
            c3errors_ErrorDialog("DB", "%s not found in Advance database", g_theStringDB->GetNameStr(id));
        }
    } else if(m_EnableAdvance == 0x7fffffff) {
        m_EnableAdvance = -1;
    }
    {
        sint32 i;
        for(i = 0; i < m_numObsoleteAdvance; i++) {
            if(m_ObsoleteAdvance[i] & 0x80000000) {
                sint32 id = m_ObsoleteAdvance[i] & 0x7fffffff;
                if(!g_theAdvanceDB->GetNamedItem(id, m_ObsoleteAdvance[i])) {
                    c3errors_ErrorDialog("DB", "%s not found in Advance database", g_theStringDB->GetNameStr(id));
                }
            } else if(m_ObsoleteAdvance[i] == 0x7fffffff){
                m_ObsoleteAdvance[i] = -1;
            }
        }
    }
    {
        sint32 i;
        for(i = 0; i < m_numCultureOnly; i++) {
            if(m_CultureOnly[i] & 0x80000000) {
                sint32 id = m_CultureOnly[i] & 0x7fffffff;
                if(!g_theCityStyleDB->GetNamedItem(id, m_CultureOnly[i])) {
                    c3errors_ErrorDialog("DB", "%s not found in CityStyle database", g_theStringDB->GetNameStr(id));
                }
            } else if(m_CultureOnly[i] == 0x7fffffff){
                m_CultureOnly[i] = -1;
            }
        }
    }
    if(m_Icon & 0x80000000) {
        sint32 id = m_Icon & 0x7fffffff;
        if(!g_theIconDB->GetNamedItem(id, m_Icon)) {
            c3errors_ErrorDialog("DB", "%s not found in Icon database", g_theStringDB->GetNameStr(id));
        }
    } else if(m_Icon == 0x7fffffff) {
        m_Icon = -1;
    }
}
void ReligionRecord::Merge(const ReligionRecord & rval){
    if (rval.m_numObsoleteAdvance > 0)
        std::copy(rval.m_ObsoleteAdvance, rval.m_ObsoleteAdvance + rval.m_numObsoleteAdvance, m_ObsoleteAdvance);

    // resize m_CultureOnly if necessary
    if (rval.m_numCultureOnly > m_numCultureOnly)
    {
        delete [] m_CultureOnly;
        m_CultureOnly = NULL;
        if (rval.m_numCultureOnly > 0)
            m_CultureOnly = new sint32 [rval.m_numCultureOnly];
        m_numCultureOnly = rval.m_numCultureOnly;
    }
    if (rval.m_numCultureOnly > 0)
        std::copy(rval.m_CultureOnly, rval.m_CultureOnly + rval.m_numCultureOnly, m_CultureOnly);

}

AdvanceRecord const * ReligionRecord::GetEnableAdvance() const
{
    return g_theAdvanceDB->Get(m_EnableAdvance);
}

sint32 ReligionRecord::GetObsoleteAdvanceIndex(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numObsoleteAdvance);
    if((index < 0) || (index >= m_numObsoleteAdvance)) {
        return 0;
    }
    return m_ObsoleteAdvance[index];
}

AdvanceRecord const * ReligionRecord::GetObsoleteAdvance(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numObsoleteAdvance);
    if((index < 0) || (index >= m_numObsoleteAdvance)) {
        return 0;
    }
    return g_theAdvanceDB->Get(m_ObsoleteAdvance[index]);
}

sint32 ReligionRecord::GetCultureOnlyIndex(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numCultureOnly);
    if((index < 0) || (index >= m_numCultureOnly)) {
        return 0;
    }
    return m_CultureOnly[index];
}

CityStyleRecord const * ReligionRecord::GetCultureOnly(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numCultureOnly);
    if((index < 0) || (index >= m_numCultureOnly)) {
        return 0;
    }
    return g_theCityStyleDB->Get(m_CultureOnly[index]);
}

IconRecord const * ReligionRecord::GetIcon() const
{
    return g_theIconDB->Get(m_Icon);
}

