## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## 
## Author : 12 Monkeys - Tool Collection
## Date : 12.12.2005
## version : 1.1
## 

from CvPythonExtensions import *
import CvUtil
import PyHelpers

PyPlayer = PyHelpers.PyPlayer

######################################################
### 	Class used for  Re-Init Interceptor Mission 
######################################################

class ReInitInterceptorMision:

	def __init__(self):
		self.firsttime = true

	def doReInit(self):
		iPlayer = PyPlayer(CyGame().getActivePlayer())
		unitList = iPlayer.getUnitList()
		# Loop for all players cities
		for ii in range(len(unitList)):
			pLoopUnit = unitList[ii]
			# get the group the unit belongs to. 
			pGroup = pLoopUnit.getGroup()
			# check if unit is doing air patrol
			if (pGroup.getActivityType() == ActivityTypes.ACTIVITY_INTERCEPT):
				# remove mission (this one shold be obsolete, but who knows ;)
				pGroup.popMission()
				pPlot = pGroup.plot()
				# add new mission -> fortify
				pGroup.pushMission(MissionTypes.MISSION_FORTIFY, 0, 0, 0, false, false, MissionAITypes.NO_MISSIONAI, pPlot, pLoopUnit)
				# add new mission -> air patrol
				pGroup.pushMission(MissionTypes.MISSION_AIRPATROL, 0, 0, 0, false, false, MissionAITypes.NO_MISSIONAI, pPlot, pLoopUnit)



######################################################
### 	Calculates index of an XP point
######################################################

def GetIdxOfXP(iXP):
	iLevel = 0
	iIdx = 0
	while iLevel <= iXP:
		iIdx += 1
		if iIdx == 1:
			iLevel = 2
		else:
			iLevel += (iIdx-1)*2+1
	return iIdx-1

######################################################
### 	Calculates the number of possible promotions between two XP values
######################################################

def GetPossiblePromotions(iXP1, iXP2):
	iIdx1 = GetIdxOfXP(iXP1)
	iIdx2 = GetIdxOfXP(iXP2)
	return iIdx2-iIdx1+1

		
######################################################
### 	END 
######################################################
