from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup
import CvCustomEventManager

PyInfo = PyHelpers.PyInfo
			
# globals
gc = CyGlobalContext()
#pMap = CyMap()
grass = 24
plains = 25
desert = 26
snow =  27
peak = 28
raiseelev = 29
lowerelev = 30
land = 31
jungle = 32
forest = 33

# Terraform mod created by  tywiggins 12/29/2006
# Resource generation and oil retention added by Roger Bacon 1/12/2006
# Improved message output by [YOUR NAME HERE]  (Yeah, that's a plea for someone to improve the routine on line 178 below
class Terraform:
	def __init__(self):
		self.list = []
		self.pPlot = CyMap().plot(0,0)

	def onImprovementBuilt(self, argsList):
		'Improvement Built'
		iImprovement, iX, iY = argsList
		pPlot = CyMap().plot(iX,iY)
		#  Chance of getting a resource is 1 out of [randomResourceChance]. Suggested value is 20, for a 5% chance.
		randomResourceChance = 20
		resourceName = "NONE"
		iRandNum = gc.getGame().getMapRand().get(randomResourceChance, "Random Resource Chance")
		grassDictionary = { 0 : 'BONUS_COAL', 1 : 'BONUS_COPPER', 2 : 'BONUS_HORSE', 3 : 'BONUS_IRON',
							4 : 'BONUS_OIL', 5 : 'BONUS_URANIUM', 6 : 'BONUS_BANANA', 7 : 'BONUS_CORN',
							8 : 'BONUS_COW', 9 : 'BONUS_PIG', 10 : 'BONUS_RICE', 11 : 'BONUS_SHEEP',
							12 : 'BONUS_DYE', 13 : 'BONUS_GEMS', 14 : 'BONUS_IVORY', 15 : 'BONUS_SILK',
							16 : 'BONUS_SPICES', 17 : 'BONUS_SUGAR'}
		plainsDictionary = { 0 : 'BONUS_COAL', 1 : 'BONUS_COPPER', 2 : 'BONUS_HORSE', 3 : 'BONUS_IRON',
							4 : 'BONUS_MARBLE', 5 : 'BONUS_STONE', 6 : 'BONUS_URANIUM', 7 : 'BONUS_WHEAT',
							8 : 'BONUS_COW', 9 : 'BONUS_SHEEP', 10 : 'BONUS_GOLD', 11 : 'BONUS_ALUMINUM',
							12 : 'BONUS_WINE', 13 : 'BONUS_GEMS', 14 : 'BONUS_IVORY', 15 : 'BONUS_SILK',
							16 : 'BONUS_SPICES'}
		desertDictionary = { 0 : 'BONUS_ALUMINUM', 1 : 'BONUS_COPPER', 2 : 'BONUS_IRON', 3 : 'BONUS_OIL',
							4 : 'BONUS_STONE', 5 : 'BONUS_URANIUM', 6 : 'BONUS_GOLD', 7 : 'BONUS_INCENSE'}
		tundraDictionary = { 0 : 'BONUS_ALUMINUM', 1 : 'BONUS_COPPER', 2 : 'BONUS_HORSE', 3 : 'BONUS_IRON',
							4 : 'BONUS_MARBLE', 5 : 'BONUS_OIL', 6 : 'BONUS_URANIUM', 7 : 'BONUS_DEER',
							8 : 'BONUS_FUR', 9 : 'BONUS_SILVER'}
		snowDictionary = { 0 : 'BONUS_COPPER', 1 : 'BONUS_IRON', 2 : 'BONUS_MARBLE', 3 : 'BONUS_OIL',
							4 : 'BONUS_URANIUM', 5 : 'BONUS_FUR', 6 : 'BONUS_SILVER'}
		jungleDictionary = { 0 : 'BONUS_OIL', 1 : 'BONUS_URANIUM', 2 : 'BONUS_BANANA', 3 : 'BONUS_PIG',
							4 : 'BONUS_RICE', 5 : 'BONUS_DYE', 6 : 'BONUS_GEMS', 7 : 'BONUS_IVORY',
							8 : 'BONUS_SPICES', 9 : 'BONUS_SUGAR'}
		coastDictionary = { 0 : 'BONUS_CLAM', 1 : 'BONUS_CRAB', 2 : 'BONUS_FISH'}
		forestDictionary = { 0 : 'BONUS_ALUMINUM', 1 : 'BONUS_DEER', 2 : 'BONUS_FUR', 3 : 'BONUS_SILK',
							4 : 'BONUS_SPICES'}
		if(iImprovement==grass):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"), true, true)
			pPlot.setImprovementType(-1)
			if (iRandNum == 0):
				iRandNum = gc.getGame().getMapRand().get(len(grassDictionary), "Grass Dictionary Entry")
				pPlot.setBonusType(gc.getInfoTypeForString(grassDictionary[iRandNum]))
				resourceName = gc.getBonusInfo(gc.getInfoTypeForString(grassDictionary[iRandNum])).getDescription()
		elif(iImprovement==plains):
			if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_SNOW")):
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_TUNDRA"), true, true)
				if (iRandNum == 0):
					iRandNum = gc.getGame().getMapRand().get(len(tundraDictionary), "Tundra Dictionary Entry")
					pPlot.setBonusType(gc.getInfoTypeForString(tundraDictionary[iRandNum]))
					resourceName = gc.getBonusInfo(gc.getInfoTypeForString(tundraDictionary[iRandNum])).getDescription()
			else:
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"), true, true)
				if (iRandNum == 0):
					iRandNum = gc.getGame().getMapRand().get(len(plainsDictionary), "Plains Dictionary Entry")
					pPlot.setBonusType(gc.getInfoTypeForString(plainsDictionary[iRandNum]))
					resourceName = gc.getBonusInfo(gc.getInfoTypeForString(plainsDictionary[iRandNum])).getDescription()
			pPlot.setImprovementType(-1)
		elif(iImprovement==desert):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_DESERT"), true, true)
			if (iRandNum == 0):
				iRandNum = gc.getGame().getMapRand().get(len(desertDictionary), "Desert Dictionary Entry")
				pPlot.setBonusType(gc.getInfoTypeForString(desertDictionary[iRandNum]))
				resourceName = gc.getBonusInfo(gc.getInfoTypeForString(desertDictionary[iRandNum])).getDescription()
			if((pPlot.isRiverSide()==1) and (pPlot.getPlotType()==PlotTypes.PLOT_LAND)):
				pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS"), 0)
			pPlot.setImprovementType(-1)
		elif(iImprovement==snow):
			if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_TUNDRA")):
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_SNOW"), true, true)
				if (iRandNum == 0):
					iRandNum = gc.getGame().getMapRand().get(len(snowDictionary), "Snow Dictionary Entry")
					pPlot.setBonusType(gc.getInfoTypeForString(snowDictionary[iRandNum]))
					resourceName = gc.getBonusInfo(gc.getInfoTypeForString(snowDictionary[iRandNum])).getDescription()
			else:
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_TUNDRA"), true, true)
				if (iRandNum == 0):
					iRandNum = gc.getGame().getMapRand().get(len(tundraDictionary), "Tundra Dictionary Entry")
					pPlot.setBonusType(gc.getInfoTypeForString(tundraDictionary[iRandNum]))
					resourceName = gc.getBonusInfo(gc.getInfoTypeForString(tundraDictionary[iRandNum])).getDescription()
			pPlot.setImprovementType(-1)
		elif(iImprovement==peak):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PEAK"), true, true)
			pPlot.setImprovementType(-1)
		elif(iImprovement==raiseelev):
			if(pPlot.getPlotType()==PlotTypes.PLOT_LAND):
				pPlot.setPlotType(PlotTypes.PLOT_HILLS, true, true)
				if(pPlot.getFeatureType()==gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS")):
					pPlot.setFeatureType(-1,0)
			else:
				pPlot.setPlotType(PlotTypes.PLOT_PEAK, true, true)
				pPlot.setRouteType(-1)
			pPlot.setImprovementType(-1)
		elif(iImprovement==lowerelev):
			if(pPlot.getPlotType()==PlotTypes.PLOT_LAND):
				numberofunits = pPlot.getNumUnits()
				while(numberofunits > 0):
					pPlot.getUnit(0).jumpToNearestValidPlot()
					numberofunits = pPlot.getNumUnits()
				# If we had oil before, put oil again after changing to water.
				# Note- oil graphic will keep previous plot elevation so it will appear a little high
				hadOil = false
				if (pPlot.getBonusType(0) == gc.getInfoTypeForString("BONUS_OIL")):
					hadOil = true
				pPlot.setPlotType(PlotTypes.PLOT_OCEAN, true, true)
				if (hadOil == true):
					pPlot.setBonusType(gc.getInfoTypeForString("BONUS_OIL"))
				if (iRandNum == 0):
					iRandNum = gc.getGame().getMapRand().get(len(coastDictionary), "Coast Dictionary Entry")
					pPlot.setBonusType(gc.getInfoTypeForString(coastDictionary[iRandNum]))
			else:
				pPlot.setPlotType(PlotTypes.PLOT_LAND, true, true)
				if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_DESERT") and pPlot.isRiver()):
                                        pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS"), 0)
			pPlot.setImprovementType(-1)
		elif(iImprovement==land):
                        pPlot.setImprovementType(-1)
			pPlot = CyMap().plot(iX-1,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("SouthWest(1)")
			pPlot = CyMap().plot(iX,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("South(2)")
			pPlot = CyMap().plot(iX+1,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("SouthEast(3)")
			pPlot = CyMap().plot(iX-1,iY)
			if(pPlot.isWater()==1):
				self.list.append("West(4)")
			pPlot = CyMap().plot(iX+1,iY)
			if(pPlot.isWater()==1):
				self.list.append("East(6)")
			pPlot = CyMap().plot(iX-1,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("NorthWest(7)")
			pPlot = CyMap().plot(iX,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("North(8)")
			pPlot = CyMap().plot(iX+1,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("NorthEast(9)")
			if(len(self.list) > 0):
				self.pPlot = CyMap().plot(iX,iY)
				CvCustomEventManager.CvCustomEventManager().beginEvent(7502)
		elif(iImprovement==jungle):
			pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_JUNGLE"), 1)
			if (iRandNum == 0):
				iRandNum = gc.getGame().getMapRand().get(len(jungleDictionary), "Jungle Dictionary Entry")
				pPlot.setBonusType(gc.getInfoTypeForString(jungleDictionary[iRandNum]))
			pPlot.setImprovementType(-1)
		elif(iImprovement==forest):
			pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FOREST"), 1)
			if (iRandNum == 0):
				iRandNum = gc.getGame().getMapRand().get(len(forestDictionary), "Forest Dictionary Entry")
				pPlot.setBonusType(gc.getInfoTypeForString(forestDictionary[iRandNum]))
			pPlot.setImprovementType(-1)

		CvUtil.pyPrint('Improvement %s was built at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))
		nearestCity = pPlot.getWorkingCity()
		if(resourceName!= "NONE"):
			if(nearestCity.isNone()):
				message = "%s was discovered at %s , %s." %(resourceName, iX, iY)
			else:
				nearestCityName = nearestCity.getName()
				message = "%s was discovered near %s." %(resourceName, nearestCityName)
			CyInterface().addImmediateMessage(message,"")
			CvUtil.pyPrint(message)

	def onRouteBuilt(self, argsList):
                'Route Built'
                iRoute, iX, iY = argsList
                pPlot = CyMap().plot(iX,iY)
		if(pPlot.getPlotType()==PlotTypes.PLOT_PEAK):
                        pPlot.setPlotType(PlotTypes.PLOT_HILLS, true, true)
                        pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PEAK"), true, true)
                        pPlot.setFeatureType(-1,0)
                CvUtil.pyPrint('Route %s was built at %d, %d' %(gc.getRouteInfo(iRoute).getDescription(), iX, iY))
                    
	def eventRemoveWaterBegin(self, argsList):
		popup = PyPopup.PyPopup(7502, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setHeaderString("What water would you like to make land?")
	    	popup.createPullDown()
		for i in range(0 , len(self.list)):
		     	popup.addPullDownString(self.list[i] , i)
		popup.addButton("Ok")
                CyCamera().JustLookAtPlot(self.pPlot)
		popup.launch(False, PopupStates.POPUPSTATE_IMMEDIATE)
		return

	def eventRemoveWaterApply(self, playerID, userData, popupReturn):
		if (popupReturn.getButtonClicked() == 0):
			direction = self.list[popupReturn.getSelectedPullDownValue(0)]
			ix = self.pPlot.getX()
			iy = self.pPlot.getY()
			if((direction == "SouthWest(1)") or (direction == "West(4)") or (direction == "NorthWest(7)")):
				ix = ix - 1
			if((direction == "SouthEast(3)") or (direction == "East(6)") or (direction == "NorthEast(9)")):
				ix = ix + 1
			if((direction == "SouthWest(1)") or (direction == "South(2)") or (direction == "SouthEast(3)")):
				iy = iy - 1
			if((direction == "NorthWest(7)") or (direction == "North(8)") or (direction == "NorthEast(9)")):
				iy = iy + 1
                        self.pPlot = CyMap().plot(ix,iy)
			# If we had oil before, put oil again after changing to land.
			# Note- oil graphic will keep previous plot elevation so it will be under the new land tile.
			hadOil = false
			if (self.pPlot.getBonusType(0) == gc.getInfoTypeForString("BONUS_OIL")):
				hadOil = true
			self.pPlot.setPlotType(PlotTypes.PLOT_LAND, true, true)
			self.pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"), true, true)
			if (hadOil == true):
				self.pPlot.setBonusType(gc.getInfoTypeForString("BONUS_OIL"))
			self.list = []
		return
