/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class GameSpeedTuner
extends JFrame
implements ActionListener {
    JPanel p = new JPanel(new BorderLayout());
    JPanel buttons = new JPanel(new GridLayout(4, 1));
    JPanel[] tabPanels;
    JTabbedPane tabs = new JTabbedPane();
    JButton apply = new JButton("Apply");
    JButton restore = new JButton("Restore");
    JButton runCiv = new JButton("Start Civ");
    JButton exit = new JButton("Exit");
    SpinnerNumberModel[][] models;
    int[][] allValues;

    public static void main(String[] stringArray) {
        GameSpeedTuner gameSpeedTuner = new GameSpeedTuner();
        gameSpeedTuner.setDefaultCloseOperation(3);
        gameSpeedTuner.readAndSetValues();
    }

    public GameSpeedTuner() {
        super("Gamespeed Tuner v1.0");
        int n;
        this.setBounds(300, 300, 450, 490);
        this.buttons.add(this.apply);
        this.buttons.add(this.restore);
        this.buttons.add(this.runCiv);
        this.buttons.add(this.exit);
        this.apply.addActionListener(this);
        this.restore.addActionListener(this);
        this.runCiv.addActionListener(this);
        this.exit.addActionListener(this);
        int n2 = this.getNumberOfSpeeds();
        this.tabPanels = new JPanel[n2];
        this.allValues = new int[4][11];
        this.models = new SpinnerNumberModel[4][11];
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 11; ++i) {
                this.models[n][i] = new SpinnerNumberModel(100, 10, 1000, 1);
            }
        }
        for (n = 3; n >= 0; --n) {
            this.tabPanels[n] = new JPanel(new GridLayout(11, 2));
            this.tabPanels[n].add(new JLabel(" City Growth:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][0]));
            this.tabPanels[n].add(new JLabel(" Unit construction:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][1]));
            this.tabPanels[n].add(new JLabel(" Building construction:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][2]));
            this.tabPanels[n].add(new JLabel(" Project construction:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][3]));
            this.tabPanels[n].add(new JLabel(" Research:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][4]));
            this.tabPanels[n].add(new JLabel(" Great People:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][5]));
            this.tabPanels[n].add(new JLabel(" Culture:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][6]));
            this.tabPanels[n].add(new JLabel(" Tile Improvement Rate:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][7]));
            this.tabPanels[n].add(new JLabel(" Barbarians:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][8]));
            this.tabPanels[n].add(new JLabel(" Inflation:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][10]));
            this.tabPanels[n].add(new JLabel(" General:"));
            this.tabPanels[n].add(new JSpinner(this.models[n][9]));
            String string = "Normal";
            if (n == 3) {
                string = "Quick";
            }
            if (n == 1) {
                string = "Epic";
            }
            if (n == 0) {
                string = "Marathon";
            }
            this.tabs.addTab(string, this.tabPanels[n]);
        }
        this.tabs.setSelectedIndex(2);
        this.p.add((Component)this.tabs, "North");
        this.p.add((Component)this.buttons, "South");
        this.getContentPane().add("Center", this.p);
        this.setVisible(true);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == "Apply") {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 11; ++j) {
                    this.allValues[i][j] = this.models[i][j].getNumber().intValue();
                }
            }
            object = new XmlEdit();
            ((XmlEdit)object).changeFile(this.allValues, "CIV4GameSpeedInfo.xml");
            JOptionPane.showMessageDialog(this, "The settings have been applied succesfully!", "Gamespeed Tuner 1.0 ", 1);
        }
        if (string == "Restore") {
            object = new XmlEdit();
            ((XmlEdit)object).fixFile("CIV4GameSpeedInfo.xml");
            this.readAndSetValues();
        }
        if (string == "Start Civ") {
            object = System.getProperty("user.dir");
            File file = new File((String)object);
            File file2 = file.getParentFile().getParentFile().getParentFile();
            String string2 = file2.getAbsolutePath();
            System.out.println(string2);
            try {
                Process process = Runtime.getRuntime().exec("cmd /c start /d \"" + string2 + "\" Civilization4.exe");
            }
            catch (Exception exception) {
                System.out.println("GameSpeed Tuner needs to be in your Civ IV\\Assets\\XML\\GameInfo folder for this button to work");
            }
        }
        if (string == "Exit") {
            System.exit(0);
        }
    }

    public void readAndSetValues() {
        int n;
        XmlRead xmlRead = new XmlRead("CIV4GameSpeedInfo.xml");
        int[] nArray = xmlRead.getValues(1);
        int[] nArray2 = xmlRead.getValues(2);
        int[] nArray3 = xmlRead.getValues(3);
        int[] nArray4 = xmlRead.getValues(4);
        for (n = 0; n < 11; ++n) {
            this.allValues[0][n] = nArray[n];
        }
        for (n = 0; n < 11; ++n) {
            this.allValues[1][n] = nArray2[n];
        }
        for (n = 0; n < 11; ++n) {
            this.allValues[2][n] = nArray3[n];
        }
        for (n = 0; n < 11; ++n) {
            this.allValues[3][n] = nArray4[n];
        }
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 11; ++i) {
                this.models[n][i].setValue(this.allValues[n][i]);
            }
        }
    }

    public int getNumberOfSpeeds() {
        XmlRead xmlRead = new XmlRead("CIV4GameSpeedInfo.xml");
        int n = xmlRead.speeds();
        return n;
    }

    public String[] getSpeedNames() {
        XmlRead xmlRead = new XmlRead("CIV4GameSpeedInfo.xml");
        String[] stringArray = xmlRead.getSpeedNames();
        return stringArray;
    }
}

