from CvPythonExtensions import *
import CvUtil
import PyHelpers		# LOQ
import Popup as PyPopup
import pickle			# LOQ 2005-10-12

# globals
gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer	# LOQ
PyInfo = PyHelpers.PyInfo

class TrainingBarracks:						
	def onBeginGameTurn(self, argsList):
		'Called at the beginning of a game turn'
		# change this number to alter the chance of getting an experiece point. A unit has 1 out of [this value] chance of getting an exp each turn
		# For example, if you set it to 10 a unit has a 1 in 10 chance of getting an exp point each turn. 
		#Setting it to 1 means units gain an exp point every turn (1 in 1 chance)
		barracksChance = 10
		drydockChance = 10
		# Units with exp higher than this number will not gain any more exp from a barracks or drydock.
		barracksMaxExp = 10
		drydockMaxExp = 10
		iPlayer = argsList
		if (barracksChance < 1):
			barracksChance = 1
		if (barracksMaxExp < 1):
			barracksMaxExp = 1
		if (drydockChance < 1):
			drydockChance = 1
		if (drydockMaxExp < 1):
			drydockMaxExp = 1
		for iPlayer in range(gc.getMAX_PLAYERS()):
			pPlayer = gc.getPlayer(iPlayer)
			if ((pPlayer.isAlive()) or (pPlayer.isBarbarian())):
				for iCity in range(pPlayer.getNumCities()):
					pCity = pPlayer.getCity(iCity)
					if pCity.hasBuilding(gc.getInfoTypeForString('BUILDING_BARRACKS')):
						for iUnit in range(pCity.plot().getNumUnits()):
							pUnit = pCity.plot().getUnit(iUnit)
							uType = pUnit.getUnitCombatType()
							if ( (uType != gc.getInfoTypeForString("UNITCOMBAT_NAVAL")) and (uType > gc.getInfoTypeForString("NO_UNITCOMBAT")) ): # Naval units don't get the barracks bonus
								if (pUnit.getOwner() == pCity.getOwner()):
									if (pUnit.getExperience() < barracksMaxExp):
										iRandNum = gc.getGame().getMapRand().get(barracksChance, "Barracks Training")
									if (iRandNum == 0):
										pUnit.changeExperience(1, barracksMaxExp)
					if pCity.hasBuilding(gc.getInfoTypeForString('BUILDING_DRYDOCK')):
						for iUnit in range(pCity.plot().getNumUnits()):
							pUnit = pCity.plot().getUnit(iUnit)
							uType = pUnit.getUnitCombatType()
							if ( (uType == gc.getInfoTypeForString("UNITCOMBAT_NAVAL")) and (uType > gc.getInfoTypeForString("NO_UNITCOMBAT")) ): # Only Naval units get the drydock bonus
								if (pUnit.getOwner() == pCity.getOwner()):
									if (pUnit.getExperience() < drydockMaxExp):
										iRandNum = gc.getGame().getMapRand().get(drydockChance, "Drydock Training")
										if (iRandNum == 0):
											pUnit.changeExperience(1, drydockMaxExp)