## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## 
## author : 12 Monkeys - Tool Collection
## date : 12.12.2005
## version : 1.0
##

from CvPythonExtensions import *
import CvUtil
import PyHelpers

PyPlayer = PyHelpers.PyPlayer

###########################
### 	Class to Re-Init Interceptor Mission 
###########################

class ReInitInterceptorMision:

	def __init__(self):
		self.firsttime = true

	def doReInit(self):
		iPlayer = PyPlayer(CyGame().getActivePlayer())
		unitList = iPlayer.getUnitList()
		# Loop for all players cities
		for ii in range(len(unitList)):
			pLoopUnit = unitList[ii]
			# get the group the unit belongs to. 
			pGroup = pLoopUnit.getGroup()
			# check if unit is doing air patrol
			if (pGroup.getActivityType() == ActivityTypes.ACTIVITY_INTERCEPT):
				# remove mission (this one shold be obsolete, but who knows ;)
				pGroup.popMission()
				pPlot = pGroup.plot()
				# add new mission -> fortify
				pGroup.pushMission(MissionTypes.MISSION_FORTIFY, 0, 0, 0, false, false, MissionAITypes.NO_MISSIONAI, pPlot, pLoopUnit)
				# add new mission -> air patrol
				pGroup.pushMission(MissionTypes.MISSION_AIRPATROL, 0, 0, 0, false, false, MissionAITypes.NO_MISSIONAI, pPlot, pLoopUnit)



###########################
### 	END 
###########################
