## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## DataStorage by Bhruic
##
## Based on sdToolKit by Stone-D (Laga Mahesa)
## Copyright Laga Mahesa 2005

from CvPythonExtensions import *
import CvUtil
import sys
import cPickle as pickle
	
gc = CyGlobalContext()

def initStorage(ModID, pEntity):
	try:
		cyTable = pickle.loads(pEntity.getScriptData())
	except:
		cyTable = {}
	if (not cyTable.has_key(ModID)):
		cyTable[ModID] = pickle.dumps({})
	pEntity.setScriptData(pickle.dumps(cyTable))
	return 1

def loadModData(ModID, pEntity):
	initStorage(ModID, pEntity)
	cyTable = pickle.loads(pEntity.getScriptData())
	return pickle.loads(cyTable[ModID])

def saveModData(ModID, mTable, pEntity):
	cyTable = pickle.loads(pEntity.getScriptData())
	cyTable[ModID] = pickle.dumps(mTable)
	pEntity.setScriptData(pickle.dumps(cyTable))
	return 1

def initKey(ModID, key, eTable, pEntity):
	mTable = loadModData(ModID, pEntity)
	mTable[key] = pickle.dumps(eTable)
	saveModData(ModID, mTable, pEntity)
	return 1

def delKey(ModID, key, pEntity):
	mTable = loadModData(ModID, pEntity)
	if (mTable.has_key(key)):
		del mTable[key]
		saveModData(ModID, mTable, pEntity)
		return 1
	else:
		return 0

def hasKey(ModID, key, pEntity):
	mTable = loadModData(ModID, pEntity)
	return mTable.has_key(key)
		
def getVal(ModID, key, var, pEntity):
	mTable = loadModData(ModID, pEntity)
	eTable = pickle.loads(mTable[key])
	return eTable[var]

def setVal(ModID, key, var, val, pEntity):
	mTable = loadModData(ModID, pEntity)
	if (mTable.has_key(key)):
		eTable = pickle.loads(mTable[key])
		eTable[var] = val
		mTable[key] = pickle.dumps(eTable)
		saveModData(ModID, mTable, pEntity)
		return 1
	else:
		return 0
