## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## ResearchProgress by Bhruic
##

from CvPythonExtensions import *
import CvUtil
import DataStorage

# globals
gc = CyGlobalContext()
initKey = DataStorage.initKey
hasKey = DataStorage.hasKey
setVal = DataStorage.setVal
getVal = DataStorage.getVal

class ResearchProgress:
	def getResearchPoints(self, iPlayer):
		iResearchPoints = 0
		pTeam = gc.getTeam(gc.getPlayer(iPlayer).getTeam())
		for iTech in range(gc.getNumTechInfos()):
			if (pTeam.isHasTech(iTech)):
				iResearchPoints += pTeam.getResearchCost(iTech)
			elif (pTeam.getResearchProgress(iTech) > 0):
				iResearchPoints += pTeam.getResearchProgress(iTech)
		return iResearchPoints

	def getResearchHistory(self, iPlayer, iTurn):
		try:
			iRet = getVal('ResearchProgress', str(iTurn), 'ResearchPoints', gc.getPlayer(iPlayer))
		except:
			iRet = 0
		return iRet
		
	def onBeginGameTurn(self, argsList):
		iGameTurn = argsList[0]
		for iPlayer in range(gc.getMAX_PLAYERS()):
			if (gc.getPlayer(iPlayer).isEverAlive()):
				vTable = {
					'ResearchPoints' : 0
				}
				if (not hasKey('ResearchProgress', str(iGameTurn), gc.getPlayer(iPlayer))):
					initKey('ResearchProgress', str(iGameTurn), vTable, gc.getPlayer(iPlayer))
				iResearchPoints = self.getResearchPoints(iPlayer)
				setVal('ResearchProgress', str(iGameTurn), 'ResearchPoints', iResearchPoints, gc.getPlayer(iPlayer))
			
		