from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup
import CvCameraControls
			
# globals
gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer

class AbandonRazeDemolish:
	def __init__(self):
		self.EventKeyDown=6
		
	def onKbdEvent(self, argsList, bCtrl):
		eventType,key,mx,my,px,py = argsList
		self.bCtrl = bCtrl
		if ( eventType == self.EventKeyDown ):
			theKey=int(key)
			CvCameraControls.g_CameraControls.handleInput( theKey )
			'Check if city screen is active'
			if ( CyInterface().isCityScreenUp() ):
				'Check if CTRL + X was hit'
				if(theKey == int(InputTypes.KB_X) and self.bCtrl):
					'Make sure the owner is the player!'
					if (CyInterface().getHeadSelectedCity().getOwner() == gc.getGame().getActivePlayer()):
						return 1
		return 0
									
	def eventDestroyBuildingBegin(self, argsList):
		pHeadSelectedCity = CyInterface().getHeadSelectedCity()
		popup = PyPopup.PyPopup(7500, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setHeaderString("Choose building to demolish")
		popup.createPullDown()
		for i in range( gc.getNumBuildingInfos() ):
			if (i > 0 and pHeadSelectedCity.hasBuilding(i) and not isWorldWonderClass(gc.getBuildingInfo(i).getBuildingClassType())):
				popup.addPullDownString(gc.getBuildingInfo(i).getDescription() , i)
		popup.addPullDownString('Abandon City', i+1)
		popup.addButton("Ok")
		popup.addButton("Cancel")
		popup.launch(False, PopupStates.POPUPSTATE_IMMEDIATE)
		return

	def eventDestroyBuildingApply(self, playerID, userData, popupReturn):             
		if (popupReturn.getButtonClicked() == 0):
			if (popupReturn.getSelectedPullDownValue(0) == gc.getNumBuildingInfos() ):
				pHeadSelectedCity = CyInterface().getHeadSelectedCity()
				ix = pHeadSelectedCity.getX()
				iy = pHeadSelectedCity.getY()
				ipopulation = CyInterface().getHeadSelectedCity().getPopulation()
				Player = gc.getPlayer(playerID)
				pHeadSelectedCity.kill()
				CyAudioGame().Play2DSound("AS2D_DISCOVERBONUS")
				if (ipopulation > 4):
					iworkers = ipopulation/5
					for i in range(0,iworkers):
						Player.initUnit(5, ix, iy, UnitAITypes.NO_UNITAI)
			else:
                		iBuildingType = popupReturn.getSelectedPullDownValue(0)
				CyInterface().getHeadSelectedCity().setHasRealBuilding(iBuildingType, False)                 
				CyAudioGame().Play2DSound("AS2D_DISCOVERBONUS")
				CyInterface().setDirty(InterfaceDirtyBits.CityScreen_DIRTY_BIT, True)
				CyInterface().setDirty(InterfaceDirtyBits.SelectionButtons_DIRTY_BIT, True) 
		return

	def onCityRazed(self, argsList):
		'City Razed'
		city, iPlayer = argsList	
		owner = PyPlayer(city.getOwner())
		razor = PyPlayer(iPlayer)
		ipopulation = city.getPopulation()
		if (ipopulation > 4):
			iworkers = ipopulation/5
			for i in range(0,iworkers):
				razor.initUnit(5, city.plot().getX(), city.plot().getY(), UnitAITypes.NO_UNITAI)
				CvUtil.pyPrint('Player %d Civilization %s City %s was razed by Player %d' %(owner.getID(), owner.getCivilizationName(), city.getName(), razor.getID()))
				CvUtil.pyPrint("City Razed Event: %s" %(city.getName(),))
