/*************************************************************************************************************
SCENARIO NAME: Test save game
VERSION: 0.1
DATE: 02/01/2001 (Happy new year! ;o))
AUTHOR: Angelo Scotto
E-MAIL: scotto_a@hotmail.com
MISC: <Place miscellaneous information here>
*************************************************************************************************************/

#include "cspl.h"
#include "csplclient.h"
#include <stdlib.h>

/*********************************************************************************************************************************
USER DEFINITIONS:APPLY HERE YOUR CHANGES
*********************************************************************************************************************************/

		void UnitCheck(Unit Temp)
			{
			/*******************************************************************
			LINK MAPS EAST-WEST
			*******************************************************************/
			/*******************************************************************
			How this section works:
			for each unit CSPL check its x position; if it is on a border it 
			changes the z coordinate (pointing on the right map) and changes the 
			x position (if it was LEFTBORDER it became RIGTHBORDER and viceversa)
			*******************************************************************/
			if (Temp.pos.x==1 || Temp.pos.x==0) MoveLeft(Temp); //If x coordinate is 0 or 1 (left border), call MoveLeft procedure
			else
			if (Temp.pos.x==80-1 || Temp.pos.x==80-2) MoveRight(Temp);//If x coordinate is 78 or 79 (right border), call MoveRight procedure
			/*******************************************************************
			EVENTS TRIGGERED BY ENTERING IN A PARTICULAR SQUARE
			*******************************************************************/
			/*******************************************************************
			How this section works:
			for each unit CSPL check its position; if it is at (10,10,0) and no one
			has discovered the tresaure (Discovered==false) it shows a messagebox
			and increase unit civilization tresaury of 3000
			*******************************************************************/
			if (Temp.pos.x==10 && Temp.pos.y==10  && Temp.pos.z==0 && Discovered==false && Temp.Owner==CIV_WHITE)//If pos is (10,10,MAP0) and the tresaure is still hidden and unit owner is white civ
				{	MessageCSPL("Your military unit discovered an underground passage\nexploring it your men discover an enormous quantity of wealth (3000 credits!)");
					Civ Prova;//Creates a temporary Civ structure to access Unit owner civilization
					CivID(Temp.Owner,&Prova);//Write in Prova civ structure all infos about unit owner civilization using CivID function
					Prova.Money=Prova.Money+3000;//Increase Civ money of 3000;
					ReWriteCiv(Prova,Temp.Owner);//Write back changes to Tot memory
					Discovered=true;//Turn on Discovered FLAG to avoid multiple tresaury discoveries
				}

}
		void MoveLeft(Unit Temp)
			{Temp.pos.z=1-Temp.pos.z; //Change map
				if (Temp.pos.x==0)
					Temp.pos.x=80-4; //Change x coord
				if (Temp.pos.x==1)
					Temp.pos.x=80-3; //Change x coord
				WriteUnit(Temp);		 //Write back unit
				RefreshMap();		 //Refresh Screen
}
		void MoveRight(Unit Temp)
			{Temp.pos.z=1-Temp.pos.z; //Change map
				if (Temp.pos.x==80-1)
					{Temp.pos.x=3;} 	 //Change x coord
				if (Temp.pos.x==80-2)
					{Temp.pos.x=2;}	 //Change x coord
				WriteUnit(Temp);		 //Write back unit
				RefreshMap();		 //Refresh Screen
}

void CityCheck(City Temp)
{
	/*******************************************************************
	How this section works:
	for each city CSPL check if it is building warriors without barracks
	and if the city is owned by white civ (this to avoid the messagebox
	each time computer builds warriors without barracks) and if this happens
	quickly convert its production to NOTHING forcing the user to select 
	something else to build Improve&4
	*******************************************************************/
	if (!(Temp.Improve[0]&IMPROVE_BARRACKS) && Temp.ItemProduction==UNIT_WARRIOR && Temp.Owner==CIV_WHITE)//If City has not barracks (!(Temp.Improve[0]&4)) and 
										    //city is building warrior (Temp.ItemProduction==2) and
								      		    //city owner is white civ (Temp.Owner==CIV_WHITE)
		{
			MessageCSPL("Warning! You cannot build a warrior in a city without a Barrack!");
			Temp.ItemProduction=0xFF;//Change production to nothing
			WriteCity(Temp);//Writeback changes
		}
}
void WonderCheck()
{/*Add your wonder event here*/}
void MapCheck()
{/*Add your map event here*/}
void GlbCheck(Global Glb)
{if (TransformUnit)
{//If TransformUnit FLAG is true
	/*******************************************************************
	How this section works:
	Each time the user press 'e' key TransforUnit FLAG is raised, and 
	this piece of code is executed:
	it detects if any unit is selected and if this unit is a settler change 
	its type to engineer while if its type is engineer changes it to settler
	*******************************************************************/
	Unit Temp;//Create a temporary Unit slot
	if (Glb.UnitSelected && UnitID(Glb.IDUnitSelected,&Temp))//If a unit is currently selected write unit infos in Temp unit slot
		{if (Temp.Type==UNIT_SETTLER)//If this unit is a settler
			Temp.Type=UNIT_ENGINEER;//Set unit type as engineer
		else {if (Temp.Type==UNIT_ENGINEER)//else If this unit is an engineer
			Temp.Type=UNIT_SETTLER;}//Set unit type as settler
		ReWriteUnit(Temp,Temp.ID);//Write back unit
		Refresh();//Update screen to show changes
		}

}
TransformUnit=false;//Lower TransformUnit FLAG
}
void CivCheck(Civ Prova)
{/*Add your Civ event here*/}
void AttackCheck(Unit* Attacker,Unit* Attacked,BOOL Winner)
{/*Add your Attack event here*/}
void KeyboardCheck(char keypressed)
{
	if (keypressed=='e')//If user pressed 'e' key
		{TransformUnit=true;}//Raise TransformUnit FLAG to allow change of unit type
}

/*********************************************************************************************************************************
STANDARD TEMPLATE:USUALLY CSPL PROGRAMS DON`T NEED TO CHANGE THIS SECTION
*********************************************************************************************************************************/

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPTSTR lpCmdLine,int nCmdShow)
{MainInstance=hInstance;

static char szAppName [] = "CSPL";
MSG msg;
HWND hWnd;
WNDCLASS wndclass;

	wndclass.style=CS_HREDRAW|CS_VREDRAW;
	wndclass.lpfnWndProc=WndProc;
	wndclass.cbClsExtra=0;
	wndclass.cbWndExtra=0;
	wndclass.hInstance=MainInstance;
	wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon=LoadIcon(MainInstance,MAKEINTRESOURCE(IDCSPL));
	wndclass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU1);
	wndclass.hbrBackground=(HBRUSH
	)GetStockObject(LTGRAY_BRUSH);
	wndclass.lpszClassName=szAppName;

	if (!RegisterClass (&wndclass))
		return FALSE;

	hWnd=CreateWindowEx(WS_EX_TOPMOST,szAppName,TitoloCSPL,WS_CAPTION|WS_SYSMENU,XWindow,YWindow,Width,Height,NULL,NULL,MainInstance,NULL);


	if (!hWnd) return FALSE;



	ShowWindow(hWnd,nCmdShow);
	UpdateWindow(hWnd);
	InitializeCSPL();

while (GetMessage(&msg,NULL,0,0))
{TranslateMessage(&msg);
DispatchMessage(&msg);
}	
return (msg.wParam);

}

LRESULT CALLBACK WndProc(HWND hWnd,UINT imessage, WPARAM wParam,LPARAM lParam)
{switch (imessage)
	{case WM_CLOSE:
	{DestroyWindow(hWnd);return 0;break;}
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case ID_MAIN_EXIT: {DestroyWindow(hWnd);return 0;break;}
		case ID_MAIN_ABOUT: AboutBox();return 1;break;
		case ID_MAIN_ABOUTSCN: AboutScn();return 1;break;
		}return DefWindowProc(hWnd,imessage,wParam,lParam);break;
	case WM_CHAR:
		if (wParam=='x') {DestroyWindow(hWnd);return 0;break;}
			else {KeyboardCheck(wParam);return 0;break;}
		//if (wParam=='e') {TransformUnit();
	case WM_DESTROY:
		CloseHandle(Process);ExitProcess(0);return 0;break;
	default:return DefWindowProc(hWnd,imessage,wParam,lParam);break;
	}
}

BOOL MessageCSPL(LPCSTR Testo)
{
	MSGBOXPARAMS MBP;

	MBP.cbSize=sizeof(MSGBOXPARAMS);
	MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=Testo; 
    MBP.lpszCaption="CSPL Version 1.0"; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

return	MessageBoxIndirect(&MBP);

}

int RequestCSPL(LPCSTR Testo)
{
	MSGBOXPARAMS MBP;

	MBP.cbSize=sizeof(MSGBOXPARAMS);
	MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=Testo; 
    MBP.lpszCaption="CSPL Version 1.0"; 
    MBP.dwStyle=MB_USERICON | MB_YESNO; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

return	MessageBoxIndirect(&MBP);

}
void AboutBox()
{
	MSGBOXPARAMS MBP;

	MBP.cbSize=sizeof(MSGBOXPARAMS);
	MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText="Civilization Scenario Programming Library\n\nVersion 1.0\nby Angelo Scotto\ne-mail:scotto_a@hotmail.com\nCopyright (C) 2000"; 
    MBP.lpszCaption="About CSPL"; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

	MessageBoxIndirect(&MBP);
}

void AboutScn()
{
	MSGBOXPARAMS MBP;

	MBP.cbSize=sizeof(MSGBOXPARAMS);
	MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=AuthorString;
	MBP.lpszCaption="About Scenario"; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

	MessageBoxIndirect(&MBP);
}