## Sid Meier's Civilization 4
from CvPythonExtensions import *
import PyHelpers
import CvUtil
import ScreenInput
import CvScreenEnums
import string

PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

class CvGreatPersonScreen:
	"Great Person Screen"
	
	def __init__(self):
		self.iMarginSpace = 15
		
		self.Z_BACKGROUND = -1.1
		self.Z_CONTROLS = self.Z_BACKGROUND - 0.2
		
		self.X_SCREEN = 205
		self.Y_SCREEN = 27
		self.W_SCREEN = 1024
		self.H_SCREEN = 768
		
		self.X_MAIN_PANEL = 0
		self.Y_MAIN_PANEL = 0
		self.W_MAIN_PANEL = 775
		self.H_MAIN_PANEL = 735
		
		self.X_TITLE = self.X_MAIN_PANEL + (self.W_MAIN_PANEL / 2)
		self.Y_TITLE = self.Y_MAIN_PANEL + 12
		
		self.X_PORTRAIT = self.X_MAIN_PANEL + 27
		self.Y_PORTRAIT = self.Y_MAIN_PANEL + 50
		self.W_PORTRAIT = 720
		self.H_PORTRAIT = 540
		
		self.X_EXIT = self.X_MAIN_PANEL + (self.W_MAIN_PANEL / 2) - 55
		self.Y_EXIT = self.Y_MAIN_PANEL + self.H_MAIN_PANEL - 45
		self.W_EXIT = 120
		self.H_EXIT = 30
		
		self.W_QUOTE = int(self.W_MAIN_PANEL * 0.75)
		self.H_QUOTE = 70
		
		self.X_QUOTE = self.X_MAIN_PANEL + (self.W_MAIN_PANEL - self.W_QUOTE) / 2
		self.Y_QUOTE = self.Y_EXIT - self.H_QUOTE - self.iMarginSpace
		
		self.PICTURE_BASE = "Art/GreatPeople/%s.dds"
	
	
	
	def interfaceScreen (self, pUnit, pCity):
		szPersonKey = pUnit.getNameKey()
		szPersonName = pUnit.getNameNoDesc()
		
		szQuoteKey = str("TXT_KEY_GREAT_PERSON_QUOTE_%s" %(szPersonKey.upper()))		
		szPicturePath = str(self.PICTURE_BASE %(szPersonKey.lower()))
		
		szHeaderId = "GreatPersonTitleHeader"
		szHeader = localText.getText("TXT_KEY_MISC_GP_BORN", (szPersonName, pCity.getName()))
		
		# Create Screen:
		screen = CyGInterfaceScreen( "GreatPersonScreen", CvScreenEnums.ERA_MOVIE_SCREEN)
		screen.showWindowBackground(False)
		screen.setRenderInterfaceOnly(False)
		screen.setSound("AS2D_NEW_ERA")
		screen.setDimensions(self.X_SCREEN, self.Y_SCREEN, self.W_SCREEN, self.H_SCREEN)
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)
		
		# Add Main Panel:
		screen.addPanel("GreatPersonPanel", "", "", true, true,
					self.X_MAIN_PANEL, self.Y_MAIN_PANEL, self.W_MAIN_PANEL, self.H_MAIN_PANEL, PanelStyles.PANEL_STYLE_MAIN)
        
		# Title
		screen.setLabel(szHeaderId, "Background", u"<font=4>" + szHeader + u"</font>", CvUtil.FONT_CENTER_JUSTIFY,
					self.X_TITLE, self.Y_TITLE, self.Z_CONTROLS, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		# Exit button:
		screen.setButtonGFC("GreatPersonExit", localText.getText("TXT_KEY_SCREEN_CONTINUE", ()), "",
					self.X_EXIT, self.Y_EXIT, self.W_EXIT, self.H_EXIT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD)
		
		# Portrait of Great Person:
		screen.addDDSGFC("GreatPersonPortrait", szPicturePath,
					self.X_PORTRAIT, self.Y_PORTRAIT, self.W_PORTRAIT, self.H_PORTRAIT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		
		# Great Person Quote:
		szQuotePanel = "GreatPersonQuotePanel"
		screen.addPanel(szQuotePanel, "", "", true, true,
					self.X_QUOTE, self.Y_QUOTE, self.W_QUOTE, self.H_QUOTE, PanelStyles.PANEL_STYLE_IN)
		screen.attachMultilineText(szQuotePanel, "Text", self.getQuoteFor(szQuoteKey), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)
		
		return 0
	
	
	def getQuoteFor (self, szQuoteKey):
		'Returns the quote for the great person'
		szQuote = localText.getText(szQuoteKey, ())
		
		if szQuote and (len(szQuote) > 0):
			return szQuote
		else:
			return 'There is no quote for this great person. :('
	
	
	# Will handle the input for this screen...
	def handleInput (self, inputClass):
		return 0

	def update(self, fDelta):
		return

