## Sid Meier's Civilization 4
## 
## CvGreatPersonEventManager
## This class is passed an argsList from CvAppInterface.onEvent
## The argsList can contain anything from mouse location to key info
## The EVENTLIST that are being notified can be found 

from CvPythonExtensions import *
import CvUtil
import PyHelpers
import CvEventManager
import CvGreatPersonScreen
import sys

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer

# globals
###################################################
class CvGreatPersonEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)
		
		# Make me a copy of the great person screen creation utility:
		self.greatPersonScreen = CvGreatPersonScreen.CvGreatPersonScreen()

	def onGreatPersonBorn(self, argsList):
		'Great Person Born'
		pUnit, iPlayer, pCity = argsList
		player = PyPlayer(iPlayer)
		
		# Tell parent:
		self.parent.onGreatPersonBorn(self, argsList)
		
		# Check if we should even show the popup:
		if pUnit.isNone() or pCity.isNone():
			return
		
		#Show fancy lil popup if *we* got the great person:
		iActivePlayer = CyGame().getActivePlayer()
		if iActivePlayer == iPlayer:
			self.greatPersonScreen.interfaceScreen(pUnit, pCity)
