#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "..\\gs\\slic\\slic.y"
/*----------------------------------------------------------------------------*/
/**/
/* Project      : Call To Power 2*/
/* File type    : C++ source*/
/* Description  : Defines what valid slic syntax is.*/
/*                This file slic.y is compiled to y.tab.c*/
/*                and therefore you find this text in both files.*/
/**/
/*----------------------------------------------------------------------------*/
/**/
/* Disclaimer*/
/**/
/* THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.*/
/**/
/* This material has been developed at apolyton.net by the Apolyton CtP2 */
/* Source Code Project. Contact the authors at ctp2source@apolyton.net.                                                              */
/**/
/*----------------------------------------------------------------------------*/
/*                                                                                                                                                                         */
/* Compiler flags*/
/*                                            */
/* ACTIVISION_ORIGINAL		*/
/* - When defined, generates the original Activision code.*/
/* - When not defined, generates the modified Apolyton code.*/
/**/
/*----------------------------------------------------------------------------*/
/**/
/* Modifications from the original Activision code:*/
/**/
/* - Addtion by Martin Ghmann to allow:*/
/*   - Slic database access                                                                            */
/*   - Slic database size access*/
/* - Exponetiation operator '**' added.*/
/**/
/*----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "slicif.h"

/* Avoid silly warnings */
#pragma warning( disable : 4013 )
#define lint

void yyerror(char* err);

#ifdef _DEBUG
FILE *debuglog;
#endif

int slic_parser_done = 0;
int slic_parse_error;

char slic_parser_error_text[1024];
char *include_filename_stack[MAX_INCLUDE_DEPTH];

int include_stack_ptr = 0;

#line 63 "..\\gs\\slic\\slic.y"
typedef union {
	int val;
	char* name;
    char* text;
	void *dbptr;
} YYSTYPE;
#line 73 "..\\gs\\slic\\y.tab.c"
#define NAME 257
#define STRINGID 258
#define IDENTIFIER 259
#define KW_MESSAGEBOX 260
#define KW_ALERTBOX 261
#define KW_TRIGGER 262
#define KW_WHEN 263
#define KW_IF 264
#define KW_BUTTON 265
#define KW_REGION 266
#define KW_ON 267
#define KW_HELPBOX 268
#define KW_ELSE 269
#define KW_ELSEIF 270
#define KW_WHILE 271
#define KW_FOR 272
#define NUMBER 273
#define GT 274
#define LT 275
#define GTE 276
#define LTE 277
#define EQ 278
#define REF 279
#define AND 280
#define OR 281
#define END_OF_INPUT 282
#define STRING 283
#define KW_ONCLOSE 284
#define KW_UNIT 285
#define KW_CITY 286
#define KW_LOCATION 287
#define KW_INT 288
#define KW_ARMY 289
#define KW_FUNCTION 290
#define KW_VOID 291
#define KW_RETURN 292
#define KW_INT_FUNC 293
#define KW_VOID_FUNC 294
#define KW_CONST 295
#define KW_HANDLEEVENT 296
#define KW_PRE 297
#define KW_POST 298
#define KW_EVENT 299
#define DBREF 300
#define EXP 301
#define NEQ 302
#define UMINUS 303
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    1,    1,    2,    2,    2,    2,    2,    2,    2,
    2,    7,    7,    7,   10,   10,   13,    3,   14,    3,
   15,    3,   16,    4,   18,    4,   20,   21,    5,   22,
   23,    5,   19,   19,    6,   25,    6,   26,   24,   24,
   27,    9,    8,   28,   28,   29,   29,   29,   30,   11,
   11,   11,   11,   11,   32,   12,   33,   12,   31,   31,
   37,   35,   35,   35,   35,   35,   34,   34,   34,   39,
   41,   34,   42,   34,   34,   43,   44,   45,   46,   34,
   47,   34,   34,   40,   48,   40,   40,   36,   36,   36,
   49,   49,   49,   49,   17,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   50,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   52,   51,
};
short yylen[] = {                                         2,
    2,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    3,    5,    6,    5,    6,    0,    4,    0,    4,
    0,    4,    0,    6,    0,    8,    0,    0,    8,    0,
    0,    9,    1,    1,   12,    0,    6,    0,    4,    1,
    2,    5,    5,    1,    1,    1,    3,    0,    2,    1,
    1,    1,    1,    1,    0,    4,    0,    3,    1,    2,
    0,    5,    3,    6,    5,    8,    2,    5,    2,    0,
    0,    8,    0,    6,    3,    0,    0,    0,    0,   13,
    0,    8,    1,    2,    0,    7,    0,    1,    3,    0,
    1,    1,    1,    1,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    2,
    2,    3,    1,    1,    0,    5,    3,    1,    3,    3,
    4,    6,    4,    6,    3,    0,    5,
};
short yydefred[] = {                                      0,
    0,    0,    0,    0,    0,   50,   53,   54,   52,   51,
   44,   45,    0,    0,    0,    0,    3,    4,    5,    6,
    7,    8,    9,   10,   11,    0,    0,    0,   17,   19,
    0,    0,   21,    0,    0,    1,    2,    0,    0,   41,
    0,    0,    0,    0,    0,   36,    0,    0,    0,   12,
    0,    0,    0,   46,    0,   18,   20,    0,    0,    0,
    0,   22,    0,    0,    0,    0,    0,   49,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   15,    0,
    0,    0,    0,   13,   42,   43,   47,    0,   70,    0,
   73,    0,    0,    0,    0,   83,    0,    0,    0,   58,
    0,  113,    0,    0,    0,    0,    0,    0,   24,    0,
    0,    0,   37,   16,   33,   34,   28,    0,   14,    0,
    0,    0,   61,    0,    0,    0,   76,   69,    0,    0,
   56,   60,   67,    0,  115,    0,    0,  111,  110,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   31,    0,    0,    0,    0,    0,    0,    0,    0,   75,
    0,  117,  120,    0,    0,    0,  125,    0,  112,    0,
    0,    0,    0,    0,    0,    0,   99,    0,    0,    0,
   98,  100,  101,  119,   26,    0,   39,   29,    0,    0,
    0,   93,   92,   94,    0,    0,    0,    0,    0,    0,
    0,   81,    0,    0,    0,    0,    0,   32,    0,    0,
    0,   62,    0,    0,   68,    0,   77,    0,  116,  127,
    0,    0,    0,    0,    0,   89,   71,   74,    0,    0,
  122,  124,    0,    0,    0,    0,    0,   35,    0,    0,
    0,   72,   78,   82,   84,    0,    0,    0,    0,    0,
   79,   85,    0,    0,   80,   86,
};
short yydgoto[] = {                                      15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   56,   41,   42,   47,   43,   74,   44,  117,   81,
  160,   82,  199,   78,   61,  112,   27,   28,   53,   54,
   97,   71,   72,   98,   99,  205,  165,  206,  124,  252,
  245,  126,  169,  239,  257,  263,  228,  264,  207,  174,
  108,  136,
};
short yysindex[] = {                                    685,
 -174, -148, -143, -135, -133,    0,    0,    0,    0,    0,
    0,    0, -129,   89,    0,  670,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -127,   91, -123,    0,    0,
    0,  -24,    0,   75, -119,    0,    0,  -11,  -74,    0,
   18,   18, -120, -122, -124,    0,   18,  -41,   99,    0,
  -79, -113,   11,    0,    0,    0,    0,  111, -130,  110,
 -102,    0,   98, -115,    0,   66,  104,    0,  -31,  -74,
  630,   40,  -27,   18,  -96, -105,    0,  113,    0,  114,
 -196,  -90,  115,    0,    0,    0,    0,   23,    0,  130,
    0,  138,   18,  -27,  122,    0,   57,  630,  125,    0,
  -35,    0,  146,  -27,  -27,  -27,   32,  -92,    0,  111,
  144,  149,    0,    0,    0,    0,    0, -196,    0,  -68,
  -27,  -27,    0,  156,  -61,  158,    0,    0,   61,  -58,
    0,    0,    0,  -34,    0,  112,  -30,    0,    0,   76,
  -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,  -27,
  -27,  -27,  -27,  -27,    0,  -56,   18,  -71, -102,   18,
    0,  143,   90,  409,  -33,  -27,  166,  -27,  -48,    0,
  176,    0,    0,  -33,  -27,  -32,    0,  105,    0,   -1,
   -1,   -1,   -1,   -1,  438,  438,    0,   -1,    3,    3,
    0,    0,    0,    0,    0,  173,    0,    0,   18,  -27,
  -59,    0,    0,    0,  177,  409,  175,  119,   18,  134,
  162,    0,  187,  148,  -43,  -37,  -42,    0,  409,  -19,
  -27,    0,  -33,   18,    0,   18,    0,  -33,    0,    0,
   -9,   -8,  152,  190,  409,    0,    0,    0,  -27,  211,
    0,    0,  199,  -27, -145,  163,  202,    0,  409,   18,
  231,    0,    0,    0,    0,  -27,  -48,  192,  233,   18,
    0,    0,   18, -145,    0,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -214,    0,    0,    0,    0,    0,    0,    0,   55,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  317,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -203,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -16,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  147,    0,    0,
  -21,    0,    0,    0,    0,    0,    0,  -12,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   -2,  234,    0,    0,    0,    0,    0,
    0,    0,    0,  234,    0,  240,    0,    0,    0,  418,
  447,  478,  486,  494,  451,  464,    0,  517,  360,  389,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   68,  235,    0,    0,    0,
    0,    0,    0,    0,   17,   46,    0,    0,   27,    0,
    0,    0,  234,    0,    0,    0,    0,  234,    0,    0,
    0,    0,    0,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  604,    0,    0,    0,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  604,    0,    0,
};
short yygindex[] = {                                      0,
    0,  262,    0,    0,    0,    0,  -20,    0,    0,    0,
   -5,  578,    0,    0,    0,    0,  169,    0,  168,    0,
    0,    0,    0,  129,    0,    0,    0,    0,    0,  214,
  198,    0,    0,    0, -150, -157,    0,  705,    0,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
#define YYTABLESIZE 981
short yytable[] = {                                     105,
  173,  221,  105,   64,  135,  105,  106,  135,  215,  106,
  177,  104,  106,   67,  104,  114,  213,  104,  211,  114,
  114,  114,  114,  114,  118,  114,   38,   85,  118,  118,
  118,  118,  118,   52,  118,  154,   46,  114,   63,  154,
  152,  151,   40,  150,  152,  153,  118,   50,   23,  153,
   96,   69,   25,  121,   70,   30,   63,  121,  121,  121,
  121,  121,  123,  121,   52,  236,   45,   65,  154,  126,
  240,  114,  155,  152,  151,  121,  150,   96,  153,   51,
  118,   64,  123,  122,   29,   65,  123,  123,  123,  123,
  123,   55,  123,   27,   27,   48,   66,  154,   48,   64,
  115,  116,  152,  151,  123,  150,  259,  153,   91,  121,
   30,   91,  154,  121,   66,   31,  179,  152,  151,  170,
  150,   32,  153,  250,  251,   33,  154,   34,   35,   38,
   39,  152,  151,   40,  150,   48,  153,   49,  123,   65,
   55,  154,   58,   68,   59,  216,  152,  151,   60,  150,
   73,  153,   75,   76,   77,  154,   79,   80,   83,  224,
  152,  151,   84,  150,  100,  153,  110,  111,  118,  125,
  154,  113,  114,  119,  226,  152,  151,  127,  150,  130,
  153,  131,  201,  133,  154,  137,  156,  158,  162,  152,
  151,  159,  150,   66,  153,  166,  167,  168,  171,  154,
  194,  196,  175,  200,  152,  151,  209,  150,   88,  153,
    6,    7,    8,    9,   10,  212,  217,  222,  223,  220,
  227,  253,  172,  101,  202,  203,  176,  229,  154,  101,
  233,   63,  260,  152,  151,  231,  150,  234,  153,  102,
  230,  232,  102,  134,  243,  102,  134,  241,  242,  204,
  244,  247,  114,  114,  114,  114,  114,  248,  114,  114,
  254,  118,  118,  118,  118,  118,  103,  118,  118,  103,
  256,   59,  103,  261,   90,   88,  114,   37,  157,  114,
  114,  114,  114,   87,  114,  161,  114,  197,  118,  118,
  121,  121,  121,  121,  121,  132,  121,  121,  266,  148,
    0,  120,    0,  148,    0,  141,  142,  143,  144,  145,
    0,  146,  147,    0,    0,    0,    0,  121,  121,  123,
  123,  123,  123,  123,    0,  123,  123,    0,    0,    0,
  126,    0,  148,  149,  141,  142,  143,  144,  145,    0,
  146,  147,    0,    0,    0,    0,  123,  123,    0,  141,
  142,  143,  144,  145,    0,  146,  147,    0,    0,    0,
    0,  148,  149,  141,  142,  143,  144,  145,    0,  146,
  147,    0,    0,    0,    0,    0,  148,  149,  141,  142,
  143,  144,  145,    0,  146,  147,    0,    0,    0,    0,
  148,  149,  141,  142,  143,  144,  145,    0,  146,  147,
   97,    0,   97,   97,   97,  148,  149,  141,  142,  143,
  144,  145,    0,  146,  147,    0,    0,    0,   97,  148,
  149,  141,  142,  143,  144,  145,    0,  146,  147,   96,
    0,   96,   96,   96,  148,  149,  141,  142,  143,  144,
  145,   57,  146,  147,    0,  154,    0,   96,  148,  149,
  152,  151,   97,  150,    0,  153,    0,    0,  103,    0,
    0,  103,    0,  148,  149,  141,  142,  143,  144,  145,
    0,  146,  147,    0,  154,    0,  103,    0,    0,  152,
  151,   96,  150,    0,  153,    0,    0,  102,    0,    0,
  102,  108,  148,  149,  108,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  109,  102,    0,  109,    0,  108,
  103,    0,    0,  114,  114,  114,  114,  114,  104,  114,
  114,  104,  109,    0,    0,    0,  105,    0,    0,  105,
    0,    0,    0,    0,  106,    0,  104,  106,    0,  102,
  114,  114,    0,  108,  105,    0,    0,    0,    0,    0,
    0,    0,  106,    0,    0,    0,  109,  107,    0,    0,
  107,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  104,    0,    0,   55,    0,  107,    0,    0,  105,    0,
   55,   55,    0,    0,    0,    0,  106,   55,   55,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   55,   55,   55,   55,   55,    0,    0,   55,  107,
    0,    0,    0,    0,    0,   55,    0,    0,    0,   57,
    0,    0,    0,    0,   62,    0,    0,    0,    0,    0,
    0,    0,    0,   97,   97,   97,   97,   97,    0,   97,
   97,    0,    0,    0,    0,    0,   86,    0,    0,    0,
    0,  109,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   97,   96,   96,   96,   96,   96,    0,   96,   96,
  128,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  141,  142,  143,  144,  145,    0,  146,  147,
   96,  103,  103,  103,  103,  103,    0,  103,  103,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  148,
  149,  141,  142,  143,  144,  145,    0,    0,    0,  103,
  102,  102,  102,  102,  102,    0,  102,  102,   87,    0,
  108,  108,    0,    0,  195,    0,    0,  198,  148,  149,
    0,    0,    0,  109,  109,    0,    0,    0,  102,    0,
    0,  104,  104,  104,  104,  104,    0,  104,  104,  105,
  105,  105,  105,  105,    0,  105,  105,  106,  106,  106,
  106,  106,    0,  106,  106,    0,  218,  107,    0,  104,
    0,    0,    0,    0,    0,    0,  225,  105,    0,    0,
  107,  107,  107,  107,  107,  106,  107,  107,  129,    0,
    0,  237,    0,  238,    0,    0,    0,    0,  138,  139,
  140,    0,    0,    0,    0,    0,    0,    0,  107,    0,
    0,    0,    0,    0,    0,  163,  164,  255,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  262,    0,    0,
  265,  178,    0,    0,    0,  180,  181,  182,  183,  184,
  185,  186,  187,  188,  189,  190,  191,  192,  193,    0,
   87,    0,    0,    0,    0,    0,    0,   87,   87,    0,
  208,    0,  210,    0,   87,   87,    0,    0,    0,  214,
    0,    0,    0,    0,    0,    0,   88,   87,   87,   87,
   87,   87,   87,   89,   90,   87,    0,    0,    0,    0,
   91,   92,   87,    0,  219,    0,    0,    0,    0,    0,
    0,    0,    0,   93,    6,    7,    8,    9,   10,    0,
    0,   94,    0,    0,    0,  235,    0,    0,   95,    1,
    2,    3,    0,    0,    0,    4,    0,    5,    0,    0,
    0,    0,    0,  246,    1,    2,    3,    0,  249,    0,
    4,   36,    5,    0,    6,    7,    8,    9,   10,    0,
  258,    0,   11,   12,   13,   14,    0,    0,    0,    6,
    7,    8,    9,   10,    0,    0,    0,   11,   12,   13,
   14,
};
short yycheck[] = {                                      33,
   35,   61,   33,   45,   40,   33,   40,   40,   41,   40,
   41,   45,   40,   93,   45,   37,  174,   45,  169,   41,
   42,   43,   44,   45,   37,   47,   43,   59,   41,   42,
   43,   44,   45,   39,   47,   37,   61,   59,   41,   37,
   42,   43,   59,   45,   42,   47,   59,   59,  263,   47,
   71,   41,  267,   37,   44,  259,   59,   41,   42,   43,
   44,   45,   40,   47,   70,  223,   91,   41,   37,   91,
  228,   93,   41,   42,   43,   59,   45,   98,   47,   91,
   93,   41,   37,   61,  259,   59,   41,   42,   43,   44,
   45,  123,   47,  297,  298,   41,   41,   37,   44,   59,
  297,  298,   42,   43,   59,   45,  257,   47,   41,   93,
  259,   44,   37,   91,   59,  259,   41,   42,   43,   59,
   45,  257,   47,  269,  270,  259,   37,  257,   40,  257,
   40,   42,   43,  257,   45,   61,   47,  257,   93,   41,
  123,   37,  263,  257,  267,   41,   42,   43,  273,   45,
   40,   47,  283,   44,  257,   37,   59,  273,   93,   41,
   42,   43,   59,   45,  125,   47,  263,  273,  259,   40,
   37,   59,   59,   59,   41,   42,   43,   40,   45,   58,
   47,  125,   93,   59,   37,   40,  279,   44,  257,   42,
   43,   43,   45,  273,   47,   40,  258,   40,  257,   37,
  257,  273,   91,   61,   42,   43,   41,   45,  257,   47,
  285,  286,  287,  288,  289,   40,   44,   41,   44,  279,
   59,   59,  257,  257,  258,  259,  257,   41,   37,  257,
  273,  273,   41,   42,   43,  279,   45,  257,   47,  273,
   93,  279,  273,  279,   93,  273,  279,  257,  257,  283,
   61,   41,  274,  275,  276,  277,  278,   59,  280,  281,
   59,  274,  275,  276,  277,  278,  300,  280,  281,  300,
   40,  125,  300,   41,   41,   41,   37,   16,  110,  301,
  302,   42,   43,   70,   45,  118,   47,  159,  301,  302,
  274,  275,  276,  277,  278,   98,  280,  281,  264,  301,
   -1,  279,   -1,  301,   -1,  274,  275,  276,  277,  278,
   -1,  280,  281,   -1,   -1,   -1,   -1,  301,  302,  274,
  275,  276,  277,  278,   -1,  280,  281,   -1,   -1,   -1,
   91,   -1,  301,  302,  274,  275,  276,  277,  278,   -1,
  280,  281,   -1,   -1,   -1,   -1,  301,  302,   -1,  274,
  275,  276,  277,  278,   -1,  280,  281,   -1,   -1,   -1,
   -1,  301,  302,  274,  275,  276,  277,  278,   -1,  280,
  281,   -1,   -1,   -1,   -1,   -1,  301,  302,  274,  275,
  276,  277,  278,   -1,  280,  281,   -1,   -1,   -1,   -1,
  301,  302,  274,  275,  276,  277,  278,   -1,  280,  281,
   41,   -1,   43,   44,   45,  301,  302,  274,  275,  276,
  277,  278,   -1,  280,  281,   -1,   -1,   -1,   59,  301,
  302,  274,  275,  276,  277,  278,   -1,  280,  281,   41,
   -1,   43,   44,   45,  301,  302,  274,  275,  276,  277,
  278,  125,  280,  281,   -1,   37,   -1,   59,  301,  302,
   42,   43,   93,   45,   -1,   47,   -1,   -1,   41,   -1,
   -1,   44,   -1,  301,  302,  274,  275,  276,  277,  278,
   -1,  280,  281,   -1,   37,   -1,   59,   -1,   -1,   42,
   43,   93,   45,   -1,   47,   -1,   -1,   41,   -1,   -1,
   44,   41,  301,  302,   44,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   41,   59,   -1,   44,   -1,   59,
   93,   -1,   -1,  274,  275,  276,  277,  278,   41,  280,
  281,   44,   59,   -1,   -1,   -1,   41,   -1,   -1,   44,
   -1,   -1,   -1,   -1,   41,   -1,   59,   44,   -1,   93,
  301,  302,   -1,   93,   59,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   59,   -1,   -1,   -1,   93,   41,   -1,   -1,
   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   93,   -1,   -1,  257,   -1,   59,   -1,   -1,   93,   -1,
  264,  265,   -1,   -1,   -1,   -1,   93,  271,  272,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,  285,  286,  287,  288,  289,   -1,   -1,  292,   93,
   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,   -1,   42,
   -1,   -1,   -1,   -1,   47,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  274,  275,  276,  277,  278,   -1,  280,
  281,   -1,   -1,   -1,   -1,   -1,   69,   -1,   -1,   -1,
   -1,   74,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  302,  274,  275,  276,  277,  278,   -1,  280,  281,
   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  274,  275,  276,  277,  278,   -1,  280,  281,
  302,  274,  275,  276,  277,  278,   -1,  280,  281,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  301,
  302,  274,  275,  276,  277,  278,   -1,   -1,   -1,  302,
  274,  275,  276,  277,  278,   -1,  280,  281,  125,   -1,
  280,  281,   -1,   -1,  157,   -1,   -1,  160,  301,  302,
   -1,   -1,   -1,  280,  281,   -1,   -1,   -1,  302,   -1,
   -1,  274,  275,  276,  277,  278,   -1,  280,  281,  274,
  275,  276,  277,  278,   -1,  280,  281,  274,  275,  276,
  277,  278,   -1,  280,  281,   -1,  199,   73,   -1,  302,
   -1,   -1,   -1,   -1,   -1,   -1,  209,  302,   -1,   -1,
  274,  275,  276,  277,  278,  302,  280,  281,   94,   -1,
   -1,  224,   -1,  226,   -1,   -1,   -1,   -1,  104,  105,
  106,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,   -1,   -1,  121,  122,  250,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  260,   -1,   -1,
  263,  137,   -1,   -1,   -1,  141,  142,  143,  144,  145,
  146,  147,  148,  149,  150,  151,  152,  153,  154,   -1,
  257,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  166,   -1,  168,   -1,  271,  272,   -1,   -1,   -1,  175,
   -1,   -1,   -1,   -1,   -1,   -1,  257,  284,  285,  286,
  287,  288,  289,  264,  265,  292,   -1,   -1,   -1,   -1,
  271,  272,  299,   -1,  200,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,  285,  286,  287,  288,  289,   -1,
   -1,  292,   -1,   -1,   -1,  221,   -1,   -1,  299,  260,
  261,  262,   -1,   -1,   -1,  266,   -1,  268,   -1,   -1,
   -1,   -1,   -1,  239,  260,  261,  262,   -1,  244,   -1,
  266,  282,  268,   -1,  285,  286,  287,  288,  289,   -1,
  256,   -1,  293,  294,  295,  296,   -1,   -1,   -1,  285,
  286,  287,  288,  289,   -1,   -1,   -1,  293,  294,  295,
  296,
};
#define YYFINAL 15
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 303
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"'!'",0,"'#'",0,"'%'",0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,
0,0,0,0,0,"':'","';'",0,"'='",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,"'['",0,"']'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NAME","STRINGID","IDENTIFIER",
"KW_MESSAGEBOX","KW_ALERTBOX","KW_TRIGGER","KW_WHEN","KW_IF","KW_BUTTON",
"KW_REGION","KW_ON","KW_HELPBOX","KW_ELSE","KW_ELSEIF","KW_WHILE","KW_FOR",
"NUMBER","GT","LT","GTE","LTE","EQ","REF","AND","OR","END_OF_INPUT","STRING",
"KW_ONCLOSE","KW_UNIT","KW_CITY","KW_LOCATION","KW_INT","KW_ARMY","KW_FUNCTION",
"KW_VOID","KW_RETURN","KW_INT_FUNC","KW_VOID_FUNC","KW_CONST","KW_HANDLEEVENT",
"KW_PRE","KW_POST","KW_EVENT","DBREF","EXP","NEQ","UMINUS",
};
char *yyrule[] = {
"$accept : slic",
"slic : objects END_OF_INPUT",
"objects : objects object",
"objects : object",
"object : messagebox",
"object : trigger",
"object : eventhandler",
"object : region",
"object : typedef",
"object : function",
"object : functionproto",
"object : const",
"typedef : vartype NAME ';'",
"typedef : vartype NAME '[' ']' ';'",
"typedef : vartype NAME '[' NUMBER ']' ';'",
"const : KW_CONST NAME '=' NUMBER ';'",
"const : KW_CONST NAME '=' '-' NUMBER ';'",
"$$1 :",
"messagebox : KW_MESSAGEBOX IDENTIFIER $$1 body",
"$$2 :",
"messagebox : KW_ALERTBOX IDENTIFIER $$2 body",
"$$3 :",
"messagebox : KW_HELPBOX IDENTIFIER $$3 body",
"$$4 :",
"trigger : KW_TRIGGER IDENTIFIER $$4 KW_WHEN triggercondition body",
"$$5 :",
"trigger : KW_TRIGGER IDENTIFIER $$5 KW_ON STRING KW_WHEN triggercondition body",
"$$6 :",
"$$7 :",
"eventhandler : KW_HANDLEEVENT '(' NAME ')' $$6 priority $$7 body",
"$$8 :",
"$$9 :",
"eventhandler : KW_HANDLEEVENT '(' NAME ')' $$8 IDENTIFIER priority $$9 body",
"priority : KW_PRE",
"priority : KW_POST",
"region : KW_REGION NAME '[' NUMBER ',' NUMBER ',' NUMBER ',' NUMBER ']' ';'",
"$$10 :",
"region : KW_REGION NAME '=' $$10 regionlist ';'",
"$$11 :",
"regionlist : NAME $$11 '+' regionlist",
"regionlist : NAME",
"functionhead : returntype NAME",
"functionproto : functionhead '(' functionarglist ')' ';'",
"function : functionhead '(' functionarglist ')' body",
"returntype : KW_INT_FUNC",
"returntype : KW_VOID_FUNC",
"functionarglist : functionargument",
"functionarglist : functionarglist ',' functionargument",
"functionarglist :",
"functionargument : vartype NAME",
"vartype : KW_UNIT",
"vartype : KW_ARMY",
"vartype : KW_INT",
"vartype : KW_CITY",
"vartype : KW_LOCATION",
"$$12 :",
"body : '{' $$12 statements '}'",
"$$13 :",
"body : '{' $$13 '}'",
"statements : statement",
"statements : statement statements",
"$$14 :",
"simplestatement : NAME '(' $$14 arguments ')'",
"simplestatement : NAME '=' expression",
"simplestatement : NAME '[' expression ']' '=' expression",
"simplestatement : NAME REF NAME '=' expression",
"simplestatement : NAME '[' expression ']' REF NAME '=' expression",
"statement : simplestatement ';'",
"statement : KW_BUTTON '(' STRINGID ')' body",
"statement : KW_ONCLOSE body",
"$$15 :",
"$$16 :",
"statement : KW_IF $$15 '(' expression ')' body $$16 elsestatements",
"$$17 :",
"statement : KW_WHILE $$17 '(' expression ')' body",
"statement : KW_RETURN expression ';'",
"$$18 :",
"$$19 :",
"$$20 :",
"$$21 :",
"statement : KW_FOR '(' $$18 simplestatement ';' $$19 expression ';' $$20 simplestatement ')' $$21 body",
"$$22 :",
"statement : KW_EVENT ':' NAME '(' $$22 arguments ')' ';'",
"statement : typedef",
"elsestatements : KW_ELSE body",
"$$23 :",
"elsestatements : KW_ELSEIF '(' expression ')' body $$23 elsestatements",
"elsestatements :",
"arguments : argument",
"arguments : argument ',' arguments",
"arguments :",
"argument : expression",
"argument : IDENTIFIER",
"argument : STRINGID",
"argument : STRING",
"triggercondition : '(' expression ')'",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression EXP expression",
"expression : expression '/' expression",
"expression : expression '%' expression",
"expression : expression LT expression",
"expression : expression GT expression",
"expression : expression GTE expression",
"expression : expression LTE expression",
"expression : expression EQ expression",
"expression : expression NEQ expression",
"expression : expression AND expression",
"expression : expression OR expression",
"expression : '!' expression",
"expression : '-' expression",
"expression : '(' expression ')'",
"expression : NUMBER",
"expression : NAME",
"$$24 :",
"expression : NAME '(' $$24 arguments ')'",
"expression : NAME REF NAME",
"expression : arrayref",
"expression : arrayref REF NAME",
"expression : NAME REF '#'",
"expression : DBREF '(' NAME ')'",
"expression : DBREF '(' NAME ')' REF NAME",
"expression : DBREF '(' expression ')'",
"expression : DBREF '(' expression ')' REF NAME",
"expression : DBREF '(' ')'",
"$$25 :",
"arrayref : NAME $$25 '[' expression ']'",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 450 "..\\gs\\slic\\slic.y"

extern FILE *yyin;
int yyparse();

SLIC_ERROR slicif_run_parser(char* filename, int symStart)
{
#ifdef _DEBUG
	static int debug_opened = 0;
	if(!debug_opened) {
		debuglog = fopen("slicdbg.txt", "w");
		debug_opened = 1;
	} else {
		debuglog = fopen("slicdbg.txt", "a");
	}
#endif
	slicif_set_start(symStart);


	g_slicLineNumber = 1;

	if(!slicif_open_first_file(filename)) {
		return slic_parse_error = SLIC_ERROR_CANT_OPEN_FILE;
	}
	
	slic_parse_error = SLIC_ERROR_OK;
	slic_parser_done = 0;

	slicif_start();

    do {
		yyparse();
    } while(!feof(yyin) && slic_parse_error == SLIC_ERROR_OK && !slic_parser_done);

#ifdef _DEBUG
	fclose(debuglog);
	debuglog = NULL;
#endif
	fclose(yyin);
	yyin = NULL;
	return slic_parse_error;
}

const char *slicif_get_filename()
{
	return include_filename_stack[include_stack_ptr];
}

void yyerror(char *s)
{
    extern int line;
#ifdef _DEBUG
    if(debuglog)
		fprintf(debuglog, "line %d: %s\n", g_slicLineNumber, s);
#endif
	sprintf(slic_parser_error_text, "%s:%d: %s",
			slicif_get_filename(), g_slicLineNumber, s);
	slicif_report_error(slic_parser_error_text);
	/*slic_parse_error = SLIC_ERROR_SYNTAX;*/
}

#line 697 "..\\gs\\slic\\y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 97 "..\\gs\\slic\\slic.y"
{ slic_parser_done = 1; }
break;
case 12:
#line 114 "..\\gs\\slic\\slic.y"
{ slicif_declare_sym(yyvsp[-1].name, (SLIC_SYM)yyvsp[-2].val); }
break;
case 13:
#line 115 "..\\gs\\slic\\slic.y"
{ slicif_declare_array(yyvsp[-3].name, (SLIC_SYM)yyvsp[-4].val); }
break;
case 14:
#line 116 "..\\gs\\slic\\slic.y"
{ slicif_declare_fixed_array(yyvsp[-4].name, (SLIC_SYM)yyvsp[-5].val, yyvsp[-2].val); }
break;
case 15:
#line 119 "..\\gs\\slic\\slic.y"
{ slicif_add_const(yyvsp[-3].name, yyvsp[-1].val); }
break;
case 16:
#line 120 "..\\gs\\slic\\slic.y"
{ slicif_add_const(yyvsp[-4].name, -yyvsp[-2].val); }
break;
case 17:
#line 123 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(yyvsp[0].name); }
break;
case 18:
#line 124 "..\\gs\\slic\\slic.y"
{ 
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed MessageBox %s\n", yyvsp[-2]); 
#endif
		obj->m_type = SLIC_OBJECT_MESSAGEBOX;
		obj->m_id = yyvsp[-2].name;
		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		slicif_add_object(obj);
	}
break;
case 19:
#line 135 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(yyvsp[0].name); }
break;
case 20:
#line 136 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed AlertBox %s\n", yyvsp[-2]);
#endif
		obj->m_type = SLIC_OBJECT_MESSAGEBOX;
		obj->m_id = yyvsp[-2].name;
		obj->m_is_alert = 1;
		obj->m_is_help = 0;
		slicif_add_object(obj);
	}
break;
case 21:
#line 147 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(yyvsp[0].name); }
break;
case 22:
#line 148 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed AlertBox %s\n", yyvsp[-2]);
#endif
		obj->m_type = SLIC_OBJECT_MESSAGEBOX;
		obj->m_id = yyvsp[-2].name;
		obj->m_is_alert = 0;
		obj->m_is_help = 1;
		slicif_add_object(obj);
	}
break;
case 23:
#line 161 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(yyvsp[0].name); }
break;
case 24:
#line 162 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed Trigger %s\n", yyvsp[-4]);
#endif

		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		obj->m_type = SLIC_OBJECT_TRIGGER;
		obj->m_id = yyvsp[-4].name;
		obj->m_ui_component = NULL;
		slicif_add_object(obj);
	}
break;
case 25:
#line 175 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(yyvsp[0].name); }
break;
case 26:
#line 176 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed Trigger %s\n", yyvsp[-6]);
#endif
		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		obj->m_type = SLIC_OBJECT_TRIGGER;
		obj->m_id = yyvsp[-6].name;
		obj->m_ui_component = yyvsp[-3].name;
		slicif_add_object(obj);
	}
break;
case 27:
#line 191 "..\\gs\\slic\\slic.y"
{ 
			      slicif_check_event_exists(yyvsp[-1].name);
				  slicif_set_event_checking(yyvsp[-1].name);
		      }
break;
case 28:
#line 195 "..\\gs\\slic\\slic.y"
{ slicif_start_segment(slicif_create_name(yyvsp[-3].name)); }
break;
case 29:
#line 196 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
	    fprintf(debuglog, "Parsed HandleEvent %s\n", yyvsp[-5].name);
#endif	
		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		obj->m_type = SLIC_OBJECT_HANDLEEVENT;
		obj->m_id = slicif_get_segment_name_copy();
		obj->m_ui_component = NULL;
		obj->m_event_name = yyvsp[-5].name;
		obj->m_priority = slicif_get_priority();
		slicif_add_object(obj);
	}
break;
case 30:
#line 211 "..\\gs\\slic\\slic.y"
{ 
	      slicif_check_event_exists(yyvsp[-1].name);
		  slicif_set_event_checking(yyvsp[-1].name);
	  }
break;
case 31:
#line 216 "..\\gs\\slic\\slic.y"
{ 
		  slicif_start_segment(yyvsp[-1].name); 
	  }
break;
case 32:
#line 220 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
	    fprintf(debuglog, "Parsed HandleEvent %s '%s'\n", yyvsp[-6].name, yyvsp[-3].name);
#endif	
		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		obj->m_type = SLIC_OBJECT_HANDLEEVENT;
		obj->m_id = yyvsp[-3].name;
		obj->m_ui_component = NULL;
		obj->m_event_name = yyvsp[-6].name;
		obj->m_priority = slicif_get_priority();
		slicif_add_object(obj);
    }
break;
case 33:
#line 237 "..\\gs\\slic\\slic.y"
{ slicif_set_priority(SLIC_PRI_PRE); }
break;
case 34:
#line 239 "..\\gs\\slic\\slic.y"
{ slicif_set_priority(SLIC_PRI_POST); }
break;
case 35:
#line 243 "..\\gs\\slic\\slic.y"
{
		    slicif_add_region(yyvsp[-10].name, yyvsp[-8].val, yyvsp[-6].val, yyvsp[-4].val, yyvsp[-2].val);
		}
break;
case 36:
#line 246 "..\\gs\\slic\\slic.y"
{ slicif_start_complex_region(yyvsp[-1].name); }
break;
case 37:
#line 247 "..\\gs\\slic\\slic.y"
{ slicif_finish_complex_region(); }
break;
case 38:
#line 250 "..\\gs\\slic\\slic.y"
{slicif_add_region_to_complex(yyvsp[0].name); }
break;
case 40:
#line 251 "..\\gs\\slic\\slic.y"
{ slicif_add_region_to_complex(yyvsp[0].name); }
break;
case 41:
#line 255 "..\\gs\\slic\\slic.y"
{ yyval.name = yyvsp[0].name; slicif_start_segment(yyvsp[0].name); }
break;
case 42:
#line 258 "..\\gs\\slic\\slic.y"
{ slicif_add_prototype(yyvsp[-4].name); }
break;
case 43:
#line 262 "..\\gs\\slic\\slic.y"
{
		struct PSlicObject *obj = malloc(sizeof(struct PSlicObject));
#ifdef _DEBUG
		fprintf(debuglog, "Parsed Function %s\n", yyvsp[-4].name); 
#endif
		obj->m_type = SLIC_OBJECT_FUNCTION;
		obj->m_id = yyvsp[-4].name;
		obj->m_is_alert = 0;
		obj->m_is_help = 0;
		slicif_add_object(obj);
	}
break;
case 44:
#line 275 "..\\gs\\slic\\slic.y"
{ slicif_function_return(SF_RET_INT); }
break;
case 45:
#line 276 "..\\gs\\slic\\slic.y"
{ slicif_function_return(SF_RET_VOID); }
break;
case 49:
#line 284 "..\\gs\\slic\\slic.y"
{ slicif_add_parameter((SLIC_SYM)yyvsp[-1].val, yyvsp[0].name); }
break;
case 50:
#line 287 "..\\gs\\slic\\slic.y"
{ yyval.val = SLIC_SYM_UNIT; }
break;
case 51:
#line 288 "..\\gs\\slic\\slic.y"
{ yyval.val = SLIC_SYM_ARMY; }
break;
case 52:
#line 289 "..\\gs\\slic\\slic.y"
{ yyval.val = SLIC_SYM_IVAR; }
break;
case 53:
#line 290 "..\\gs\\slic\\slic.y"
{ yyval.val = SLIC_SYM_CITY; }
break;
case 54:
#line 291 "..\\gs\\slic\\slic.y"
{ yyval.val = SLIC_SYM_LOCATION; }
break;
case 55:
#line 294 "..\\gs\\slic\\slic.y"
{ slicif_start_block(); }
break;
case 56:
#line 294 "..\\gs\\slic\\slic.y"
{ slicif_end_block(); }
break;
case 57:
#line 295 "..\\gs\\slic\\slic.y"
{ slicif_start_block(); }
break;
case 58:
#line 295 "..\\gs\\slic\\slic.y"
{ slicif_end_block(); }
break;
case 61:
#line 302 "..\\gs\\slic\\slic.y"
{slicif_add_op(SOP_SARGS);}
break;
case 62:
#line 302 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_CALL, yyvsp[-4].name); }
break;
case 63:
#line 303 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ASSN, yyvsp[-2].name); }
break;
case 64:
#line 304 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ASSNA, yyvsp[-5].name); }
break;
case 65:
#line 305 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ASSNM, yyvsp[-4].name, yyvsp[-2].name); }
break;
case 66:
#line 306 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ASSNAM, yyvsp[-7].name, yyvsp[-2].name); }
break;
case 68:
#line 310 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_BUTN, yyvsp[-2].val); }
break;
case 69:
#line 311 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_OCLS); }
break;
case 70:
#line 312 "..\\gs\\slic\\slic.y"
{ slicif_start_if(); }
break;
case 71:
#line 313 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_BNT); }
break;
case 72:
#line 314 "..\\gs\\slic\\slic.y"
{ slicif_end_if(); }
break;
case 73:
#line 315 "..\\gs\\slic\\slic.y"
{ slicif_start_while(); }
break;
case 74:
#line 316 "..\\gs\\slic\\slic.y"
{ slicif_end_while(); }
break;
case 75:
#line 317 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_RET); }
break;
case 76:
#line 318 "..\\gs\\slic\\slic.y"
{ slicif_start_for(); }
break;
case 77:
#line 319 "..\\gs\\slic\\slic.y"
{ slicif_for_expression(); }
break;
case 78:
#line 320 "..\\gs\\slic\\slic.y"
{ slicif_for_continue(); }
break;
case 79:
#line 321 "..\\gs\\slic\\slic.y"
{ slicif_start_for_body(); }
break;
case 80:
#line 321 "..\\gs\\slic\\slic.y"
{ slicif_end_for(); }
break;
case 81:
#line 322 "..\\gs\\slic\\slic.y"
{slicif_start_event(yyvsp[-1].name); }
break;
case 82:
#line 322 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_EVENT, yyvsp[-5].name); }
break;
case 84:
#line 328 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_BNEV); }
break;
case 85:
#line 329 "..\\gs\\slic\\slic.y"
{slicif_add_op(SOP_BNT); }
break;
case 91:
#line 338 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ARGE); }
break;
case 92:
#line 339 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ARGID, yyvsp[0].name); }
break;
case 93:
#line 340 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ARGS, yyvsp[0].val); }
break;
case 94:
#line 341 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ARGST, yyvsp[0].name); }
break;
case 95:
#line 344 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_TRIG); }
break;
case 96:
#line 347 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ADD); }
break;
case 97:
#line 348 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_SUB); }
break;
case 98:
#line 349 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_MULT); }
break;
case 99:
#line 350 "..\\gs\\slic\\slic.y"
{ 
									#ifndef ACTIVISION_ORIGINAL 
										slicif_add_op(SOP_EXP); 
									#endif 
									}
break;
case 100:
#line 355 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_DIV); }
break;
case 101:
#line 356 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_MOD); }
break;
case 102:
#line 357 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_LT); }
break;
case 103:
#line 358 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_GT); }
break;
case 104:
#line 359 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_GTE); }
break;
case 105:
#line 360 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_LTE); }
break;
case 106:
#line 361 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_EQ); }
break;
case 107:
#line 362 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_NEQ); }
break;
case 108:
#line 363 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_AND); }
break;
case 109:
#line 364 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_OR); }
break;
case 110:
#line 365 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_NOT); }
break;
case 111:
#line 366 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_NEG); }
break;
case 112:
#line 367 "..\\gs\\slic\\slic.y"
{ }
break;
case 113:
#line 368 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_PUSHI, yyvsp[0].val); }
break;
case 114:
#line 369 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_PUSHV, yyvsp[0].name); }
break;
case 115:
#line 370 "..\\gs\\slic\\slic.y"
{slicif_add_op(SOP_SARGS); }
break;
case 116:
#line 370 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_CALLR, yyvsp[-4].name); }
break;
case 117:
#line 371 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_PUSHM, yyvsp[-2].name, yyvsp[0].name); }
break;
case 118:
#line 372 "..\\gs\\slic\\slic.y"
{slicif_add_op(SOP_AINDX); }
break;
case 119:
#line 373 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_PUSHAM, yyvsp[-2].name, yyvsp[0].name); }
break;
case 120:
#line 374 "..\\gs\\slic\\slic.y"
{ slicif_add_op(SOP_ASIZE, yyvsp[-2].name); }
break;
case 121:
#line 387 "..\\gs\\slic\\slic.y"
{ 
#if defined(ACTIVISION_ORIGINAL)
/*Removed by Martin Ghmann*/
	slicif_add_op(SOP_PUSHI, slicif_find_db_index(yyvsp[-3].dbptr, yyvsp[-1].name));
#else
/*Added by Martin Ghmann*/
	if(slicif_is_name(yyvsp[-3].dbptr, yyvsp[-1].name) < 0){
		slicif_add_op(SOP_DBNAME, yyvsp[-3].dbptr, yyvsp[-1].name);
	}
	else{
		slicif_add_op(SOP_PUSHI, slicif_find_db_index(yyvsp[-3].dbptr, yyvsp[-1].name));
	}
#endif
}
break;
case 122:
#line 402 "..\\gs\\slic\\slic.y"
{ 
#if defined(ACTIVISION_ORIGINAL)
/*Removed by Martin Ghmann*/
		slicif_add_op(SOP_PUSHI, slicif_find_db_value(yyvsp[-5].dbptr, yyvsp[-3].name, yyvsp[0].name));
#else
/*Added by Martin Ghmann*/
	if(slicif_is_name(yyvsp[-5].dbptr, yyvsp[-3].name) < 0){
		slicif_add_op(SOP_DBNAMEREF, yyvsp[-5].dbptr, yyvsp[-3].name, yyvsp[0].name);
	}
	else{
		slicif_add_op(SOP_PUSHI, slicif_find_db_value(yyvsp[-5].dbptr, yyvsp[-3].name, yyvsp[0].name));
	}
#endif
}
break;
case 123:
#line 417 "..\\gs\\slic\\slic.y"
{
#if defined(ACTIVISION_ORIGINAL)
/*Removed by Martin Ghmann*/
/*Do nothning in the original ctp2.exe*/
#else
	slicif_add_op(SOP_DB, yyvsp[-3].dbptr); 
#endif
}
break;
case 124:
#line 426 "..\\gs\\slic\\slic.y"
{ 
#if defined(ACTIVISION_ORIGINAL)
/*Removed by Martin Ghmann*/
	slicif_add_op(SOP_PUSHI, slicif_find_db_value_by_index(yyvsp[-5].dbptr, yyvsp[-3].val, yyvsp[0].name));
#else
/*Added by Martin Ghmann*/
	slicif_add_op(SOP_DBREF, yyvsp[-5].dbptr, yyvsp[0].name); 
#endif
}
break;
case 125:
#line 436 "..\\gs\\slic\\slic.y"
{
#if defined(ACTIVISION_ORIGINAL)
/*Removed by Martin Ghmann*/
/*Do nothning in the original ctp2.exe*/
#else
	slicif_add_op(SOP_DBSIZE, yyvsp[-2].dbptr); 
#endif
}
break;
case 126:
#line 447 "..\\gs\\slic\\slic.y"
{ yyval.name = yyvsp[0].name; slicif_add_op(SOP_PUSHA, yyvsp[0].name); }
break;
#line 1400 "..\\gs\\slic\\y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
