%{
//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ source
// Description  : Defines what valid slic commands are.
//                This file sliccmd.y is compiled to sc.tab.c
//                and therefore you find this text in both files.
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.                                                              
//
//----------------------------------------------------------------------------
//                                                                                                                                                                         
// Compiler flags
//                                            
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Exponetiation operator '**' added.
//
//----------------------------------------------------------------------------

#include "scyaccdefs.h"
#include "sliccmd.h" 
#include "sc.tab.h"
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include "slicif.h"

int my_scinput(char *buf, int max_size);

#undef YY_INPUT
#define YY_INPUT(b, r, ms) (r = my_scinput(b, ms))

extern int sliccmd_first_token;
%}

string 		\"[^\"\n]*[\"\n]
slicid      \'[^\'\n]*[\'\n]
stringid    ID_[a-zA-Z_0-9]+
name		[a-zA-Z]+[a-zA-Z0-9_#]*

%x incl
%x fname

%%
            {
				if(sliccmd_first_token != 0) {
                    int tok = sliccmd_first_token;
					sliccmd_first_token = 0;
					return tok;
				}
			}
	
{stringid}  { yylval.v.value = slicif_find_string(yytext); return STRINGID; }
{name}		{ 
			    int value;
                void *dbptr;
				if(slicif_find_const(yytext, &value)) {
                    yylval.v.type = EXP_VAL_INT;
				    yylval.v.value = value;
					return NUMBER;
                } else if(slicif_find_db(yytext, &dbptr)) {
					yylval.v.dbptr = dbptr;
					return DBREF;
				} else {
                    yylval.v.type = EXP_VAL_SYM;
				    strncpy(yylval.v.name, yytext, k_MAX_SLICCMD_NAME);
				    return NAME;
				}
			}
[0-9]+		{ yylval.v.type = EXP_VAL_INT; yylval.v.value = atoi(yytext); return NUMBER; }
{slicid}	{ 
                yylval.v.type = EXP_VAL_SYM;
				strncpy(yylval.v.name, yytext + 1, strlen(yytext) - 2);
				yylval.v.name[strlen(yytext) - 2] = 0;
				return IDENTIFIER; 
			}
{string}    { 
                yylval.v.type = EXP_VAL_SYM;
				strncpy(yylval.v.name, yytext + 1, strlen(yytext) - 2);
				yylval.v.name[strlen(yytext) - 2] = 0;
				return STRING;
			}

\/\/.*\n	{ }
\{ 			{ return yytext[0]; }
\} 			{ return yytext[0]; }

\.       { return REF; }
[ \t]		{}
==		{ return EQ; }
\<		{ return LT; }
\>		{ return GT; }
\<=		{ return LTE; }
\>=		{ return GTE; }
!=      { return NEQ; }
&&      { return AND; }
\*\*    { #ifndef ACTIVISION_ORIGINAL 
		return EXP;
	    #endif }
\|\|    { return OR; }
\n		{ }
.		{ return yytext[0]; }

%%
int yywrap() { return 1; }

extern char *sliccmd_input;
extern char *sliccmd_input_ptr;
extern int sliccmd_input_len;

int my_scinput(char *buf, int max_size)
{
	int n = min(max_size, (sliccmd_input + sliccmd_input_len) - sliccmd_input_ptr);
	if(n > 0) {
		memcpy(buf, sliccmd_input_ptr, n);
		sliccmd_input_ptr += n;
	}
	return n;
}
