/*----------------------------------------------------------------------------
 *
 * Project      : Call To Power 2
 * File type    : C/C++ header
 * Description  : SLIC interpreter functions
 *
 *----------------------------------------------------------------------------
 *
 * Disclaimer
 *
 * THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
 *
 * This material has been developed at apolyton.net by the Apolyton CtP2 
 * Source Code Project. Contact the authors at ctp2source@apolyton.net.
 *
 *----------------------------------------------------------------------------
 *
 * Compiler flags
 * 
 * ACTIVISION_ORIGINAL		
 * - When defined, generates the original Activision code.
 * - When not defined, generates the modified Apolyton code.
 *
 *----------------------------------------------------------------------------
 *
 * Modifications from the original Activision code:
 *
 * - SOP types added by Martin Ghmann to allow:
 *   - Slic database access
 *   - Slic database size access
 * - slicif_cleanup() added.
 *
 *----------------------------------------------------------------------------
 */

#ifndef _SLICIF_H_
#define _SLICIF_H_

#if defined(__cplusplus)
extern "C" {
#endif

typedef enum {
	SLIC_ERROR_OK,
	SLIC_ERROR_SYNTAX,
	SLIC_ERROR_CANT_OPEN_FILE,
	SLIC_ERROR_INCLUDE,
	SLIC_ERROR_ALREADY_USED,
	SLIC_ERROR_UNKNOWN,
	SLIC_ERROR_INTERNAL,
	SLIC_ERROR_UNKNOWN_REGION,
	SLIC_ERROR_SYMBOL_NOT_REGION,
} SLIC_ERROR;

typedef enum {
	SLIC_OBJECT_MESSAGEBOX,
	SLIC_OBJECT_TRIGGER,
	SLIC_OBJECT_FUNCTION,
	SLIC_OBJECT_HANDLEEVENT,
} SLIC_OBJECT;

typedef enum {
	SOP_TRIG,
	SOP_CALL,
	SOP_CALLR,
	SOP_EXP,
	SOP_STRING,
	SOP_ID,
	SOP_ADD,
	SOP_SUB,
	SOP_MULT,
	SOP_EXP,
	SOP_DIV,
	SOP_MOD,
	SOP_EQ,
	SOP_GT,
	SOP_LT,
	SOP_GTE,
	SOP_LTE,
	SOP_PUSHD,
	SOP_PUSHI,
	SOP_PUSHV,
	SOP_POP, 
	SOP_ARGE,
	SOP_ARGID,
	SOP_ARGS,
	SOP_SBLK,
	SOP_END,
	SOP_JMP,
	SOP_STOP,
	SOP_NEG,
	SOP_BUTN,
	SOP_NEQ,
	SOP_ASSN,
	SOP_AND,
	SOP_OR,
	SOP_NOT,
	SOP_BNT,  
	SOP_BNEV, 
	SOP_SARGS, 
	SOP_ARGST, 
	SOP_OCLS,

	
	SOP_PUSHA, 
	SOP_AINDX, 
	SOP_ASSNA, 
    SOP_RET,   
	SOP_ASSNM, 
	SOP_PUSHM, 
	SOP_PUSHAM, 
	SOP_ASSNAM, 
	SOP_LINE, 
	SOP_LBRK, 
	SOP_EVENT, 
	SOP_ASIZE,

#if !defined(ACTIVISION_ORIGINAL)
//Added by Martin Ghmann for database support
	SOP_DBNAME,
	SOP_DBNAMEREF,
	SOP_DB,
	SOP_DBREF,
	SOP_DBARRAY,
	SOP_DBSIZE,
#endif

	SOP_NOP 
} SOP;

#include "slicif_sym.h"

typedef enum {
	SF_RET_INT,
	SF_RET_VOID,
} SF_RET;

typedef enum {
	SLIC_PRI_PRE,
	SLIC_PRI_PRIMARY,
	SLIC_PRI_POST,
} SLIC_PRI;

struct PSlicObject {
	SLIC_OBJECT m_type;
	char *m_id;
	unsigned char *m_code;
	int m_codeSize;
	int *m_trigger_symbols;
	int m_num_trigger_symbols;
	int *m_parameters;
	int m_num_parameters;
	SF_RET m_return_type;
	
	int m_from_file;
	int m_is_alert;
	int m_is_help;
	char *m_ui_component;
	char *m_event_name;
	SLIC_PRI m_priority;
	char *m_filename;
};

struct PSlicRegion {
	int x1, y1;
	int x2, y2;
};

struct PSlicComplexRegion {
	int x1, y1;
	int x2, y2;
	struct PSlicComplexRegion *next;
};

#define k_INITIAL_SLIC_SIZE 16
#define k_MAX_CODE_SIZE 500000
#define k_INITIAL_SYM_TAB_SIZE 16
#define k_MAX_SLIC_STRING 1024
#define k_MAX_SLIC_LEVELS 256
#define k_MAX_TRIGGER_SYMBOLS 1024
#define MAX_INCLUDE_DEPTH 64
#define k_MAX_PARAMETERS 16

extern struct PSlicObject **g_slicObjectArray;
extern int g_slicNumEntries;
extern int g_slicSymTabNumEntries;

extern int slic_parse_error;

extern int g_slicLineNumber;

extern int g_slicWarnUndeclared;
extern FILE *debuglog;

SLIC_ERROR slicif_run_parser(char *filename, int symStart);
void slicif_add_object(struct PSlicObject* obj);
void slicif_add_op(SOP op, ...);
void slicif_init();
#if !defined(ACTIVISION_ORIGINAL)
void slicif_cleanup();
#endif
void slicif_set_start(int symStart);
void slicif_start();
void slicif_dump_code(unsigned char *code, int size);
void slicif_declare_sym(char *name, SLIC_SYM type);
void slicif_declare_array(char *name, SLIC_SYM type);
void slicif_declare_fixed_array(char *name, SLIC_SYM type, int size);

void slicif_start_block();
void slicif_end_block();

void slicif_start_if();
void slicif_end_if();
void slicif_add_if_clause_end(char *ptr);

void slicif_start_while();
void slicif_end_while();

int slicif_find_string(char *id);
void slicif_set_file_num(int type);
void slicif_add_region(char *name, int x1, int y1, int x2, int y2);
void slicif_start_complex_region(char *name);
void slicif_finish_complex_region();
void slicif_add_region_to_complex(char *name);
int slicif_open_first_file(char *name);
const char *slicif_current_file();

void slicif_add_parameter(SLIC_SYM type, char *name);
void slicif_function_return(SF_RET rettype);

void slicif_start_segment(char *name);

void slicif_get_local_name(char *localName, char *name);

void slicif_add_prototype(char *name);


void slicif_start_for();
void slicif_for_expression();
void slicif_for_continue();
void slicif_start_for_body();
void slicif_end_for();

int slicif_find_const(char *name, int *value);
void slicif_add_const(char *name, int value);

void slicif_check_event_exists(char *name);
char *slicif_create_name(char *base);

void slicif_set_priority(SLIC_PRI pri);
SLIC_PRI slicif_get_priority();

char *slicif_get_segment_name_copy();
void slicif_set_event_checking(char *eventname);

void slicif_add_local_struct(char *structtype, char *name);

void slicif_register_line(int line, int offset);

const char *slicif_get_filename();

void slicif_start_event(char *name);
void slicif_check_arg_symbol(SLIC_SYM type, char *typeName);
void slicif_check_argument();
void slicif_check_string_argument();
void slicif_check_hard_string_argument();
void slicif_check_num_args();

int slicif_find_db(const char *dbname, void **dbptr);
int slicif_find_db_index(void *dbptr, const char *name);


int slicif_find_file(char *filename, char *fullpath);
void slicif_report_error(char *s);
int slicif_is_valid_string(char *s);

int slicif_find_db_value(void *dbptr, const char *recname, const char *valname);
int slicif_find_db_value_by_index(void *dbptr, int index, const char *valname);

#if !defined(ACTIVISION_ORIGINAL)
/* Added by Martin Ghmann */
int slicif_is_sym(char *name);
#endif

#if defined(__cplusplus)
}
#endif

#if defined(__cplusplus)
class SlicNamedSymbol;
SlicNamedSymbol *slicif_get_symbol(char *name);
#endif

#endif
