//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ source
// Description  : Database generator
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Variable 'or' renamed, because this a reserved symbol (same as ||) now.
// - Modifed db_add_bit_pair function to allow bit pairs to have default 
//   values so that when two records are merged, only the bit is merged 
//   in that is set. - Sep. 28th 2004 Martin Ghmann
//
//----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <time.h>

#include "ctpdb.h"
#include "RecordDescription.h"

RecordDescription *g_record = NULL;

#ifndef _MAX_PATH
#define _MAX_PATH 1024
#endif

static char s_output_dir[_MAX_PATH];

void db_set_output_dir(char *dir)
{
	strncpy(s_output_dir, dir, _MAX_PATH);
}

static const char *db_get_code_directory()
{
	return s_output_dir;
}

void db_start_record(char *name)
{
	g_record = new RecordDescription(name);
}


FILE *db_open_file(const char *filename)
{
	FILE *outfile = fopen(filename, "w");

	Assert(outfile);
	if(!outfile)
		return NULL;

	fprintf(outfile, "\n/*\n");
	fprintf(outfile, " * DO NOT EDIT THIS FILE!\n");
	fprintf(outfile, " * It is generated automatically by ctpdb\n");
	fprintf(outfile, " */\n");

	return outfile;
}

bool db_files_differ(char *newFilePath, char *oldFilePath)
{
	FILE *n, *o;
	n = fopen(newFilePath, "r");
	if(!n) return true;

	o = fopen(oldFilePath, "r");
	if(!o) {
		fclose(n);
		return true;
	}

#define DIFF_SIZE 16384

	while(!feof(n) && !feof(o)) {
		char nb[DIFF_SIZE], ob[DIFF_SIZE];
#if defined(ACTIVISION_ORIGINAL)
		int nr, or;
		nr = fread(nb, 1, DIFF_SIZE, n);
		or = fread(ob, 1, DIFF_SIZE, o);
		if(nr != or) {
#else
		int const	nr      = fread(nb, 1, DIFF_SIZE, n);
		int const	oldr	= fread(ob, 1, DIFF_SIZE, o);

		if (nr != oldr) {
#endif
			fclose(n);
			fclose(o);
			return true;
		}
		sint32 i;
		for(i = 0; i < nr; i++) {
			if(nb[i] != ob[i]) {
				fclose(n);
				fclose(o);
				return true;
			}
		}
	}
	fclose(n);
	fclose(o);
	return false;
}
void db_maybe_copy(char *newFilePath)
{
	char oldpath[_MAX_PATH];
	getcwd(oldpath, _MAX_PATH);

	chdir(db_get_code_directory());

	char cmd[1024];
	char oldFilePath[_MAX_PATH];


	strcpy(oldFilePath, newFilePath);
	char *dot = strrchr(oldFilePath, '.');
	if(!dot) {
		chdir(oldpath);
		return;
	}
	*dot = 0;

	if(db_files_differ(oldFilePath, newFilePath)) {
		sprintf(cmd, "copy %s %s.old", oldFilePath, oldFilePath);
		system(cmd);
		sprintf(cmd, "copy %s %s", newFilePath, oldFilePath);
		system(cmd);
	}
#if 0
	sprintf(cmd, "diff -q %s %s", oldFilePath, newFilePath);
	fprintf(stderr, "%s\n", cmd);
	fflush(stderr);
	FILE *diffOutput = _popen(cmd, "r");
	if(!diffOutput)
		fprintf(stderr, "Foo!\n");
	Assert(diffOutput);
	FILE *oldFile = fopen(oldFilePath, "r");
	if(!oldFile) {
		fclose(diffOutput);
		diffOutput = NULL;
	} else {
		fclose(oldFile);
	}

	if(!diffOutput) {
		fprintf(stderr, "Diff failed (not in path?), copying\n", newFilePath, oldFilePath);
		sprintf(cmd, "copy %s %s.old", oldFilePath, oldFilePath);
		system(cmd);
		sprintf(cmd, "copy %s %s", newFilePath, oldFilePath);
		system(cmd);
	} else {
		if(feof(diffOutput)) {
			fprintf(stderr, "No output\n");
		}
		while(!feof(diffOutput)) {
			line[0] = 0;
			fgets(line, 1024, diffOutput);
			fprintf(stderr, "%s\n", line);
			if(strstr(line, "differ") ||
			   strstr(line, "No such file or directory")) {
				fprintf(stderr, "%s and %s differ, copying\n", newFilePath, oldFilePath);
				sprintf(cmd, "copy %s %s.old", oldFilePath, oldFilePath);
				system(cmd);
				sprintf(cmd, "copy %s %s", newFilePath, oldFilePath);
				system(cmd);
				break;
			}
		}
	}
#endif
	sprintf(cmd, "del %s", newFilePath);
	system(cmd);
	
	
	

	chdir(oldpath);
}

void db_end_record(char *name)
{
	char filename[1024];
	FILE *outfile = NULL;

	
	sprintf(filename, "%s\\%sRecord.h.new", db_get_code_directory(), name);

	outfile = db_open_file(filename);
	Assert(outfile);
	if(!outfile)
		return;

	g_record->ExportHeader(outfile);

	fclose(outfile);

	
	db_maybe_copy(strrchr(filename, '\\') + 1);

	
	sprintf(filename, "%s\\%sRecord.cpp.new", db_get_code_directory(), name);

	outfile = db_open_file(filename);
	Assert(outfile);
	if(!outfile)
		return;

	g_record->ExportCode(outfile);
	
	fclose(outfile);

	db_maybe_copy(strrchr(filename, '\\') + 1);

	sprintf(filename, "%s\\%sRecord.stamp", db_get_code_directory(), name);
	FILE *stamp = fopen(filename, "w");
	Assert(stamp);
	if(stamp) {
		fprintf(stamp, "//%d\n", time(0));
		fclose(stamp);
	}

	delete g_record;
	g_record = NULL;

}

void db_make_int_db(char *name)
{
	db_start_record(name);
	g_record->SetBaseType(DATUM_INT);
	db_end_record(name);
}

void db_make_float_db(char *name)
{
	db_start_record(name);
	g_record->SetBaseType(DATUM_FLOAT);
	db_end_record(name);
}

void db_make_string_db(char *name)
{
	db_start_record(name);
	g_record->SetBaseType(DATUM_STRING);
	db_end_record(name);
}

void db_make_string_id_db(char *name)
{
	db_start_record(name);
	g_record->SetBaseType(DATUM_STRINGID);
	db_end_record(name);
}

void db_start_member_class(char *name)
{
	Assert(g_record);
	g_record->StartMemberClass(name);
}

void db_end_member_class(char *name)
{
	Assert(g_record);
	g_record->EndMemberClass(name);
}

void db_add_bits(struct namelist *list, struct fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_BIT, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_ints(struct namelist *list, struct fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_INT, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_floats(struct namelist *list, struct fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_FLOAT, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_records(char *recType, struct namelist *list, fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_RECORD, list, size->minSize, size->maxSize,
						   recType);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_structs(char *structType, struct namelist *list, fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_STRUCT, list, size->minSize, size->maxSize,
						   structType);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_filenames(struct namelist *list, fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_FILE, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_strings(struct namelist *list, struct fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_STRING, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_string_ids(struct namelist *list, struct fieldsize *size)
{
	Assert(g_record);
	while(list) {
		g_record->AddDatum(DATUM_STRINGID, list, size->minSize, size->maxSize);
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}

void db_add_bit_pair(struct namelist *list, struct fieldsize *size, struct bitpairtype *pairtype)
{
	Assert(g_record);
	while(list) {
#if defined(ACTIVISION_ORIGINAL)
// Removed by Martin Ghmann
		g_record->AddBitPair(list->name, size->minSize, size->maxSize, pairtype);
#else
// Added by Martin Ghmann
		g_record->AddBitPair(list, size->minSize, size->maxSize, pairtype);
#endif
		struct namelist *next = list->next;
		free(list);
		list = next;
	}
}		

void db_add_grouped_bits(char *groupName, struct namelist *list)
{
	Assert(g_record);

	g_record->AddGroupedBits(groupName, list);
}
