@echo off
:: SMAC ModManager v1.01 by #endgame
:: Run Mod Batchfile

:: Parameters:
:: Run.bat {/R} [ModName] [-S]

:: {/R} (Internal)
:: This batchfile calls itself and allocates
:: additional environment space just to be safe.
:: Do not run with this switch!

:: [ModName] (Optional)
:: The filename of the mod to run
:: It is expected to be in the Mods
:: directory, and the .SM extension
:: is optional.

:: [-S] (Optional)
:: Disables the splash screen for the
:: mod. -s is also accepted, as is
:: /S and /s.

:: Parse Arguments

if not "%1"=="" goto run_arg

:default

:: Check that we actually have some mods

cd mods
for %%i in (*.SM) do set ismods=TRUE
cd ..

if not "%ismods%"=="TRUE" call w.bat box @gui.txt:no_mods
if not "%ismods%"=="TRUE" goto end

:: Build the run box

:build
set error=

:: Since DOS doesn't have anything like
:: the *nix touch command, we make do by
:: typing a 0 byte file, since there is
:: a bug in the win9x version of COPY.

:: Because we use >, we don't need an
:: if exist check

type 0byte.txt>modlist.txt

cd Mods
for %%i in (*.SM) do call ..\add2list.bat %%i
cd ..

:: Display the list for the user

call w.bat list modlist.txt
del modlist.txt

:: Did they back out?

if "%wbat%"=="" goto end

:: Now, we need to find which .SM file matches
:: the title we have.

set modtitle=%title%
cd Mods
for %%i in (*.SM) do call ..\chktitle.bat %%i

:: Get the mod information

:: .SM files are really batches in disguise
:: that just set the appropriate environment
:: variables

:: We should never have a smacmod.bat if the
:: ModManager is behaving itself

if exist smacmod.bat del smacmod.bat

ren %smfile% smacmod.bat
call smacmod.bat
ren smacmod.bat %smfile%

:: We go back to the root ModMan directory

cd ..

:: Now we can actually run the mod

goto launch

:: Launch the mod from command line arguments

:run_arg

if not "%1"=="/R" set path=%path%;..;.\ModMan
if not "%1"=="/R" command /E:4096 /C Run.bat /R %1 %2 %3
if not "%1"=="/R" goto end

:: We need to jump back to default mode if only passed
:: a /R

if "%1"=="/R" if "%2"=="" goto default

:: Shift the args, now that all /R stuff is handled

shift

:: Check for existence of the .SM file in %1

set error=TRUE

if exist Mods\%1 set error=FALSE
if exist Mods\%1 set filename=%1
if exist Mods\%1.SM set error=FALSE
if exist Mods\%1.SM set filename=%1.SM

:: Did we find what we are looking for?

if "%error%"=="TRUE" call w.bat box @gui.txt:run_arg1_not_found
if "%error%"=="TRUE" goto build

set error=

:: Determine if we are skipping the splashscreen

if "%2"=="-s" set nosplash=TRUE
if "%2"=="-S" set nosplash=TRUE
if "%2"=="/s" set nosplash=TRUE
if "%2"=="/S" set nosplash=TRUE

cd mods

:: .SM files are really batches in disguise
:: that just set the appropriate environment
:: variables

:: We should never have a smacmod.bat if the
:: ModManager is behaving itself

if exist smacmod.bat del smacmod.bat

ren %filename% smacmod.bat
call smacmod.bat
ren smacmod.bat %filename%

:: We go back to the root ModMan directory

cd ..

goto launch

:launch

:: Launch the Mod

:: So wbat cannot == "Cancel" by some
:: freak of batch

set wbat=

:: Do we display a splashscreen?

if not "%nosplash%"=="TRUE" call splash.bat

set nosplash=

if "%wbat%"=="Cancel" goto end

:: If it's not a cancel response, OR
:: there was no splash screen we will
:: get here. We are good to go.

cls
set moddir=%moddira%.%moddirb%
set moddira=
set moddirb=
echo Mod directory is %moddir%
echo Backing up SMAC files...
cd ..
mkdir SMAC_OLD
cd ModMan
call Swapin.bat

:: Optional Replacements

if "%r_fac%"=="TRUE" call swapin.bat facs
if "%r_sfx%"=="TRUE" call swapin.bat fx
if "%r_mov%"=="TRUE" call swapin.bat movies
if "%r_sps%"=="TRUE" call swapin.bat projs
if "%r_tec%"=="TRUE" call swapin.bat techs
if "%r_voi%"=="TRUE" call swapin.bat voices

call RunSMAC.bat
cd ModMan

:: Swapout Optional Replacements

if "%r_fac%"=="TRUE" call swapout.bat facs
if "%r_sfx%"=="TRUE" call swapout.bat fx
if "%r_mov%"=="TRUE" call swapout.bat movies
if "%r_sps%"=="TRUE" call swapout.bat projs
if "%r_tec%"=="TRUE" call swapout.bat techs
if "%r_voi%"=="TRUE" call swapout.bat voices

call swapout.bat

:end

:: Clean up environment space

set filename=
set title=
set author=
set version=
set moddir=
set wcb1=
set wcb2=
set wcb3=
set wcb4=
set wcb5=
set wcb6=
set wcb7=
set moddira=
set moddirb=
set desc1=
set desc2=
set desc3=
set desc4=
set desc5=
set r_fac=
set r_sfx=
set r_mov=
set r_sps=
set r_tec=
set r_voi=
set ismods=
set wbat=
set ?=