<?php

	include("../include/session.php");
	include("../include/database.php");

	function display_business_options()
	{
		echo "<form action=admin_business.php method=post>\n",
			"\t<table>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business Admin Options:</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=create value=\"Create Business Type\" size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=review value=\"Review Business Types\" size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=edit value=\"Edit Business Types\" size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=delete value=\"Delete Business Types\" size=32></td>\n",
				"\t\t</tr>\n",
			"\t<table>\n",
		"</form>\n\n";			
	}

	function display_business_checkboxes($requirements)
	{
		$business_list = get_database_results("name", "feudemo_business", "1");

		$i = 0;

		echo 	"\t\t\t\t<table border=0>\n",
					"\t\t\t\t\t<tr>\n";

		while($business = mysql_fetch_array($business_list))
		{
			$bit = $requirements & 1;
			$requirements = $requirements >> 1;
			$formatted_name = str_replace(" ", "_", $business[name]);
			if($i % 2)
			{
				if($bit == 1)
					echo "\t\t\t\t\t\t<td><input type=checkbox checked name=business_$formatted_name>$business[name]</td>\n";
				else
					echo "\t\t\t\t\t\t<td><input type=checkbox name=business_$formatted_name>$business[name]</td>\n";
			}
			else
			{
				if($bit == 1)
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox checked name=business_$formatted_name>$business[name]</td>\n";
				else
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox name=business_$formatted_name>$business[name]</td>\n";
			}
			$i++;
		}
		echo		"\t\t\t\t\t</tr>\n",
				"\t\t\t\t</table>\n";
	}

	function display_business_select_options($selected)
	{
		$business_list = get_database_results("id,name", "feudemo_business", "1");

		while($business = mysql_fetch_array($business_list))
		{
			if($selected == $business[id])
				echo "\t\t\t\t<option value=$business[id] selected>$business[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$business[id]>$business[name]</option>\n";
		}
	}

	function display_stock_select_options($selected)
	{
		$stock_list = get_database_results("id,name", "feudemo_stock", "1");

		while($stock = mysql_fetch_array($stock_list))
		{
			if($selected == $stock[id])
				echo "\t\t\t\t<option value=$stock[id] selected>$stock[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$stock[id]>$stock[name]</option>\n";
		}
	}

	function create_business_form()
	{
		echo 	"<p><b>Create New Business</b></p>\n";	

		echo 	"<form action=admin_business.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business Name:</td>\n",
					"\t\t\t<td><input type=text name=business_name size=32 value=$business_name></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Requirements:</td>\n",
					"\t\t\t<td>\n";
						display_business_checkboxes(0);
		echo		"\t\t\t</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business Cost:</td>\n",
					"\t\t\t<td><input type=text name=business_cost size=32 value=$business_cost></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Upgrades to:</td>\n",
					"\t\t\t<td><select name=business_upgrade_to size=1 value=$business_upgrade_to>\n",
						"\t\t\t\t<option value=0>No Upgrade</option>\n";
						display_business_select_options(0);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Upgrade Cost:</td>\n",
					"\t\t\t<td><input type=text name=business_upgrade_cost size=32 value=$business_upgrade_cost></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Labor to Operate:</td>\n",
					"\t\t\t<td><input type=text name=business_labor_required size=32 value=$business_labor_required></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Max Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_labor_max size=32 value=$business_labor_max></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Stock Consumed:</td>\n",
					"\t\t\t<td><select name=business_consumed size=1>\n",
						"\t\t\t\t<option value=0>No Input</option>\n";
						display_stock_select_options(0);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Consumed Rate/Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_consumed_rate size=32 value=$business_consumed_rate></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Stock Output:</td>\n",
					"\t\t\t<td><select name=business_output size=1 value=$business_output>\n",
						"\t\t\t\t<option value=0>No Output</option>\n";
						display_stock_select_options(0);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Output Rate/Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_output_rate size=32 value=$business_output_rate></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Bonus to Stock:</td>\n",
					"\t\t\t<td><select name=business_bonus_stock size=1 value=$business_bonus_stock>\n",
						"\t\t\t\t<option value=0>No Bonus</option>\n";
						display_stock_select_options(0);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Bonus Rate:</td>\n",
					"\t\t\t<td><input type=text name=business_bonus_rate size=32 value=$business_bonus_rate></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right><input type=submit name=business_create value=Create><input type=hidden name=create value=Create></td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function create_business_script()
	{
		$business_list = get_database_results("id,name", "feudemo_business", "1 ORDER BY id DESC");

		while($business = mysql_fetch_array($business_list))
		{
			$temp = "business_" . str_replace(" ", "_", $business[name]);
			if($_POST[$temp] == "on")
			{
				$bitwise_string = $bitwise_string . "1";
			}
			else
				$bitwise_string = $bitwise_string . "0";
		}
		$requirements = bindec($bitwise_string);

		$sql = "INSERT INTO feudemo_business (	name,
															requirements,
															cost,
															upgrade,
															upgrade_cost,
															labor_required,
															labor_max,
															consumed_stock,
															consumed_rate,
															output_stock,
															output_rate,
															bonus_stock,
															bonus_rate)
												VALUES (	'$_POST[business_name]',
															'$requirements',
															'$_POST[business_cost]',
															'$_POST[business_upgrade_to]',
															'$_POST[business_upgrade_cost]',
															'$_POST[business_labor_required]',
															'$_POST[business_labor_max]',
															'$_POST[business_consumed]',
															'$_POST[business_consumed_rate]',
															'$_POST[business_output]',
															'$_POST[business_output_rate]',
															'$_POST[business_bonus_stock]',
															'$_POST[business_bonus_rate]')";
		$result = mysql_query($sql);

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Created:</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Business:</td><td>", $_POST[business_name], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Requirements:</td><td>", $bitwise_string, "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Business Cost:</td><td>", $_POST[business_cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Upgrades To:</td><td>", $_POST[business_upgrade_to], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>UpgradeCost:</td><td>", $_POST[business_upgrade_cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Required:</td><td>", $_POST[business_labor_required], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Max:</td><td>", $_POST[business_labor_max], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Stock:</td><td>", $_POST[business_consumed], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Rate:</td><td>", $_POST[business_consumed_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Stock:</td><td>", $_POST[business_output], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Rate:</td><td>", $_POST[business_output_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus to Stock:</td><td>", $_POST[business_bonus_stock], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus Rate:</td><td>", $_POST[business_bonus_rate], "</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";
		$create = "";
		echo "\n<a href=\"admin_business.php\">Go back to Business Admin page.</a>";	
	}

	function review_business_form()
	{
		echo 	"<p><b>Review Business</b></p>\n";	

		echo 	"<form action=admin_business.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business to review:</td>\n",
					"\t\t\t<td><select name=business_to_review size=1>\n";
						display_business_select_options(0);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=submit value=Review>\n",
						"\t\t\t\t<input type=hidden name=review value=Review>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function review_business_script()
	{
		$business = get_database_entry("*", "feudemo_business", "id = '$_POST[business_to_review]'");

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Business Details:</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Name:</td><td>", $business[name], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Requirements:</td><td>", decbin($business[requirements]), "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Business Cost:</td><td>", $business[cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Upgrades To:</td><td>", $business[upgrade_to], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>UpgradeCost:</td><td>", $business[upgrade_cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Required:</td><td>", $business[labor_required], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Max:</td><td>", $business[labor_max], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Stock:</td><td>", $business[consumed_stock], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Rate:</td><td>", $business[consumed_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Stock:</td><td>", $business[output_stock], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Rate:</td><td>", $business[output_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus to Stock:</td><td>", $business[bonus_stock], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus Rate:</td><td>", $business[bonus_rate], "</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";
		echo "\n<a href=\"admin_business.php\">Go back to Business Admin page.</a>";	
	}

	function edit_business_selection()
	{
		echo 	"<p><b>Edit Business</b></p>\n";	

		echo 	"<form action=admin_business.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business to review:</td>\n",
					"\t\t\t<td><select name=business_to_edit size=1>\n";
						display_business_select_options();
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=submit value=Edit>\n",
						"\t\t\t\t<input type=hidden name=edit value=Edit>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function edit_business_form()
	{
		$business = get_database_entry("*", "feudemo_business", "id = '$_POST[business_to_edit]'");

		echo 	"<p><b>Create New Business</b></p>\n";	

		echo 	"<form action=admin_business.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business Name:</td>\n",
					"\t\t\t<td><input type=text name=business_name size=32 value=$business[name]><input type=hidden name=id value=$business[id]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Requirements:</td>\n",
					"\t\t\t<td>\n";
						display_business_checkboxes($business[requirements]);
		echo		"\t\t\t</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Business Cost:</td>\n",
					"\t\t\t<td><input type=text name=business_cost size=32 value=$business[cost]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Upgrades to:</td>\n",
					"\t\t\t<td><select name=business_upgrade_to size=1>\n",
						"\t\t\t\t<option value=0>No Upgrade</option>\n";
						display_business_select_options($business[upgrade]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Upgrade Cost:</td>\n",
					"\t\t\t<td><input type=text name=business_upgrade_cost size=32 value=$business[upgrade_cost]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Labor to Operate:</td>\n",
					"\t\t\t<td><input type=text name=business_labor_required size=32 value=$business[labor_required]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Max Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_labor_max size=32 value=$business[labor_max]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Stock Consumed:</td>\n",
					"\t\t\t<td><select name=business_consumed size=1>\n",
						"\t\t\t\t<option value=0>No Input</option>\n";
						display_stock_select_options($business[consumed_stock]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Consumed Rate/Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_consumed_rate size=32 value=$business[consumed_rate]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Stock Output:</td>\n",
					"\t\t\t<td><select name=business_output size=1>\n",
						"\t\t\t\t<option value=0>No Output</option>\n";
						display_stock_select_options($business[output_stock]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Output Rate/Labor:</td>\n",
					"\t\t\t<td><input type=text name=business_output_rate size=32 value=$business[output_rate]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Bonus to Stock:</td>\n",
					"\t\t\t<td><select name=business_bonus_stock size=1>\n",
						"\t\t\t\t<option value=0>No Bonus</option>\n";
						display_stock_select_options($business[bonus_stock]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Bonus Rate:</td>\n",
					"\t\t\t<td><input type=text name=business_bonus_rate size=32 value=$business[bonus_rate]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=save value=Save Changes>\n",
						"\t\t\t\t<input type=hidden name=edit value=Edit>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function edit_business_script()
	{
		$business_list = get_database_results("id,name", "feudemo_business", "1 ORDER BY id DESC");

		while($business = mysql_fetch_array($business_list))
		{
			$temp = "business_" . str_replace(" ", "_", $business[name]);
			if($_POST[$temp] == "on")
			{
				$bitwise_string = $bitwise_string . "1";
			}
			else
				$bitwise_string = $bitwise_string . "0";
		}
		$requirements = bindec($bitwise_string);

		$sql = "UPDATE feudemo_business SET name = '$_POST[business_name]',
															requirements = '$requirements',
															cost = '$_POST[business_cost]',
															upgrade = '$_POST[business_upgrade_to]',
															upgrade_cost = '$_POST[business_upgrade_cost]',
															labor_required = '$_POST[business_labor_required]',
															labor_max = '$_POST[business_labor_max]',
															consumed_stock = '$_POST[business_consumed]',
															consumed_rate = '$_POST[business_consumed_rate]',
															output_stock = '$_POST[business_output]',
															output_rate = '$_POST[business_output_rate]',
															bonus_stock = '$_POST[business_bonus_stock]',
															bonus_rate = '$_POST[business_bonus_rate]' WHERE id = '$_POST[id]'";
		$result = mysql_query($sql);

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Edited:</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Business:</td><td>", $_POST[business_name], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Requirements:</td><td>", $bitwise_string, "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Business Cost:</td><td>", $_POST[business_cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Upgrades To:</td><td>", $_POST[business_upgrade_to], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>UpgradeCost:</td><td>", $_POST[business_upgrade_cost], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Required:</td><td>", $_POST[business_labor_required], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Labor Max:</td><td>", $_POST[business_labor_max], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Stock:</td><td>", $_POST[business_consumed], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Consumed Rate:</td><td>", $_POST[business_consumed_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Stock:</td><td>", $_POST[business_output], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Output Rate:</td><td>", $_POST[business_output_rate], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus to Stock:</td><td>", $_POST[business_bonus_stock], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Bonus Rate:</td><td>", $_POST[business_bonus_rate], "</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";
		echo "\n<a href=\"admin_business.php\">Go back to Business Admin page.</a>";	
	}

	connect_to_database();

	if($_SESSION[id] != 1)
		echo "You must be logged in with an admin account to access this page.";
	else if($create != "")
	{
		if($business_create != "")
			create_business_script();
		else
			create_business_form();
	}
	else if($review != "")
	{
		if($submit != "")
			review_business_script();
		else
			review_business_form();
	}
	else if($edit != "")
	{
		if($save != "")
			edit_business_script();			
		else if($submit != "")
			edit_business_form();
		else
			edit_business_selection();
	}
	else if($delete != "")
	{
		if($business_create != "")
			create_business_script();
		else
			create_business_form();
	}
	else
		display_business_options();	
?>
