<?php

	include("../include/session.php");
	include("../include/database.php");

	connect_to_database();

	function display_year_select_options($name, $year)
	{
		echo "\t\t\t<select name=$name size=1>\n";
		for($i = $year; $i < $year + 2; $i++)
		{
			if($i == $year)
				echo "\t\t\t\t<option value=$i selected>$i</option>\n";
			else
				echo "\t\t\t\t<option value=$i>$i</option>\n";
		}
		echo "\t\t\t</select>\n";
	}

	function display_month_select_options($name, $month)
	{
		echo "\t\t\t<select name=$name size=1>\n";
		for($i = 1; $i < 13; $i++)
		{
			if($i == $month)
				echo "\t\t\t\t<option value=$i selected>$i</option>\n";
			else
				echo "\t\t\t\t<option value=$i>$i</option>\n";
		}
		echo "\t\t\t</select>\n";
	}

	function display_day_select_options($name, $day)
	{
		echo "\t\t\t<select name=$name size=1>\n";
		for($i = 1; $i <= 32; $i++)
		{
			if($i == $day)
				echo "\t\t\t\t<option value=$i selected>$i</option>\n";
			else
				echo "\t\t\t\t<option value=$i>$i</option>\n";
		}
		echo "\t\t\t</select>\n";
	}

	function display_improvements_checkboxes($selected)
	{
		$improvement_list = get_database_results("name", "feudemo_improvements", "1");

		$i = 0;

		echo 	"\t\t\t\t<table border=0>\n",
					"\t\t\t\t\t<tr>\n";

		while($improvement = mysql_fetch_array($improvement_list))
		{
			$bit = $selected & 1;
			$selected = $selected >> 1;
			$formatted_name = str_replace(" ", "_", $improvement[name]);
			if($i % 2)
			{
				if($bit == 1)
					echo "\t\t\t\t\t\t<td><input type=checkbox checked name=improvement_$formatted_name>$improvement[name]</td>\n";
				else
					echo "\t\t\t\t\t\t<td><input type=checkbox name=improvement_$formatted_name>$improvement[name]</td>\n";
			}
			else
			{
				if($bit == 1)
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox checked name=improvement_$formatted_name>$improvement[name]</td>\n";
				else
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox name=improvement_$formatted_name>$improvement[name]</td>\n";
			}
			$i++;
		}
		echo		"\t\t\t\t\t</tr>\n",
				"\t\t\t\t</table>\n";
	}

	function display_resource_name($id)
	{
		$resource = get_database_entry("name", "feudemo_resource", "id = '$id'");

		return $resource[name];
	}

	function display_unit_select_options($selected)
	{
		$unit_list = get_database_results("id,name,type", "feudemo_unit", "owner = '$_SESSION[id]' AND escrow = 0");

		while($unit = mysql_fetch_array($unit_list))
		{
			$type = get_database_entry("name,a,d,m", "feudemo_unit_types", "id = '$unit[type]'");
	
			if($selected == $unit[id])
				echo "\t\t\t\t<option value=$unit[id] selected>$unit[name] ($type[name] $type[a]/$type[d]/$type[m])</option>\n";
			else
				echo "\t\t\t\t<option value=$unit[id]>$unit[name] ($type[name] $type[a]/$type[d]/$type[m])</option>\n";
		}
	}

	function display_tile_select_options($selected)
	{
		$tile_list = get_database_results("id,name,type,x,y,resource", "feudemo_tile", "owner = '$_SESSION[id]' AND escrow = 0 AND visible = 1");

		while($tile = mysql_fetch_array($tile_list))
		{
			echo $tile[type];
			$type = get_database_entry("name", "feudemo_tile_types", "id = '$tile[type]'");
			
			if($selected == $tile[id])
				echo "\t\t\t\t<option value=$tile[id] selected>$tile[name] ($tile[x],$tile[y]) ", display_resource_name($tile[resource]), " $type[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$tile[id]>$tile[name] ($tile[x],$tile[y]) ", display_resource_name($tile[resource]), " $type[name]</option>\n";
		}
	}

	function display_auction_options()
	{
		$player_tiles = get_database_entry_function("COUNT(*)", "feudemo_tile", "owner = '$_SESSION[id]' AND escrow = 0");
		$player_units = get_database_entry_function("COUNT(*)", "feudemo_unit", "owner = '$_SESSION[id]' AND escrow = 0 AND alive = 1");
		$player_auctions = get_database_entry_function("COUNT(*)", "feudemo_auction", "seller = '$_SESSION[id]'");
		$all_auctions = get_database_entry_function("COUNT(*)", "feudemo_auction", "1");

		echo "<form action=index.php method=post>\n",
			"\t<table>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Auction Options:</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n";
					if($player_tiles == 0)
						echo	"\t\t\t<td><input disabled type=submit name=auction_tile value=\"Auction Tile\" size=32></td>\n";
					else
						echo	"\t\t\t<td><input type=submit name=auction_tile value=\"Auction Tile\" size=32></td>\n";
		echo	"\t\t</tr>\n",
				"\t\t<tr>\n";
					if($player_units == 0)
						echo	"\t\t\t<td><input disabled type=submit name=auction_unit value=\"Auction Unit\" size=32></td>\n";
					else
						echo	"\t\t\t<td><input type=submit name=auction_unit value=\"Auction Unit\" size=32></td>\n";
		echo	"\t\t</tr>\n",
				"\t\t<tr>\n";
					if($player_auctions[count] == 0)
						echo	"\t\t\t<td><input disabled type=submit name=view_your_auctions value=\"View Your Auctions\" size=32></td>\n";
					else
						echo	"\t\t\t<td><input type=submit name=view_your_auctions value=\"View Your Auctions\" size=32></td>\n";
		echo	"\t\t</tr>\n",
				"\t\t<tr>\n";
					if($all_auctions[count] == 0)
						echo	"\t\t\t<td><input disabled type=submit name=view_all_auctions value=\"View All Auctions\" size=32></td>\n";
					else
						echo	"\t\t\t<td><input type=submit name=view_all_auctions value=\"View All Auctions\" size=32></td>\n";
		echo	"\t\t</tr>\n",
			"\t<table>\n",
		"</form>\n\n";
	}

	function create_auction_form($type)
	{
		$today = getdate(); 
		$year = $today['year']; 
		$month = $today['mon']; 
		$day = $today['mday'];

		echo 	"<p><b>Create $type Auction</b></p>\n";	

		echo 	"<form action=index.php method=post>\n",
			"\t<input type=hidden name=auction_type value=$type></td>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Auction Title:</td>\n",
					"\t\t\t<td><input type=text name=auction_title size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>$type:</td>\n",
					"\t\t\t<td><select name=auction_item size=1>\n";
						if($type == "Tile")
							display_tile_select_options(0);
						else
							display_unit_select_options(0);							
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Minimum Bid:</td>\n",
					"\t\t\t<td><input type=text name=auction_minimum_bid size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Auction Opens:</td>\n",
					"\t\t\t<td>\n";
						display_year_select_options("auction_year_opens", $year);
						display_month_select_options("auction_month_opens", $month);
						display_day_select_options("auction_day_opens", $day);
		echo		"\t\t\t</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Auction Closes:</td>\n",
					"\t\t\t<td>\n";
						display_year_select_options("auction_year_closes", $year);
						display_month_select_options("auction_month_closes", $month);
						display_day_select_options("auction_day_closes", $day);
		echo		"\t\t\t</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right><input type=submit name=create_auction value=\"Create Auction\"></td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function create_auction_script($auction_type)
	{
		$open_date = $_POST[auction_year_opens] . "-" . $_POST[auction_month_opens] . "-" . $_POST[auction_day_opens]; 
		$close_date = $_POST[auction_year_closes] . "-" . $_POST[auction_month_closes] . "-" . $_POST[auction_day_closes]; 

		if($auction_type == "Tile")
			$sql = "UPDATE feudemo_tile SET escrow = 1 WHERE id = '$_POST[auction_item]'";
		else
			$sql = "UPDATE feudemo_unit SET escrow = 1 WHERE id = '$_POST[auction_item]'";

		$result = mysql_query($sql);

		$sql = "INSERT INTO feudemo_auction (	seller,
															title,
															item_type,
															item_id,
															minimum_bid,
															bidding_opens,
															bidding_closes)
												VALUES (	'$_SESSION[id]',
															'$_POST[auction_title]',
															'$auction_type',
															'$_POST[auction_item]',
															'$_POST[auction_minimum_bid]',
															'$open_date',
															'$close_date')";
		$result = mysql_query($sql);

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Created:</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Auction:</td><td>$_POST[auction_title]</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Type:</td><td>$auction_type</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Item:</td><td>$_POST[auction_item]</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Minimum Bid:</td><td>$_POST[auction_minimum_bid]</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Opens:</td><td>$open_date</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Closes:</td><td>$open_date</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";

		echo "\n<a href=\"index.php\">Go back to Auction Admin page.</a>";	
	}

	function view_auction_form($show)
	{
		if($show == "All")
			$sql = "SELECT * FROM feudemo_auction";
		else if ($show == "Your")
			$sql = "SELECT * FROM feudemo_auction WHERE seller = '$_SESSION[id]'";

		$auction_list = mysql_query($sql);

		$i = 0;

		echo	"\t<table border=1>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>ID</td>\n",
						"\t\t\t<td>Title</td>\n",
						"\t\t\t<td>Seller</td>\n",
						"\t\t\t<td>Type</td>\n",
						"\t\t\t<td>Minimum</td>\n",
						"\t\t\t<td>Current Bid</td>\n",
						"\t\t\t<td>High Bidder</td>\n",
						"\t\t\t<td>Bids</td>\n",
						"\t\t\t<td>Opens</td>\n",
						"\t\t\t<td>Closes</td>\n",
						"\t\t\t<td>&nbsp</td>\n",
						"\t\t\t<td>&nbsp</td>\n",
					"\t\t</tr>\n";

		while ($auction = mysql_fetch_array($auction_list))
		{
			$seller = get_database_entry("name", "feudemo_player", "id = '$auction[seller]'");
			$high_bid = get_database_entry_function("MAX(amount)", "feudemo_bid", "auction = '$auction[id]'");
			$high_bidder = get_database_entry("player", "feudemo_bid", "amount = '$high_bid' AND auction = '$auction[id]'");
			$player = get_database_entry("name", "feudemo_player", "id = '$high_bidder[player]'");
			$bid_count = get_database_entry_function("COUNT(*) AS count", "feudemo_bid", "auction = '$id'");
			
			if($auction[item_type] == "Tile")
			{
				$tile = get_database_entry("type", "feudemo_tile", "id = '$auction[item_id]'");
				$type = get_database_entry("name", "feudemo_tile_types", "id = '$tile[type]'");
			}
			else if($auction[item_type] == "Unit")
			{
				$unit = get_database_entry("type", "feudemo_unit", "id = '$auction[item_id]'");
				$type = get_database_entry("name", "feudemo_unit_types", "id = '$unit[type]'");
			}

			echo	"\t\t<tr>\n",
						"\t\t\t<td>$auction[id]</td>\n",
						"\t\t\t<td>$auction[title]</td>\n",
						"\t\t\t<td>$seller[name]</td>\n",
						"\t\t\t<td>$auction[item_type]:$type[name]</td>\n",
						"\t\t\t<td>$auction[minimum_bid]</td>\n",
						"\t\t\t<td>$high_bid</td>\n",
						"\t\t\t<td>$player[name]</td>\n",
						"\t\t\t<td>$bid_count[count]</td>\n",
						"\t\t\t<td>$auction[bidding_opens]</td>\n",
						"\t\t\t<td>$auction[bidding_closes]</td>\n",
					"\t\t\t\t<form action=index.php method=post>\n",
						"\t\t\t<td>\n",
								"\t\t\t\t\t<input type=hidden name=auction_id value=$auction[id]>\n",
								"\t\t\t\t\t<input type=submit name=details value=Details>\n",
						"\t\t\t</td>\n",
					"\t\t\t\t</form>\n",
					"\t\t\t\t<form action=index.php method=post>\n",
						"\t\t\t<td>\n",
								"\t\t\t\t\t<input type=hidden name=auction_id value=$auction[id]>\n",
								"\t\t\t\t\t<input type=submit name=bid value=Bid>\n",
						"\t\t\t</td>\n",
					"\t\t\t\t</form>\n",
					"\t\t</tr>\n";
		}

		echo	"\t</table>\n\n";
	}

	function view_auction_details_form($id)
	{
		$auction = get_database_entry("*", "feudemo_auction", "id = '$id'");
		$player = get_database_entry("name", "feudemo_player", "id = '$auction[seller]'");
		$high_bid = get_database_entry_function("MAX(amount)", "feudemo_bid", "auction = '$id'");
		$bid_count = get_database_entry_function("COUNT(*) AS count", "feudemo_bid", "auction = '$id'");

		echo 	"<form action=index.php method=post>\n",
					"<input type=hidden name=auction_id value=$id>\n"; 

		if($auction[item_type] == "Tile")
		{
			$tile = get_database_entry("*", "feudemo_tile", "id = '$auction[item_id]'");
			$type = get_database_entry("name", "feudemo_tile_types", "id = '$tile[type]'");

			echo 	"\t<table>\n",
						"\t\t<tr>\n",
							"\t\t\t<td colspan=2><b>$auction[title]</b></td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Seller:</td><td>$player[name]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Item:</td><td>", display_resource_name($tile[resource]), " $type[name] ($tile[x],$tile[y])</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Tile Name:</td><td>$tile[name]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Improvements:</td><td>\n";
							display_improvements_checkboxes($tile[improvements]);
			echo		"</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Minimum Bid:</td><td>$auction[minimum_bid]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Current Bid:</td><td>$high_bid</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bids:</td><td>$bid_count</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bidding Opens:</td><td>$auction[bidding_opens]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bidding Closes:</td><td>$auction[bidding_closes]</td>\n",
						"\t\t</tr>\n",
					"\t<table>\n\n";
		}
		else if($auction[item_type] == "Unit")
		{
			$unit = get_database_entry("name,hp,tile,type", "feudemo_unit", "id = '$auction[item_id]'");
			$type = get_database_entry("name,a,d,m", "feudemo_unit_types", "id = '$unit[type]'");
			$tile = get_database_entry("x,y", "feudemo_tile", "id = '$unit[tile]'");

			echo 	"\t<table>\n",
						"\t\t<tr>\n",
							"\t\t\t<td colspan=2><b>$auction[title]</b></td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Seller:</td><td>$player[name]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Unit (A/D/M HP):</td><td>$type[name] ($type[a]/$type[d]/$type[m] $unit[hp]HP)</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Unit Name:</td><td>$unit[name]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Unit Coords (x,y):</td><td>($tile[x],$tile[y])</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Minimum Bid:</td><td>$auction[minimum_bid]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Current Bid:</td><td>$high_bid</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bids:</td><td>$bid_count</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bidding Opens:</td><td>$auction[bidding_opens]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Bidding Closes:</td><td>$auction[bidding_closes]</td>\n",
						"\t\t</tr>\n",
					"\t<table>\n\n";
		}

		$high_bid++;

		echo	"<form action=index.php method=post>\n",
					"\t<input type=hidden name=auction_id value=$id></td>\n",
					"\t<table>\n",
						"\t\t<tr>\n",
							"\t\t\t<td colspan=2><b>$auction[title]</b></td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Place Bid:</td>\n",
							"\t\t\t<td><input type=text name=new_bid size=32 value=$high_bid></td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td><input type=submit name=enter_bid value=\"Enter Bid\"></td>\n",
						"\t\t</tr>\n",
					"\t<table>\n",
				"</form>\n\n";
	}

	function bid_on_auction_form($id)
	{
		$auction = get_database_entry("title,minimum_bid", "feudemo_auction", "id = '$id'");
		$high_bid = get_database_entry_function("MAX(amount)", "feudemo_bid", "auction = '$id'");
		
		if(!$high_bid)
			$high_bid = $auction[minimum_bid];
		else
			$high_bid++;

		echo	"<form action=index.php method=post>\n",
					"\t<input type=hidden name=auction_id value=$id></td>\n",
					"\t<table>\n",
						"\t\t<tr>\n",
							"\t\t\t<td colspan = 2>$auction[title]</td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td>Place Bid:</td>\n",
							"\t\t\t<td><input type=text name=new_bid size=32 value=$high_bid></td>\n",
						"\t\t</tr>\n",
						"\t\t<tr>\n",
							"\t\t\t<td><input type=submit name=enter_bid value=\"Enter Bid\"></td>\n",
						"\t\t</tr>\n",
					"\t<table>\n",
				"</form>\n\n";
	}

	function bid_on_auction_script($id, $bid)
	{
		$stockpile = get_database_entry("gold", "feudemo_stockpile", "id = '$_SESSION[id]'");
		$auction = get_database_entry("seller,minimum_bid", "feudemo_auction", "id = '$id'");
		$high_bid = get_database_entry_function("MAX(amount)", "feudemo_bid", "auction = '$id'");
		$debt_pending = get_database_entry_function("SUM(amount)", "feudemo_bid", "id = '$_SESSION[id]'");

		if(!$high_bid)
			$high_bid = $auction[minimum_bid] - 1;
		else
			$high_bidder = get_database_entry("player", "feudemo_bid", "amount = '$high_bid' AND auction = '$id'");

		if($_SESSION[id] == $auction[seller])
		{
			echo "Your cannot bid on your own auction.";
			display_auction_options();		
		}
		else if($stockpile[gold] < ($debt_pending + $bid))
		{
			if($stockpile[gold] > $bid)
			{
				echo 	"You have already bid $debt_pending towards other auctions.",
						"Your stockpile of gold is ", ($stockpile[gold] - $debt_pending),
						"which isn't enough to all for you to bid $bid.";

						display_auction_options();
			}
			else
			{
				echo 	"You have only have $stockpile[gold] in your stockpile.";

				display_auction_options();
			}
		}
		else if($_SESSION[id] == $high_bidder[player])
		{
			echo "Your current bid of $high_bid is already the highest bid on auction #$id.";
			display_auction_options();		
		}
		else if($bid > $high_bid)
		{
			$sql = "INSERT INTO feudemo_bid (	player,
															amount,
															auction)
												VALUES (	'$_SESSION[id]',
															'$bid',
															'$id')";
			$result_bid = mysql_query($sql);

			echo "Your bid of $bid on auction #$id has been placed.";

			display_auction_options();
		}
		else
		{
			echo "Your bid of $bid on auction #$id was not high enough to qualify.";

			bid_on_auction_form($id);			
		}
	}

	if($_POST[auction_tile] == "Auction Tile")								// if "Auction Tile" was pressed.
		create_auction_form("Tile");
	else if($_POST[auction_unit] == "Auction Unit")							// if "Auction Unit" was pressed.
		create_auction_form("Unit");
	else if($_POST[view_all_auctions] == "View All Auctions")			// if "View All Auctions" was pressed.
		view_auction_form("All");
	else if($_POST[view_your_auctions] == "View Your Auctions")			// if "View Your Auctions" was pressed.
		view_auction_form("Your");
	else if($_POST[create_auction] == "Create Auction")					// if Auction Form was filled out.
		create_auction_script($_POST[auction_type]);
	else if($_POST[details] == "Details")										// if "Details" was pressed in View Auctions.
		view_auction_details_form($_POST[auction_id]);
	else if($_POST[bid] == "Bid")													// if "Bid" was pressed in View Auctions of Details.
		bid_on_auction_form($_POST[auction_id]);
	else if($_POST[enter_bid] == "Enter Bid")									// if	Bid Form was filled out.	
		bid_on_auction_script($_POST[auction_id], $_POST[new_bid]);
	else																					// On entry to Auction page.
		display_auction_options();

?>