<?php

	include("../include/session.php");
	include("../include/database.php");

	function display_map_options()
	{
		echo "<form action=admin_map.php method=post>\n",
			"\t<table>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Admin Options:</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=create value=\"Create Map\" size=32></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td><input type=submit name=edit value=\"Edit Tiles\" size=32></td>\n",
				"\t\t</tr>\n",
			"\t<table>\n",
		"</form>\n\n";			
	}

	function display_map_select_options($selected)
	{
		$result = get_database_results("name,tiles", "feudemo_map", "1");

		while($mapsize = mysql_fetch_array($result))
		{
			if($selected == $mapsize[id])
				echo "\t\t\t\t<option value=$mapsize[tiles] selected>$mapsize[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$mapsize[tiles]>$mapsize[name]</option>\n";
		}
	}

	function display_type_select_options($selected)
	{
		$type_list = get_database_results("id,name", "feudemo_tile_types", "1");

		while($type = mysql_fetch_array($type_list))
		{
			if($selected == $type[id])
				echo "\t\t\t\t<option value=$type[id] selected>$type[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$type[id]>$type[name]</option>\n";
		}
	}

	function display_resource_select_options($selected)
	{
		$resource_list = get_database_results("id,name", "feudemo_resource", "1");

		while($resource = mysql_fetch_array($resource_list))
		{
			if($selected == $resource[id])
				echo "\t\t\t\t<option value=$resource[id] selected>$resource[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$resource[id]>$resource[name]</option>\n";
		}
	}

	function display_owner_select_options($selected)
	{
		$owner_list = get_database_results("id,name", "feudemo_player", "1");

		while($owner = mysql_fetch_array($owner_list))
		{
			if($selected == $owner[id])
				echo "\t\t\t\t<option value=$owner[id] selected>$owner[name]</option>\n";
			else
				echo "\t\t\t\t<option value=$owner[id]>$owner[name]</option>\n";
		}
	}

	function display_improvements_checkboxes($selected)
	{
		$improvement_list = get_database_results("name", "feudemo_improvements", "1");

		$i = 0;

		echo 	"\t\t\t\t<table border=0>\n",
					"\t\t\t\t\t<tr>\n";

		while($improvement = mysql_fetch_array($improvement_list))
		{
			$bit = $selected & 1;
			$selected = $selected >> 1;
			$formatted_name = str_replace(" ", "_", $improvement[name]);
			if($i % 2)
			{
				if($bit == 1)
					echo "\t\t\t\t\t\t<td><input type=checkbox checked name=improvement_$formatted_name>$improvement[name]</td>\n";
				else
					echo "\t\t\t\t\t\t<td><input type=checkbox name=improvement_$formatted_name>$improvement[name]</td>\n";
			}
			else
			{
				if($bit == 1)
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox checked name=improvement_$formatted_name>$improvement[name]</td>\n";
				else
					echo 	"\t\t\t\t\t</tr>\n",
							"\t\t\t\t\t<tr>\n",
							"\t\t\t\t\t\t<td><input type=checkbox name=improvement_$formatted_name>$improvement[name]</td>\n";
			}
			$i++;
		}
		echo		"\t\t\t\t\t</tr>\n",
				"\t\t\t\t</table>\n";
	}

	function create_map_form()
	{
		echo 	"<p><b>Create New Map</b></p>\n";	
		echo 	"<p><b>WARNING! Will overwrite any current map data!</b></p>\n";	

		echo 	"<form action=admin_map.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Map Size:</td>\n",
					"\t\t\t<td><select name=tiles size=1>\n",
						display_map_select_options();
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=map_create value=Create>\n",
						"\t\t\t\t<input type=hidden name=create value=Create>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function create_map_script()
	{
		$sql = "DELETE FROM feudemo_tile";
		$result = mysql_query($sql);

		$map = get_database_entry("width,height", "feudemo_map", "tiles = '$_POST[tiles]'");

		$tile_x = 0;
		$tile_y = 0;

		for($row = 0; $row < $map[height]; $row++)
		{
			for($col = 0; $col < ($map[width] / 2); $col++)
			{
				if($row % 2)
				{
					$y = 1 + ($col * 2);
					$sql = "INSERT INTO feudemo_tile (x, y) VALUES ('$y', '$row')";
				}
				else
				{
					$y = $col * 2;
					$sql = "INSERT INTO feudemo_tile (x, y) VALUES ('$y', '$row')";
				}
				$result = mysql_query($sql);
			}
		}

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Created $_POST[tiles] Tiles.</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Width:</td><td>$map[width]</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Height:</td><td>$map[height]</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";
		echo "\n<a href=\"admin_map.php\">Go back to Map Admin page.</a>";	
	}

	function edit_tile_choice_form()
	{
		echo 	"<p><b>Edit Tile</b></p>\n";	

		echo 	"<form action=admin_map.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile X:</td>\n",
					"\t\t\t<td><input type=text name=tile_x size=32 value=$tile_x></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Y:</td>\n",
					"\t\t\t<td><input type=text name=tile_y size=32 value=$tile_y></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=edit_tile_choice value=Edit>\n",
						"\t\t\t\t<input type=hidden name=edit value=Edit>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function edit_tile_details_form()
	{
		$tile = get_database_entry("*", "feudemo_tile", "x = '$_POST[tile_x]' AND y = '$_POST[tile_y]'");

		echo 	"<p><b>Edit Tile</b></p>\n";	

		echo 	"<form action=admin_map.php method=post>\n",
			"\t<table border=0>\n",
				"\t\t<tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Name:</td>\n",
					"\t\t\t<td><input type=text name=tile_name size=32 value=$tile[name]></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Owner:</td>\n",
					"\t\t\t<td><select name=tile_owner size=1>\n",
						"\t\t\t\t<option value=0>No Owner</option>\n";
						display_owner_select_options($tile[owner]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Coords:</td>\n",
					"\t\t\t<td>$tile[x],$tile[y]</td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Type:</td>\n",
					"\t\t\t<td><select name=tile_type size=1>\n",
						"\t\t\t\t<option value=0>Unknown</option>\n";
						display_type_select_options($tile[type]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Resource:</td>\n",
					"\t\t\t<td><select name=tile_resource size=1>\n",
						"\t\t\t\t<option value=0>None</option>\n";
						display_resource_select_options($tile[resource]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td>Tile Improvements:</td>\n",
					"\t\t\t<td>\n";
						display_improvements_checkboxes($tile[improvements]);
		echo		"\t\t\t</select></td>\n",
				"\t\t</tr>\n",
				"\t\t<tr>\n",
					"\t\t\t<td colspan=2 align=right>\n",
						"\t\t\t\t<input type=submit name=edit_tile_details value=Save>\n",
						"\t\t\t\t<input type=hidden name=edit value=Edit>\n",
						"\t\t\t\t<input type=hidden name=tile_id size=32 value=$tile[id]>\n",
					"\t\t\t</td>\n",
				"\t\t</tr>\n",
			"\t</table>\n",
		"</form>\n";
	}

	function edit_tile_script()
	{
		$improvement_list = get_database_results("id,name", "feudemo_improvements", "1 ORDER BY id DESC");

		while($improvement = mysql_fetch_array($improvement_list))
		{
			$temp = "improvement_" . str_replace(" ", "_", $improvement[name]);
			if($_POST[$temp] == "on")
			{
				$bitwise_string = $bitwise_string . "1";
			}
			else
				$bitwise_string = $bitwise_string . "0";
		}
		$improvements = bindec($bitwise_string);

		$sql = "UPDATE feudemo_tile 	SET 	name = '$_POST[tile_name]',
														owner = '$_POST[tile_owner]',
														type = '$_POST[tile_type]',
														resource = '$_POST[tile_resource]',
														improvements = '$improvements' 
												WHERE id = '$_POST[tile_id]'";
		$result = mysql_query($sql);

		echo "\t<table>\n",
					"\t\t<tr>\n",
						"\t\t\t<td colspan=2>Edited Tile $_POST[id]:</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Name:</td><td>", $_POST[tile_name], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Owner:</td><td>", $_POST[tile_owner], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Type:</td><td>", $_POST[tile_type], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Resource:</td><td>", $_POST[tile_resource], "</td>\n",
					"\t\t</tr>\n",
					"\t\t<tr>\n",
						"\t\t\t<td>Improvements:</td><td>", $bitwise_string, "</td>\n",
					"\t\t</tr>\n",
				"\t<table>\n\n";
		echo "\n<a href=\"admin_map.php\">Go back to Map Admin page.</a>";	
	}

	connect_to_database();

	if($_SESSION[id] != 1)
		echo "You must be logged in with an admin account to access this page.";
	else if($create != "")
	{
		if($map_create != "")
			create_map_script();
		else
			create_map_form();
	}
	else if($edit != "")
	{
		if($edit_tile_details != "")
			edit_tile_script();
		if($edit_tile_choice != "")
			edit_tile_details_form();
		else
			edit_tile_choice_form();
	}
	else
		display_map_options();	

?>