//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ source
// Description  : 
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
// DOTNET
// - If defined then code that will work on the .NET platform will be used
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Marked DOTNET
//
//----------------------------------------------------------------------------


#include "c3.h"

#include "aui_stringtable.h"
#include "netshell.h"
#include "ns_gplayer.h"

#include "ns_tribes.h"
#include "ns_playersetup.h"


#if defined (DOTNET)
int ns_GPlayer::count = 7;
ns_GPlayer::Struct ns_GPlayer::list[] = {
	{ICON,	 0},//	(Data)&m_host},
	{ICON,	 0},//	(Data)&m_launched},
	{STRING, 0},//	(Data)&m_name},
	{INT,	 0},//	(Data)&m_ping},
	{STRING, 0},//	(Data)&m_tribe},

	{INT,	 0},//	(Data)&m_civpoints},
	{INT,	 0},//	(Data)&m_pwpoints}
};
#else
int ns_GPlayer::count = 7;
ns_GPlayer::Struct ns_GPlayer::list[] = {
	{ICON,		(Data)&m_host},
	{ICON,		(Data)&m_launched},
	{STRING,	(Data)&m_name},
	{INT,		(Data)&m_ping},
	{STRING,	(Data)&m_tribe},

	{INT,		(Data)&m_civpoints},
	{INT,		(Data)&m_pwpoints}
};
#endif



void ns_GPlayer::Update( NETFunc::Player *player ) {
	SetMine(player->IsMe());
	m_launched = player->IsReadyToLaunch() ? g_netshell->GetTrueBmp() : 0;
	m_host = player->IsHost() ? g_netshell->GetTrueBmp() : 0;
	m_name = player->GetName();
	m_ping = player->GetLatency();



	nf_PlayerSetup ps( player );
	m_tribe = g_nsTribes->GetStrings()->GetString( ps.GetTribe() );
	m_civpoints = ps.GetCivPoints();
	m_pwpoints = ps.GetPwPoints();
}
