//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ header file
// Description  : declarations for the SettleMap class
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
// DOTNET
// - If defined then code that will work on the .NET platform will be used
//
// _MSC_VER		
// - When defined, uses Microsoft C++ specific features.
// - When not defined, generates standard C++.
//
// Note: For the blocks with _MSC_VER preprocessor directives, the following
//       is implied: the (_MSC_VER) preprocessor directive lines and the blocks 
//       between #else and #endif are modified Apolyton code. The blocks 
//       between #if and #else are the original Activision code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Marked DOTNET
//
//----------------------------------------------------------------------------

#pragma once
#ifndef __SETTLE_MAP_H__
#define __SETTLE_MAP_H__

#include "c3.h"
#include "c3debugstl.h"

#include "Unit.h"
#include "CivArchive.h"
#include "Bit_Table.h"
#include "MapPoint.h"
#include "MapGrid.h"

#if defined (DOTNET)
#include <list>
#else
#include <list-fixed>
#endif


const sint16 k_minimum_settle_city_size = 2;


const sint32 k_targets_per_continent = 25;

class SettleMap {
public:

	static SettleMap s_settleMap;

	
	
	
	void Cleanup();

	
	void Initialize();

	
	void HandleCityGrowth(const Unit & city);

	struct SettleTarget
	{
		SettleTarget() { m_value = 0.0;	}
		bool operator<(const SettleTarget & rval) const { return ( m_value < rval.m_value ); }
		bool operator>(const SettleTarget & rval) const { return ( m_value > rval.m_value ); }
		double m_value;
		MapPoint m_pos;
	};

#ifdef _DEBUG

	#if defined (DOTNET)
	typedef std::list<SettleTarget, std::allocator< SettleTarget > > SettleTargetList;
	#else
	typedef std::list<SettleTarget, dbgallocator< SettleTarget > > SettleTargetList;
	#endif // DOTNET

#else
	typedef std::list<SettleTarget > SettleTargetList;
#endif

	
	void GetSettleTargets(const PLAYER_INDEX &player, 
						  const bool & settle_water,
						  SettleMap::SettleTargetList & targets) const;
	
	
	bool CanSettlePos(const MapPoint & rc_pos) const;

	
	void SetCanSettlePos(const MapPoint & rc_pos, const bool can_settle);

	
	double GetValue(const MapPoint & rc_pos) const;

private:	
	
	SettleMap();

	
	double ComputeSettleValue(const MapPoint & pos) const;

    MapGrid<double> m_settleValues;
	Bit_Table m_invalidCells;
	
	
};

#endif 




