//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ header file
// Description  : 
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
// DOTNET
// - If defined then code that will work on the .NET platform will be used
//
// _MSC_VER		
// - When defined, uses Microsoft C++ specific features.
// - When not defined, generates standard C++.
//
// Note: For the blocks with _MSC_VER preprocessor directives, the following
//       is implied: the (_MSC_VER) preprocessor directive lines and the blocks 
//       between #else and #endif are modified Apolyton code. The blocks 
//       between #if and #else are the original Activision code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Marked DOTNET
//
//----------------------------------------------------------------------------

#pragma once

#ifndef __CTP_AGENT_H__
#define __CTP_AGENT_H__ 1

#include <vector>

#include "Scheduler_Types.h"
#include "Agent.h"


#include "c3debugstl.h"
#include "Army.h"
#include "Path.h"


class CTPAgent;
typedef CTPAgent* CTPAgent_ptr;

class CTPAgent : public Agent { 

public:
	
	
	
	
	

	
	
	
	
	
#if defined (DOTNET)
	static std::vector<sint32, std::allocator<sint32> > s_orderDBToEventMap;
#else
	static std::vector<sint32, dbgallocator<sint32> > s_orderDBToEventMap;
#endif
	static void AssociateEventsWithOrdersDB();

  	
  	
    
	
  	

	
	
	

  	
	CTPAgent();

	
	CTPAgent(const CTPAgent &agent);
	
  	
  	virtual ~CTPAgent();

	
	
	virtual void Init();

	
	virtual CTPAgent & operator= (const CTPAgent & agent);

    
    const Army & Get_Army() const;

	
    void Set_Army(const Army & army);

	
    PLAYER_INDEX Get_Player_Number() const;
    
	
    void Set_Player_Number(const PLAYER_INDEX & playerId);

	
	bool Get_Is_Dead() const;

	
	SQUAD_CLASS Compute_Squad_Class();

	
	MapPoint Get_Pos() const;

	
	bool IsArmyPosFilled() const;

	
	bool CanMove() const;

	
    const Squad_Strength & Compute_Squad_Strength();

	
    
    

	
    virtual void Log_Debug_Info(const int & log) const;

	
	
	

	
	bool FindPathToBoard( const uint32 & move_intersection, const MapPoint & dest_pos, const bool & check_dest, Path & found_path );

	
	static bool FindPath(const Army & army, const MapPoint & target_pos, const bool & check_dest, Path & found_path );

	
	sint32 GetRounds(const MapPoint & pos, sint32 & cells) const;

	
	
	bool EstimateTransportUtility(const CTPAgent_ptr transport, double & utility) const;

	
	
	

	
	void Set_Target_Order(const sint32 order_type);
	void Set_Target_Pos(const MapPoint &order_pos);
	sint32 Get_Target_Order() const;
	const MapPoint & Get_Target_Pos() const;

	
	bool Follow_Path(const Path & found_path, const sint32 & order_type);

	
	bool Can_Execute_Order(const sint32 & order_type) const;

	
	void Execute_Order(const sint32 & order_type, const MapPoint & order_pos);

	
	void Group_Order();

	
	void Group_With( CTPAgent_ptr second_army );

	
	void Ungroup_Order();

	
	sint32 DisbandObsoleteUnits();

	
	void MoveIntoTransport();
	
protected:

	
	
	
	
	

    
    Army m_army;

    
    sint16 m_playerId;

	
	sint32 m_targetOrder;
	MapPoint m_targetPos;
};

#endif __CTP_AGENT_H__
