//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ header file
// Description  : declarations for the Foreigner class
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
// DOTNET
// - If defined then code that will work on the .NET platform will be used
//
// _MSC_VER		
// - When defined, uses Microsoft C++ specific features.
// - When not defined, generates standard C++.
//
// Note: For the blocks with _MSC_VER preprocessor directives, the following
//       is implied: the (_MSC_VER) preprocessor directive lines and the blocks 
//       between #else and #endif are modified Apolyton code. The blocks 
//       between #if and #else are the original Activision code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Marked DOTNET
//
//----------------------------------------------------------------------------

#pragma once
#ifndef __FOREIGNER_H__
#define __FOREIGNER_H__



#pragma warning(disable: 4786)


#include <list>
#include <deque>

#include "c3debugstl.h"

#include "DiplomatTypes.h"
#include "DiplomacyRecord.h"
#include "MapPoint.h"





struct RegardEvent {
	RegardEvent() : turn(-1), explainStrId(-1), duration(-1) {}
	RegardEvent(const ai::Regard r, 
		const sint16 t,
		const StringId e,
		const sint16 d) : regard(r), turn(t), explainStrId(e), duration(d) {};
	bool operator>(const RegardEvent & a) const {
		return ((regard > a.regard) && (turn > a.turn));
	}
	ai::Regard regard;		
	sint16 turn;		
	StringId explainStrId;
	sint16 duration;    
};

#ifdef _DEBUG

	#if defined (DOTNET)
	typedef std::list<RegardEvent, std::allocator<RegardEvent> > RegardEventList;
	typedef std::deque<NegotiationEvent, std::allocator<NegotiationEvent> > NegotiationEventList;
	typedef std::list<ai::Agreement, std::allocator<ai::Agreement> > AgreementList;
	#else
	typedef std::list<RegardEvent, dbgallocator<RegardEvent> > RegardEventList;
	typedef std::deque<NegotiationEvent, dbgallocator<NegotiationEvent> > NegotiationEventList;
	typedef std::list<ai::Agreement, dbgallocator<ai::Agreement> > AgreementList;
	#endif
	typedef AgreementList::iterator AgreementListIter;
#else
	
	typedef std::list<RegardEvent> RegardEventList;
	typedef std::deque<NegotiationEvent> NegotiationEventList;
	typedef std::list<ai::Agreement> AgreementList;
	typedef AgreementList::iterator AgreementListIter;
#endif

class Foreigner {

public:

	
	
	

	
	Foreigner();

	
	void Initialize();

	
	void Load(CivArchive & archive);

	
	void Save(CivArchive & archive) const;

	
	void BeginTurn();

	
	
	

	
	const ai::Regard & GetEffectiveRegard() const;

	
	const ai::Regard & GetPublicRegard(const REGARD_EVENT_TYPE &type = REGARD_EVENT_ALL ) const;

	
	const ai::Regard & GetTrust() const;

	
	void SetTrust(const ai::Regard &trust);

	
	
	

	
	void LogRegardEvent( const REGARD_EVENT_TYPE & type, 
		const RegardEvent & regardEvent );
		
	
	
	void RecomputeRegard(const DiplomacyRecord & diplomacy,
						 const sint32 & decayRound,
						 const ai::Regard baseRegard);

	
	const StringId & GetBestRegardExplain(const REGARD_EVENT_TYPE &type = REGARD_EVENT_ALL) const;

	
	
	

	
	void ConsiderResponse( const Response & response );

	
	const Response & GetMyLastResponse() const;

	
	void SetMyLastResponse(const Response & response);

	
	
	

	
	void AddTradeValue(const sint32 value);

	
	sint32 GetTradeFrom() const;

	
	sint32 GetTributeFrom() const;

	
	
	

	
	void ConsiderNewProposal(const NewProposal & newProposal );

	
	const NewProposal & GetMyLastNewProposal() const;

	
	void SetMyLastNewProposal(const NewProposal & newProposal);

	
	bool m_hasInitiative;

	
	
	

	
	void SetMyLastNegotiatedProposal( const ProposalData & data, const RESPONSE_TYPE & response )
		{ 
			m_lastNegotiatedProposal = data;
			m_lastNegotiatedProposalResult = response;
		}
	
	
	RESPONSE_TYPE GetMyLastNegotiatedProposal( ProposalData & data ) const 
		{ 
			data = m_lastNegotiatedProposal;
			return m_lastNegotiatedProposalResult;
		}

	
	NegotiationEventList::const_iterator GetNegotiationEventIndex( const NewProposal & newProposal ) const;

	
	bool GetNewProposalTimeout(const NewProposal & newProposal, 
							   const sint16 timeout_period) const;

	
	void AddNewNegotiationEvent(const NegotiationEvent & dip);

	
	const NegotiationEventList & GetNegotiationEvents() const;

	
	
	

	
	void SetLastIncursion(const sint32 last_incursion);

	
	sint32 GetLastIncursion() const;

	
	void SetHotwarAttack(const sint16 last_hot_war_attack);

	
	sint16 GetLastHotwarAttack() const;

	
	void SetColdwarAttack(const sint16 last_cold_war_attack);

	
	sint16 GetLastColdwarAttack() const;

	
	void SetGreetingTurn();

	
	sint16 GetTurnsSinceGreeting() const;

	
	bool GetEmbargo() const;

	
	void SetEmbargo(const bool state);

	
	void DebugStatus() const;

	
	void LogDebugStatus(const DiplomacyRecord & diplomacy) const;

protected:
	
private:

	
	
	ai::Regard m_regard[REGARD_EVENT_ALL];  
	ai::Regard m_regardTotal;			  
	StringId m_bestRegardExplain;	  
	ai::Regard m_effectiveRegardModifier; 
	ai::Regard m_trustworthiness;		  

	
	RegardEventList m_regardEventList[REGARD_EVENT_ALL];

	
	NewProposal m_myLastNewProposal;

	
	Response m_myLastResponse;

	
	sint32 m_goldFromTrade;
	sint32 m_goldFromTribute;

	
	sint32 m_lastIncursion;

	
	RESPONSE_TYPE m_lastNegotiatedProposalResult;
	ProposalData m_lastNegotiatedProposal;

	NegotiationEventList m_negotiationEvents;

	sint16 m_hotwarAttackedMe;  
	sint16 m_coldwarAttackedMe; 

	sint16 m_greetingTurn;		
	bool m_embargo;				

	

































};

#endif __FOREIGNER_H__
